/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Messages {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("de.businesslogics.banking.database.messages");

    private Messages() {
    }

    public static String getString(String key) {
        try {
            return BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String getString(Locale locale, String key, Object ... params) {
        Object result;
        if (locale.getLanguage().equals(Locale.getDefault().getLanguage())) {
            result = Messages.getString(key);
        } else {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.banking.database.messages", locale);
                result = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                result = "!" + key + "!";
            }
        }
        if (params != null && params.length > 0) {
            return new MessageFormat((String)result, locale).format(params);
        }
        return result;
    }
}

