/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database;

import de.businesslogics.banking.database.update.DatabaseUpdateHandler;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.BLLogger;
import io.ebean.Database;
import io.ebean.Transaction;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Scanner;

public class DatabaseUpdateRunner {
    private final BLLogger logger;
    private final File workspace;
    private Integer currentVersion = null;
    private final LinkedHashMap<Integer, String> updatedToDo = new LinkedHashMap();
    private SQLException updateException;
    private Integer updateExceptionLineNumber = null;

    public DatabaseUpdateRunner(BLLogger logger, File workspace) {
        this.logger = logger;
        this.workspace = workspace;
    }

    public SQLException getUpdateException() {
        return this.updateException;
    }

    public LinkedHashMap<Integer, String> getUpdatesToDo() {
        return this.updatedToDo;
    }

    public Integer getCurrentUpdateVersion() {
        return this.currentVersion;
    }

    public Integer getUpdateExceptionLineNumber() {
        return this.updateExceptionLineNumber;
    }

    public DBType checkDatabaseConnection(Database ebeanServer, DBType dbType, String schema) throws SQLException {
        try (Transaction t = ebeanServer.beginTransaction();){
            Connection conn = t.connection();
            DatabaseMetaData metaData = conn.getMetaData();
            if (dbType == null && (dbType = DBType.getInstance(conn)) != DBType.H2 && dbType != DBType.MYSQL && dbType != DBType.ORACLE && dbType != DBType.MSSQL && dbType != DBType.PSQL) {
                throw new RuntimeException("Unsupported database type: " + metaData.getDatabaseProductName());
            }
            ResultSet appInfoTableRS = metaData.storesUpperCaseIdentifiers() ? metaData.getTables(conn.getCatalog(), schema, "APPLICATIONINFO", null) : metaData.getTables(conn.getCatalog(), schema, "applicationinfo", null);
            if (!appInfoTableRS.next()) {
                InputStream sqlInputStream = this.getClass().getResourceAsStream(String.format("/ddl-scripts/create_%s.sql", dbType.name().toLowerCase()));
                if (sqlInputStream == null) {
                    throw new RuntimeException("No create script available for database type " + dbType.name());
                }
                if (!this.executeDatabaseScriptFromInputStream(conn, sqlInputStream)) {
                    DBType dBType = dbType;
                    return dBType;
                }
                t.commit();
            }
        }
        return dbType;
    }

    public LinkedHashMap<Integer, String> findDatabaseUpdateScripts(Database ebeanServer, DBType dbType) {
        ApplicationInfo applicationInfo = (ApplicationInfo)ebeanServer.find(ApplicationInfo.class, (Object)ApplicationInfo.PropKey.db_layout.name());
        if (applicationInfo == null || applicationInfo.getPropValue() == null) {
            throw new RuntimeException("No database version is specified in the database!");
        }
        int nextDbVersion = Integer.parseInt(applicationInfo.getPropValue());
        String scriptName = String.format("/ddl-scripts/update_%03d/update_%s.sql", nextDbVersion, dbType.name().toLowerCase());
        if (this.getClass().getResourceAsStream(scriptName) == null) {
            int knownVersion = nextDbVersion;
            do {
                scriptName = String.format("/ddl-scripts/update_%03d/update_%s.sql", --knownVersion, dbType.name().toLowerCase());
            } while (knownVersion > 0 && this.getClass().getResourceAsStream(scriptName) == null);
            throw new RuntimeException("Database version (" + nextDbVersion + ") is newer as we can handle (" + knownVersion + "). Check installed version");
        }
        do {
            scriptName = String.format("/ddl-scripts/update_%03d/update_%s.sql", ++nextDbVersion, dbType.name().toLowerCase());
            if (this.getClass().getResourceAsStream(scriptName) != null) {
                this.updatedToDo.put(nextDbVersion, scriptName);
                continue;
            }
            scriptName = null;
        } while (scriptName != null);
        return this.updatedToDo;
    }

    public void executeUpdate(Database ebeanServer, DBType dbType, String schema, String updateScriptResource, int version) throws SQLException {
        this.currentVersion = version;
        InputStream scriptInputStream = this.getClass().getResourceAsStream(updateScriptResource);
        if (scriptInputStream != null) {
            this.logger.logInfo("Running database update to version " + version);
            try (Transaction t = ebeanServer.beginTransaction();){
                Connection connection = t.connection();
                DatabaseUpdateHandler dbUpdateHandler = DatabaseUpdateHandler.Finder.findDatabaseUpdateHandler(version);
                if (dbUpdateHandler != null) {
                    dbUpdateHandler.setSchema(schema);
                    dbUpdateHandler.setWorkspace(this.workspace);
                    dbUpdateHandler.prepareForUpdate(connection, dbType);
                }
                if (!this.executeDatabaseScriptFromInputStream(connection, scriptInputStream)) {
                    return;
                }
                if (dbUpdateHandler != null) {
                    dbUpdateHandler.postProcessUpdate(connection, dbType);
                }
                t.commit();
            }
        }
    }

    private boolean executeDatabaseScriptFromInputStream(Connection conn, InputStream sqlInputStream) throws SQLException {
        int currentline = 0;
        Scanner sqlInputScanner = new Scanner(sqlInputStream, "ISO-8859-1");
        try {
            Object statementString = null;
            while (sqlInputScanner.hasNextLine()) {
                ++currentline;
                String statementStringLine = sqlInputScanner.nextLine().trim();
                if (statementStringLine.length() == 0 || statementStringLine.startsWith("//") || statementStringLine.startsWith("--") || statementStringLine.startsWith("#") || !((String)(statementString = statementString == null ? statementStringLine : (String)statementString + " " + statementStringLine)).endsWith(";")) continue;
                this.executeStatement(conn, ((String)statementString).substring(0, ((String)statementString).length() - 1));
                statementString = null;
            }
            if (statementString != null && ((String)statementString).length() > 1) {
                this.executeStatement(conn, ((String)statementString).substring(0, ((String)statementString).length() - 1));
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            boolean bl = true;
            sqlInputScanner.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sqlInputScanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.logger.logError("Failed to execute statement in line: " + currentline, e);
                this.updateException = e;
                this.updateExceptionLineNumber = currentline;
                throw e;
            }
        }
    }

    private void executeStatement(Connection conn, String sqlStatement) throws SQLException {
        if (sqlStatement == null) {
            return;
        }
        String trimmedSqlStatement = sqlStatement.trim();
        if (trimmedSqlStatement.endsWith(";")) {
            trimmedSqlStatement = trimmedSqlStatement.substring(0, trimmedSqlStatement.length() - 1);
        }
        if (trimmedSqlStatement.length() == 0) {
            return;
        }
        PreparedStatement stmt = conn.prepareStatement(trimmedSqlStatement);
        stmt.execute();
        stmt.close();
    }
}

