/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database;

import de.businesslogics.banking.database.DatabaseUpdateRunner;
import de.businesslogics.banking.database.Messages;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.api.DatabaseConnection;
import de.businesslogics.banking.database.api.DatabaseMigrationException;
import de.businesslogics.banking.database.api.JdbcSettings;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.SclDirectory;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.IProgressMonitorWrapper;
import io.ebean.Database;
import io.ebean.Query;
import io.ebean.SqlRow;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;

public class DatabaseMigrationRunner {
    private final DBType dbType;
    private final String jdbcUrl;
    private final String dbUser;
    private final String dbPassword;
    private final boolean testConnection;
    private final BLLogger logger;
    private final File workspaceDirectory;
    private final Locale locale;
    private String errorMessage;
    private boolean canceled;

    public DatabaseMigrationRunner(DBType dbType, String jdbcUrl, String dbUser, String dbPassword, boolean testConnection, BLLogger logger, File workspaceDirectory, Locale locale) {
        this.dbType = dbType;
        this.jdbcUrl = jdbcUrl;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
        this.testConnection = testConnection;
        this.logger = logger;
        this.workspaceDirectory = workspaceDirectory;
        this.locale = locale;
    }

    public void run(IProgressMonitorWrapper monitor) throws InvocationTargetException, InterruptedException {
        String taskMessage = this.testConnection ? Messages.getString(this.locale, "DatabaseMigration.testRunning", new Object[0]) : Messages.getString(this.locale, "DatabaseMigration.migrationRunning", new Object[0]);
        monitor.beginTask(taskMessage, 5000);
        try {
            if (this.testConnection) {
                Connection connection = this.openConnection();
                this.closeConnection(connection);
            } else {
                this.runMigration(monitor);
            }
        }
        catch (DatabaseMigrationException e) {
            this.logger.logError("Problem in database migration!", e);
            this.errorMessage = e.getLocalizedMessage();
        }
        catch (Throwable e) {
            this.logger.logError("Database migration failed!", e);
            this.errorMessage = Messages.getString(this.locale, "DatabaseMigration.failedToMigrateDatabase", e.getLocalizedMessage());
        }
        this.canceled = monitor.isCanceled();
        monitor.done();
    }

    public boolean wasMigrationSuccessful() {
        return this.errorMessage == null && !this.canceled;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private Connection openConnection() throws DatabaseMigrationException {
        this.getJdbcDriver();
        try {
            return DriverManager.getConnection(this.jdbcUrl, this.dbUser, this.dbPassword);
        }
        catch (SQLException e) {
            throw new DatabaseMigrationException(Messages.getString(this.locale, "DatabaseMigration.failedToConnectToDatabase", e.getLocalizedMessage()), e);
        }
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.logger.logError("Failed to close JDBC connection!", e);
            }
        }
    }

    private Class<?> getJdbcDriver() throws DatabaseMigrationException {
        String dbDriverClass;
        if (this.dbType == DBType.H2) {
            dbDriverClass = "org.h2.Driver";
        } else if (this.dbType == DBType.HSQL) {
            dbDriverClass = "org.hsqldb.jdbc.JDBCDriver";
        } else if (this.dbType == DBType.MYSQL) {
            dbDriverClass = "com.mysql.cj.jdbc.Driver";
        } else if (this.dbType == DBType.MSSQL) {
            dbDriverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else if (this.dbType == DBType.ORACLE) {
            dbDriverClass = "oracle.jdbc.driver.OracleDriver";
        } else if (this.dbType == DBType.PSQL) {
            dbDriverClass = "org.postgresql.Driver";
        } else {
            throw new DatabaseMigrationException(Messages.getString(this.locale, "DatabaseMigration.failedToLoadDbDriver", new Object[0]));
        }
        try {
            return Class.forName(dbDriverClass);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseMigrationException(Messages.getString(this.locale, "DatabaseMigration.failedToLoadDbDriver", new Object[0]), e);
        }
    }

    private void runMigration(IProgressMonitorWrapper monitor) throws DatabaseMigrationException {
        Database newEbeanServer = DatabaseConnection.createNewEbeanServer(new JdbcSettings(this.workspaceDirectory, this.dbType, this.jdbcUrl, this.dbUser, this.dbPassword));
        if (newEbeanServer == null) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(500);
        String targetSchema = this.dbType == DBType.ORACLE ? this.dbUser.toUpperCase() : null;
        this.createDatabaseIfNecessary(newEbeanServer, targetSchema);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(500);
        try {
            Connection targetConnection = newEbeanServer.beginTransaction().connection();
            String targetCatalog = targetConnection.getCatalog();
            DatabaseMetaData metaData = targetConnection.getMetaData();
            newEbeanServer.endTransaction();
            List<Class<?>> entityClasses = this.findEntityClassesList(newEbeanServer, metaData, targetCatalog, targetSchema);
            Map<String, Set<String>> manyToManyTables = this.findManyToManyTables(newEbeanServer, metaData, targetCatalog, targetSchema, entityClasses);
            Connection sourceConnection = DatabaseConnection.getInstance().getServer().beginTransaction().connection();
            String sourceCatalog = sourceConnection.getCatalog();
            String sourceSchema = new JdbcSettings(this.workspaceDirectory).getSchema();
            DatabaseMetaData metaDataCurrent = sourceConnection.getMetaData();
            DatabaseConnection.getInstance().getServer().endTransaction();
            Map<String, Set<String>> manyToManyTablesCurrent = this.findManyToManyTables(DB.getDefault(), metaDataCurrent, sourceCatalog, sourceSchema, DatabaseConnection.getInstance().getServerConfig().getClasses());
            if (!this.prepareDatabase(newEbeanServer, entityClasses, manyToManyTables.keySet(), monitor.newSubMonitor(1100))) {
                return;
            }
            monitor.worked(1);
            if (!this.copyAllTableEntries(newEbeanServer, entityClasses, manyToManyTables, manyToManyTablesCurrent, monitor.newSubMonitor(2800))) {
                return;
            }
            monitor.worked(1);
            this.updateSequenceNumbers(entityClasses, newEbeanServer, metaData, targetCatalog, targetSchema, monitor.newSubMonitor(100));
        }
        catch (IOException io) {
            throw new DatabaseMigrationException("JDBC properties not loaded:" + io.getLocalizedMessage(), io);
        }
        catch (SQLException e) {
            throw new DatabaseMigrationException(Messages.getString(this.locale, "DatabaseMigration.failedToMigrateDatabase", e.getLocalizedMessage()), e);
        }
        finally {
            monitor.worked(1);
        }
    }

    private void createDatabaseIfNecessary(Database ebeanServer, String schema) throws DatabaseMigrationException {
        try {
            DatabaseUpdateRunner updateRunner = new DatabaseUpdateRunner(this.logger, this.workspaceDirectory);
            updateRunner.checkDatabaseConnection(ebeanServer, this.dbType, schema);
            LinkedHashMap<Integer, String> updateMap = updateRunner.findDatabaseUpdateScripts(ebeanServer, this.dbType);
            for (Integer version : updateMap.keySet()) {
                updateRunner.executeUpdate(ebeanServer, this.dbType, schema, (String)updateMap.get(version), version);
            }
        }
        catch (SQLException e) {
            throw new DatabaseMigrationException(Messages.getString(this.locale, "DatabaseMigration.failedToPrepareDatabase", e.getLocalizedMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareDatabase(Database ebeanServer, List<Class<?>> entityClasses, Set<String> manyToManyTables, IProgressMonitorWrapper monitor) {
        monitor.beginTask(Messages.getString(this.locale, "DatabaseMigration.clean", new Object[0]), entityClasses.size() + manyToManyTables.size());
        ebeanServer.beginTransaction();
        try {
            for (String manyToManyTable : manyToManyTables) {
                ebeanServer.sqlUpdate("DELETE FROM " + manyToManyTable).execute();
                monitor.worked(1);
            }
            for (int i = entityClasses.size() - 1; i >= 0; --i) {
                Class<?> c = entityClasses.get(i);
                String name = c.getName();
                StringBuilder ormUpdateBuilder = new StringBuilder("DELETE FROM ").append(name.substring(name.lastIndexOf(46) + 1));
                if (c == ApplicationInfo.class) {
                    ormUpdateBuilder.append(" WHERE prop_name != 'db_layout'");
                } else if (c == CmBooking.class) {
                    ebeanServer.createUpdate(CmBooking.class, "UPDATE cm_booking SET parentBooking = NULL").execute();
                } else if (c == Account.class) {
                    ebeanServer.createUpdate(PaymentOriginator.class, "UPDATE pmt_originator SET defaultAccount = NULL").execute();
                }
                ebeanServer.createUpdate(c, ormUpdateBuilder.toString()).execute();
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                boolean bl = false;
                return bl;
            }
            ebeanServer.commitTransaction();
        }
        finally {
            ebeanServer.endTransaction();
        }
        monitor.done();
        return true;
    }

    private boolean copyList(Query<?> query, Database newEbeanServer, IProgressMonitorWrapper monitor, Class<?> entityClass) throws SQLException {
        int COMMIT_BORDER = 10000;
        int rowCount = query.findCount();
        for (int i = 0; i < rowCount; i += COMMIT_BORDER) {
            List page = query.setFirstRow(i).setMaxRows(COMMIT_BORDER).findList();
            for (Object entityObject : page) {
                if (entityObject instanceof PaymentOriginator) {
                    ((PaymentOriginator)entityObject).setDefaultAccount(null);
                }
                if (entityObject instanceof ApplicationInfo && "db_layout".equals(((ApplicationInfo)entityObject).getPropName())) continue;
                newEbeanServer.insert(entityObject);
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return false;
            }
            this.switchIdentityInsert(newEbeanServer, entityClass, false);
            newEbeanServer.commitTransaction();
            newEbeanServer.beginTransaction();
            this.switchIdentityInsert(newEbeanServer, entityClass, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyAllTableEntries(Database newEbeanServer, List<Class<?>> entityClasses, Map<String, Set<String>> manyToManyTables, Map<String, Set<String>> manyToManyTablesCurrent, IProgressMonitorWrapper monitor) throws SQLException {
        int totalCount = 0;
        for (Class<?> aClass : entityClasses) {
            totalCount += DatabaseConnection.getInstance().getServer().find(aClass).findCount();
        }
        monitor.beginTask(Messages.getString(this.locale, "DatabaseMigration.copyTables", new Object[0]), entityClasses.size() + totalCount);
        try {
            for (Class<?> entityClass : entityClasses) {
                newEbeanServer.beginTransaction();
                this.switchIdentityInsert(newEbeanServer, entityClass, true);
                if (entityClass.equals(CmBooking.class)) {
                    q = DatabaseConnection.getInstance().getServer().find(entityClass).select("*").order("id asc").where().isNull("parentBooking").query();
                    if (!this.copyList(q, newEbeanServer, monitor, entityClass)) {
                        boolean bl = false;
                        return bl;
                    }
                    q = DatabaseConnection.getInstance().getServer().find(entityClass).select("*").order("id asc").where().isNotNull("parentBooking").query();
                    if (!this.copyList(q, newEbeanServer, monitor, entityClass)) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (entityClass.equals(Send.class)) {
                    q = DatabaseConnection.getInstance().getServer().find(entityClass).select("*").order("id asc").where().isNull("callback").query();
                    if (!this.copyList(q, newEbeanServer, monitor, entityClass)) {
                        boolean bl = false;
                        return bl;
                    }
                    q = DatabaseConnection.getInstance().getServer().find(entityClass).select("*").order("id asc").where().isNotNull("callback").query();
                    if (!this.copyList(q, newEbeanServer, monitor, entityClass)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    String idField = null;
                    for (Field field : DatabaseMigrationRunner.getFields(entityClass)) {
                        if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(Id.class)) continue;
                        idField = field.getName();
                        break;
                    }
                    Query q = DatabaseConnection.getInstance().getServer().find(entityClass).setIncludeSoftDeletes().select("*");
                    if (idField != null) {
                        q.order(idField + " asc");
                    }
                    if (!this.copyList(q, newEbeanServer, monitor, entityClass)) {
                        boolean field = false;
                        return field;
                    }
                    if (entityClass.equals(Account.class)) {
                        List list = DB.find(PaymentOriginator.class).where().isNotNull("defaultAccount").findList();
                        for (PaymentOriginator paymentOriginator : list) {
                            newEbeanServer.sqlUpdate("UPDATE pmt_originator set default_account_id=" + paymentOriginator.getDefaultAccount().getId() + " WHERE id=" + paymentOriginator.getId()).execute();
                        }
                    }
                }
                this.switchIdentityInsert(newEbeanServer, entityClass, false);
                monitor.worked(1);
                newEbeanServer.commitTransaction();
            }
            HashMap<String, String> tmpMapping = new HashMap<String, String>();
            for (String current : manyToManyTablesCurrent.keySet()) {
                for (String string : manyToManyTables.keySet()) {
                    if (!current.equalsIgnoreCase(string)) continue;
                    tmpMapping.put(current, string);
                }
            }
            for (String manyToManyTableCurrent : manyToManyTablesCurrent.keySet()) {
                Set<String> columnsCurrent = manyToManyTablesCurrent.get(manyToManyTableCurrent);
                StringBuilder queryBuilder = new StringBuilder("SELECT ");
                boolean first = true;
                for (String s : columnsCurrent) {
                    if (first) {
                        first = false;
                    } else {
                        queryBuilder.append(", ");
                    }
                    queryBuilder.append(s);
                }
                queryBuilder.append(" FROM ").append(manyToManyTableCurrent);
                String string = (String)tmpMapping.get(manyToManyTableCurrent);
                StringBuilder tmp = new StringBuilder("INSERT INTO ").append(string).append(" (");
                first = true;
                for (String s : columnsCurrent) {
                    if (first) {
                        first = false;
                    } else {
                        tmp.append(", ");
                    }
                    tmp.append(s);
                }
                tmp.append(") VALUES (");
                String update = tmp.toString();
                for (SqlRow row : DatabaseConnection.getInstance().getServer().sqlQuery(queryBuilder.toString()).findList()) {
                    queryBuilder = new StringBuilder(update);
                    first = true;
                    for (String s : columnsCurrent) {
                        if (first) {
                            first = false;
                        } else {
                            queryBuilder.append(", ");
                        }
                        queryBuilder.append(row.getString(s));
                    }
                    queryBuilder.append(")");
                    newEbeanServer.sqlUpdate(queryBuilder.toString()).execute();
                }
            }
        }
        finally {
            try {
                newEbeanServer.endTransaction();
            }
            catch (Throwable e) {
                this.logger.logError("Error ending transaction", e);
            }
        }
        monitor.done();
        return true;
    }

    private static Iterable<Field> getFields(Class<?> startClass) {
        ArrayList<Field> currentClassFields = new ArrayList<Field>();
        Collections.addAll(currentClassFields, startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null && !parentClass.equals(Object.class)) {
            List parentClassFields = (List)DatabaseMigrationRunner.getFields(parentClass);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    private void switchIdentityInsert(Database ebeanServer, Class<?> entityClass, boolean enable) throws SQLException {
        if (this.dbType == DBType.MSSQL && entityClass != ApplicationInfo.class && entityClass != SclDirectory.class && entityClass != License.class) {
            String name = DatabaseConnection.getTableName(ebeanServer, entityClass);
            StringBuilder queryBuilder = new StringBuilder("SET IDENTITY_INSERT ").append(name);
            if (enable) {
                queryBuilder.append(" ON");
            } else {
                queryBuilder.append(" OFF");
            }
            try (Statement stmt = ebeanServer.currentTransaction().connection().createStatement();){
                stmt.execute(queryBuilder.toString());
            }
        }
    }

    private List<Class<?>> findEntityClassesList(Database ebeanServer, DatabaseMetaData metadata, String catalog, String schema) throws SQLException {
        HashMap entityClassesMap = new HashMap();
        for (Class entityClass : DatabaseConnection.getInstance().getServerConfig().getClasses()) {
            entityClassesMap.put(DatabaseConnection.getTableName(ebeanServer, entityClass), entityClass);
        }
        ArrayList resultList = new ArrayList();
        ResultSet tablesResultSet = metadata.getTables(catalog, schema, null, new String[]{"TABLE"});
        while (tablesResultSet.next()) {
            this.addTableToResultList(resultList, tablesResultSet.getString(3), metadata, catalog, schema, entityClassesMap);
        }
        tablesResultSet.close();
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> findManyToManyTables(Database ebeanServer, DatabaseMetaData metaData, String catalog, String schema, List<Class<?>> entityClasses) throws SQLException, DatabaseMigrationException {
        Pattern genericTypePattern = Pattern.compile(".*<(.*)>.*");
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Class<?> entityClass : entityClasses) {
            for (Field field : entityClass.getDeclaredFields()) {
                HashSet<String> columnNames;
                Class<?> referencedType;
                Matcher genericTypeMatcher;
                ManyToMany a;
                if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(ManyToMany.class) || !Collection.class.isAssignableFrom(field.getType()) || (a = field.getAnnotation(ManyToMany.class)).mappedBy() != null && a.mappedBy().length() > 0 || !(genericTypeMatcher = genericTypePattern.matcher(field.toGenericString())).matches()) continue;
                try {
                    referencedType = Class.forName(genericTypeMatcher.group(1));
                }
                catch (ClassNotFoundException e) {
                    throw new DatabaseMigrationException("Failed to load VO class of the referenced entity!");
                }
                if (!entityClasses.contains(referencedType)) continue;
                JoinTable jt = field.getAnnotation(JoinTable.class);
                String tableName = jt != null && jt.name() != null ? jt.name() : DatabaseConnection.getM2MJoinTableName(ebeanServer, entityClass, referencedType);
                boolean foundTable = false;
                try (ResultSet metaDataResultSet = metaData.getTables(catalog, schema, null, new String[]{"TABLE"});){
                    while (metaDataResultSet.next()) {
                        if (!tableName.equalsIgnoreCase(metaDataResultSet.getString(3))) continue;
                        tableName = metaDataResultSet.getString(3);
                        foundTable = true;
                        break;
                    }
                }
                if (!foundTable) {
                    throw new DatabaseMigrationException("Didn't find junction table for class " + entityClass.getName() + ", field: " + field.getName());
                }
                metaDataResultSet = metaData.getColumns(catalog, schema, tableName, null);
                try {
                    columnNames = new HashSet<String>();
                    while (metaDataResultSet.next()) {
                        columnNames.add(metaDataResultSet.getString(4));
                    }
                }
                finally {
                    metaDataResultSet.close();
                }
                if (columnNames.size() > 0) {
                    result.put(tableName, columnNames);
                    continue;
                }
                throw new DatabaseMigrationException("Found invalid junction table with no columns: " + tableName);
            }
        }
        return result;
    }

    private void addTableToResultList(List<Class<?>> resultList, String tablename, DatabaseMetaData metadata, String catalog, String schema, Map<String, Class<?>> entityClassesMap) throws SQLException {
        Class<?> entityClass = null;
        for (String entityname : entityClassesMap.keySet()) {
            if (!entityname.equalsIgnoreCase(tablename)) continue;
            entityClass = entityClassesMap.get(entityname);
            break;
        }
        if (entityClass == null) {
            return;
        }
        if (resultList.contains(entityClass)) {
            return;
        }
        ResultSet importedForeignKeyResultSet = metadata.getImportedKeys(catalog, schema, tablename);
        HashSet<String> referencingTables = new HashSet<String>();
        while (importedForeignKeyResultSet.next()) {
            referencingTables.add(importedForeignKeyResultSet.getString(3));
        }
        importedForeignKeyResultSet.close();
        for (String referencingTable : referencingTables) {
            if (tablename.equalsIgnoreCase("pmt_originator") && referencingTable.equalsIgnoreCase("account") || tablename.equals(referencingTable)) continue;
            this.addTableToResultList(resultList, referencingTable, metadata, catalog, schema, entityClassesMap);
        }
        if (!resultList.contains(entityClass)) {
            resultList.add(entityClass);
        }
    }

    private void updateSequenceNumbers(List<Class<?>> entityClasses, Database ebeanServer, DatabaseMetaData dbMetaData, String catalog, String schema, IProgressMonitorWrapper monitor) throws SQLException {
        monitor.beginTask(Messages.getString(this.locale, "DatabaseMigration.updatingSequenceNumbers", new Object[0]), entityClasses.size());
        if (this.dbType != DBType.H2 && this.dbType != DBType.ORACLE && this.dbType != DBType.PSQL) {
            monitor.done();
            return;
        }
        ebeanServer.beginTransaction();
        ResultSet tablesResultSet = dbMetaData.getTables(catalog, schema, null, new String[]{"TABLE"});
        while (tablesResultSet.next()) {
            String tableName = tablesResultSet.getString(3);
            boolean foundTable = false;
            for (Class<?> entityClass : entityClasses) {
                if (!tableName.equalsIgnoreCase(DatabaseConnection.getTableName(ebeanServer, entityClass))) continue;
                foundTable = true;
                break;
            }
            if (!foundTable) continue;
            ResultSet pkResultSet = dbMetaData.getPrimaryKeys(catalog, schema, tableName);
            while (pkResultSet.next()) {
                String columnName = pkResultSet.getString(4);
                ResultSet columnsResultSet = dbMetaData.getColumns(catalog, schema, tableName, columnName);
                if (columnsResultSet.next() && this.isColumnTypeNumeric(columnsResultSet.getInt(5))) {
                    this.updateSequenceNumber(ebeanServer.currentTransaction().connection(), tableName, columnName);
                    columnsResultSet.close();
                    break;
                }
                columnsResultSet.close();
            }
            pkResultSet.close();
            monitor.worked(1);
        }
        ebeanServer.commitTransaction();
        ebeanServer.endTransaction();
        monitor.done();
    }

    private boolean isColumnTypeNumeric(int columnType) {
        return columnType == -6 || columnType == 5 || columnType == 4 || columnType == -5 || columnType == 2 || columnType == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSequenceNumber(Connection connection, String tablename, String columnname) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            ResultSet maxColResultSet = statement.executeQuery("SELECT MAX(" + columnname + ") FROM " + tablename);
            if (!maxColResultSet.next()) {
                return;
            }
            long maxNumber = maxColResultSet.getLong(1);
            maxColResultSet.close();
            if (this.dbType == DBType.ORACLE) {
                ResultSet lastNumberResultSet = statement.executeQuery("SELECT " + tablename + "_SEQ.NEXTVAL FROM DUAL");
                long lastNumber = lastNumberResultSet.next() ? lastNumberResultSet.getLong(1) : 1L;
                lastNumberResultSet.close();
                if (lastNumber < maxNumber) {
                    statement.executeQuery("DROP SEQUENCE " + tablename + "_SEQ");
                    statement.executeQuery("CREATE SEQUENCE " + tablename + "_SEQ START WITH " + (maxNumber + 1L) + " INCREMENT BY 1");
                }
            } else if (this.dbType == DBType.H2) {
                statement.execute("ALTER SEQUENCE " + tablename + "_SEQ RESTART WITH " + (maxNumber + 1L));
            } else if (this.dbType == DBType.PSQL) {
                statement.execute("ALTER SEQUENCE " + tablename + "_" + columnname + "_SEQ RESTART WITH " + (maxNumber + 1L));
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.logger.logWarning("Failed to close SQL statement", e);
            }
        }
    }
}

