/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.core;

import java.util.logging.Logger;

public class Retry {
    public static final String RETRY_COUNT = "de.businesslogics.banking.core.RetryCount";
    public static final String RETRY_DELAY = "de.businesslogics.banking.core.RetryDelay";
    private int retryCount;
    private final int origRetryCount;
    private final long retryDelay;

    Retry() {
        this.origRetryCount = this.retryCount = Integer.parseInt(System.getProperty(RETRY_COUNT, "5"));
        this.retryDelay = 1000L * Long.parseLong(System.getProperty(RETRY_DELAY, "1"));
    }

    void reset() {
        this.retryCount = this.origRetryCount;
    }

    boolean retry(String message) {
        if (!this.retryNoDelay(message)) {
            return false;
        }
        try {
            Thread.sleep(this.retryDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    boolean retryNoDelay(String message) {
        if (this.retryCount <= 0) {
            return false;
        }
        Logger.getLogger(this.getClass().getName()).info("Retrying: " + message);
        --this.retryCount;
        return true;
    }

    <T extends Throwable> void retry(T t) throws T {
        if (!this.retry(t.getMessage())) {
            throw t;
        }
    }
}

