/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.core;

import de.businesslogics.banking.Messages;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.KeyUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.bank.SecurityToken;
import de.businesslogics.banking.core.Retry;
import de.businesslogics.banking.core.TransmittedException;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.RSAPublicKey;
import de.businesslogics.bcs.appetizer.HIALetter;
import de.businesslogics.bcs.core.OrderNumber;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.client.CertificateAsKey;
import de.businesslogics.ebics.client.DifferingKeyDigestException;
import de.businesslogics.ebics.client.EbicsBank;
import de.businesslogics.ebics.client.EbicsBusinessUser;
import de.businesslogics.ebics.client.EbicsPartner;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.EbicsUser;
import de.businesslogics.ebics.client.FetchTransferState;
import de.businesslogics.ebics.client.FileTransfer;
import de.businesslogics.ebics.client.FrenchTransfer;
import de.businesslogics.ebics.client.KeyManagement;
import de.businesslogics.ebics.client.LocalIOException;
import de.businesslogics.ebics.client.SendTransferState;
import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.h003.FDLOrderParams;
import de.businesslogics.ebics.schema.h003.FULOrderParams;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.orders.GenericOrderParams;
import de.businesslogics.ebics.schema.orders.HPDResponseOrderData;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.request.Product;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.InternalErrorException;
import de.businesslogics.ebics.schema.response.InvalidOrderDataFormatException;
import de.businesslogics.ebics.schema.signature.X509Data;
import de.businesslogics.ebics.schema.types.AuthenticationPubKeyInfo;
import de.businesslogics.ebics.schema.types.AuthenticationVersion;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyInfo;
import de.businesslogics.ebics.schema.types.EncryptionVersion;
import de.businesslogics.ebics.schema.types.Parameter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.io.ContentFactory;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.util.HexTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EbicsWorker
implements EbicsPartner,
EbicsUser {
    public static final String FUL = "FUL";
    public static final String FDL = "FDL";
    private Retry retry = new Retry();
    private BankUser bankUser;
    private BankSettings settings;
    private final EbicsSession session;
    private byte[] verifyDigest;
    private SecurityToken securityToken;
    private final IAcceptHashes acceptHashes;
    private boolean skipHashValuesDialog = false;
    private byte[] pregeneratedSignatur;
    private final EbicsBank bank = new EbicsBank(){

        private String getHashFromCert(X509Data data) {
            if (data != null) {
                try {
                    List<X509Data.Choice> list = data.getChoices();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    if (list != null) {
                        for (X509Data.Choice choice : list) {
                            Base64Element b = choice.getX509Certificate();
                            if (b == null) continue;
                            bout.write(b.getValue());
                        }
                    }
                    MessageDigest digest = MessageDigest.getInstance("SHA-256");
                    byte[] hash = digest.digest(bout.toByteArray());
                    return HexTool.toHex(hash);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setBankKeys(ProtocolVersion protocolVersion, EncryptionPubKeyInfo encInfo, byte[] encrDigest, AuthenticationPubKeyInfo authInfo, byte[] authDigest) throws DifferingKeyDigestException, InvalidOrderDataFormatException {
            String certString;
            EbicsWorker.this.refreshEntities();
            EncryptionVersion version = encInfo.getEncryptionVersion();
            AuthenticationVersion version2 = authInfo.getAuthenticationVersion();
            java.security.interfaces.RSAPublicKey encrKey = encInfo.getPublicKey();
            java.security.interfaces.RSAPublicKey authKey = authInfo.getPublicKey();
            String eString = HexTool.toHex(encrDigest);
            String xString = HexTool.toHex(authDigest);
            String eExpected = EncryptionVersion.E001.equals(version) ? EbicsWorker.this.settings.getExpectedDigestE001() : EbicsWorker.this.settings.getExpectedDigestE002();
            String xExpected = AuthenticationVersion.X001.equals(version2) ? EbicsWorker.this.settings.getExpectedDigestX001() : EbicsWorker.this.settings.getExpectedDigestX002();
            boolean eWrong = false;
            boolean xWrong = false;
            if (!EbicsSession.verifyNewKey(encrKey, this.getEncrKey(protocolVersion)) && eExpected != null && eExpected.length() > 0) {
                boolean bl = eWrong = !eString.startsWith(eExpected);
                if (eWrong && (certString = this.getHashFromCert(encInfo.getX509Data())) != null) {
                    eWrong = !certString.startsWith(eExpected);
                    eString = certString;
                    encrDigest = HexTool.fromHex(certString);
                }
            }
            if (!EbicsSession.verifyNewKey(authKey, this.getAuthKey(protocolVersion)) && xExpected != null && xExpected.length() > 0) {
                boolean bl = xWrong = !xString.startsWith(xExpected);
                if (xWrong && (certString = this.getHashFromCert(authInfo.getX509Data())) != null) {
                    xWrong = !certString.startsWith(xExpected);
                    xString = certString;
                    authDigest = HexTool.fromHex(certString);
                }
            }
            if (eWrong || xWrong) {
                boolean hashValuesOK = false;
                if (EbicsWorker.this.acceptHashes != null) {
                    hashValuesOK = EbicsWorker.this.skipHashValuesDialog ? true : EbicsWorker.this.acceptHashes.accept(version, eString, eExpected, version2, xString, xExpected);
                }
                if (!hashValuesOK) {
                    if (eWrong) {
                        DifferingKeyDigestException.compareDigestsString(version.getValue(), eExpected, version.getValue(), encrDigest);
                    } else {
                        DifferingKeyDigestException.compareDigestsString(version2.getValue(), xExpected, version2.getValue(), authDigest);
                    }
                }
            }
            if (!BankUtils.isProtocolH005OrNewer(protocolVersion) && BankUtils.isProtocolH005OrNewer(EbicsWorker.this.settings.getProtocolVersion())) {
                return;
            }
            if (EncryptionVersion.E001.equals(version)) {
                EbicsWorker.this.settings.setE001Key(this.getUpdatedKeyVo(EbicsWorker.this.settings.getE001Key(), encrKey));
                EbicsWorker.this.settings.setExpectedDigestE001(HexTool.toHex(encrDigest));
            } else {
                EbicsWorker.this.settings.setE002Key(this.getUpdatedKeyVo(EbicsWorker.this.settings.getE002Key(), encrKey));
                EbicsWorker.this.settings.setExpectedDigestE002(HexTool.toHex(encrDigest));
            }
            if (AuthenticationVersion.X001.equals(version2)) {
                EbicsWorker.this.settings.setX001Key(this.getUpdatedKeyVo(EbicsWorker.this.settings.getX001Key(), authKey));
                EbicsWorker.this.settings.setExpectedDigestX001(HexTool.toHex(authDigest));
            } else {
                EbicsWorker.this.settings.setX002Key(this.getUpdatedKeyVo(EbicsWorker.this.settings.getX002Key(), authKey));
                EbicsWorker.this.settings.setExpectedDigestX002(HexTool.toHex(authDigest));
            }
            if (BankUser.UserState.CREATED.equals((Object)EbicsWorker.this.bankUser.getState())) {
                EbicsWorker.this.bankUser.setState(BankUser.UserState.READY);
            }
            EbicsWorker.this.save();
        }

        private RSAPublicKey getUpdatedKeyVo(RSAPublicKey vo, java.security.interfaces.RSAPublicKey key) {
            if (vo == null) {
                vo = new RSAPublicKey();
            }
            vo.setExponent(key.getPublicExponent().toByteArray());
            vo.setModulo(key.getModulus().toByteArray());
            vo.setCertificate(key instanceof CertificateAsKey ? ((CertificateAsKey)key).getCertificate() : null);
            vo.save();
            return vo;
        }

        @Override
        public java.security.interfaces.RSAPublicKey getEncrKey(ProtocolVersion pVersion) {
            RSAPublicKey p = ProtocolVersion.H002.equals(pVersion) ? EbicsWorker.this.settings.getE001Key() : EbicsWorker.this.settings.getE002Key();
            if (p == null) {
                return null;
            }
            return this.getPublicKey(p.getExponent(), p.getModulo(), p.getCertificate());
        }

        @Override
        public java.security.interfaces.RSAPublicKey getAuthKey(ProtocolVersion pVersion) {
            RSAPublicKey p = ProtocolVersion.H002.equals(pVersion) ? EbicsWorker.this.settings.getX001Key() : EbicsWorker.this.settings.getX002Key();
            if (p == null) {
                return null;
            }
            return this.getPublicKey(p.getExponent(), p.getModulo(), p.getCertificate());
        }

        private java.security.interfaces.RSAPublicKey getPublicKey(byte[] exp, byte[] mod, byte[] cert) {
            CertificateAsKey keyFromCert;
            CertificateAsKey certificateAsKey = keyFromCert = cert != null ? new CertificateAsKey(cert) : null;
            if (keyFromCert != null) {
                return keyFromCert;
            }
            if (mod != null && exp != null) {
                try {
                    return Provider.buildKey(mod, exp);
                }
                catch (GeneralSecurityException ge) {
                    throw new RuntimeException("Wrong security setup", ge);
                }
            }
            return null;
        }

        @Override
        public String getHostId() {
            return EbicsWorker.this.settings.getHostId();
        }

        @Override
        public Date getTimestampBankParameters() {
            return EbicsWorker.this.settings.getBankParametersTime();
        }

        @Override
        public HPDResponseOrderData getBankParameters() {
            return EbicsWorker.getHpdResponseOrderData(EbicsWorker.this.settings);
        }

        @Override
        public void setBankParameters(Date timestamp, HPDResponseOrderData bankParameters) {
            if (bankParameters == null) {
                return;
            }
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(bankParameters);
                oout.close();
                EbicsWorker.this.refreshEntities();
                EbicsWorker.this.settings.setBankParameters(bout.toByteArray());
                EbicsWorker.this.settings.setBankParametersTime(new Timestamp(timestamp.getTime()));
                EbicsWorker.this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public URL getURL() {
            try {
                return new URL(EbicsWorker.this.settings.getUrl());
            }
            catch (MalformedURLException mal) {
                throw new RuntimeException("Invalid URL found", mal);
            }
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            if (EbicsWorker.this.settings.getProtocolVersion() == null || EbicsWorker.this.settings.getProtocolVersion().length() == 0) {
                return ProtocolVersion.H004;
            }
            return ProtocolVersion.getInstance(EbicsWorker.this.settings.getProtocolVersion());
        }
    };
    private static java.security.interfaces.RSAPublicKey AUTHSERV_ENCKEY = null;
    private static java.security.interfaces.RSAPublicKey AUTHSERV_AUTHKEY = null;

    public void setSkipHashValuesDialog(boolean skipHashValuesDialog) {
        this.skipHashValuesDialog = skipHashValuesDialog;
    }

    public EbicsWorker(BankSettings settings, BankUser bankUser, SecurityToken sm, Product product, IAcceptHashes acceptHashes, File logDir) throws IOException {
        this.settings = settings;
        this.bankUser = bankUser;
        this.acceptHashes = acceptHashes;
        this.securityToken = sm;
        this.session = new EbicsSession(this);
        String protocolVersion = settings.getProtocolVersion();
        if (sm.hasTransportKeys() && KeyUtil.newKeysRequired(bankUser, protocolVersion)) {
            String message = "You have to create new keys for the bank " + settings.getDisplayName() + " (ID = " + settings.getBankId() + ") since the protocol version has been changed to " + settings.getProtocolVersion() + ".";
            throw new IOException(message);
        }
        this.session.setProtocolVersion(ProtocolVersion.getInstance(protocolVersion));
        if (logDir != null) {
            this.session.setLog(logDir, true);
        }
        if (product != null) {
            this.session.setProduct(product);
        }
    }

    public void fetchFile30(OutputStream dest, RestrictedServiceType serviceType, YYMMDD from, YYMMDD to) throws EbicsException, IOException {
        this.fetchFile(dest, serviceType, null, from, to);
    }

    public void fetchFile(OutputStream dest, String orderType, YYMMDD from, YYMMDD to) throws EbicsException, IOException {
        this.fetchFile(dest, null, orderType, from, to);
    }

    private void fetchFile(OutputStream dest, RestrictedServiceType serviceType, String orderType, YYMMDD from, YYMMDD to) throws EbicsException, IOException {
        FileTransfer ft = new FileTransfer(this.session);
        this.retry.reset();
        FetchTransferState ts = null;
        do {
            try {
                if (serviceType != null) {
                    ts = ft.fetchFile30(serviceType, from, to, dest);
                    continue;
                }
                ts = ft.fetchIterating(new OrderType(orderType), from, to, dest);
            }
            catch (DifferingKeyDigestException | LocalIOException lioe) {
                throw lioe;
            }
            catch (IOException ioe) {
                this.retry.retry(ioe);
            }
        } while (ts == null);
        boolean again = true;
        do {
            try {
                again = ft.nextChunk(ts);
            }
            catch (DifferingKeyDigestException | LocalIOException lioe) {
                throw lioe;
            }
            catch (IOException ioe) {
                this.retry.retry(ioe);
            }
        } while (again);
    }

    public void fetchFDL(OutputStream dest, FDLOrderParams orderParams) throws EbicsException, IOException {
        FrenchTransfer ft = new FrenchTransfer(this.session);
        this.retry.reset();
        FetchTransferState ts = null;
        do {
            try {
                ts = ft.fetchFDL(orderParams, dest);
            }
            catch (DifferingKeyDigestException | LocalIOException lioe) {
                throw lioe;
            }
            catch (IOException ioe) {
                this.retry.retry(ioe);
            }
        } while (ts == null);
        boolean again = true;
        do {
            try {
                again = ft.nextChunk(ts);
            }
            catch (DifferingKeyDigestException | LocalIOException lioe) {
                throw lioe;
            }
            catch (IOException ioe) {
                this.retry.retry(ioe);
            }
        } while (again);
    }

    public void setSecurityToken(SecurityToken sm) {
        this.securityToken = sm;
    }

    public String lockUserWithExistingSignature() throws IOException, EbicsException {
        this.pregeneratedSignatur = this.bankUser.getLockUserSignature();
        if (this.pregeneratedSignatur == null) {
            throw new IOException("No locking signature for this user.");
        }
        return this.lockUser();
    }

    public void setPregeneratedSignatur(byte[] signature) {
        this.pregeneratedSignatur = signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lockUser() throws IOException, EbicsException {
        KeyManagement km = new KeyManagement(this.session);
        try {
            OrderID id = km.lockAccess();
            this.bankUser.setState(BankUser.UserState.LOCKED);
            String string = id == null ? "" : id.getValue();
            return string;
        }
        finally {
            this.save();
        }
    }

    public String sendFile30(ContentFactory in, String localFilename, RestrictedServiceType serviceType, EbicsWorker[] signer, boolean transportOnly, String additionalInfo) throws IOException, EbicsException {
        return this.sendFile(in, localFilename, serviceType, null, signer, transportOnly, false, additionalInfo);
    }

    public String sendFile(ContentFactory in, String localFilename, String orderType, EbicsWorker[] signer, boolean transportOnly, String additionalInfo) throws IOException, EbicsException {
        return this.sendFile(in, localFilename, null, orderType, signer, transportOnly, false, additionalInfo);
    }

    public String sendFile(ContentFactory in, String localFilename, RestrictedServiceType serviceType, String orderType, EbicsWorker[] signer, boolean transportOnly, boolean uploadFilename, String additionalInfo) throws IOException, EbicsException {
        SendTransferState state;
        FileTransfer ft = new FileTransfer(this.session);
        EbicsBusinessUser[] ebicsSigner = new EbicsUser[signer.length];
        System.arraycopy(signer, 0, ebicsSigner, 0, signer.length);
        if (serviceType != null) {
            state = ft.sendFile30(in, localFilename, serviceType, ebicsSigner, transportOnly, additionalInfo);
        } else {
            GenericOrderParams orderParams = null;
            if (uploadFilename) {
                orderParams = new GenericOrderParams();
                orderParams.getParameters().add(new Parameter(GenericOrderParams.FILENAME, new Parameter.Value(localFilename)));
            }
            state = ft.sendFile(in, localFilename, new OrderType(orderType), null, ebicsSigner, transportOnly, orderParams, additionalInfo);
        }
        try {
            while (ft.nextChunk(state)) {
            }
        }
        catch (IOException io) {
            throw new TransmittedException(orderType, state, io);
        }
        catch (InternalErrorException ebicsInternalError) {
            throw new TransmittedException(orderType, state, ebicsInternalError);
        }
        return state.getOrderID().getValue();
    }

    public String sendFUL(ContentFactory in, String localFilename, String fileType, FULOrderParams orderParams, EbicsWorker[] signer, boolean transportOnly) throws IOException, EbicsException {
        FrenchTransfer ft = new FrenchTransfer(this.session);
        EbicsBusinessUser[] ebicsSigner = new EbicsUser[signer.length];
        System.arraycopy(signer, 0, ebicsSigner, 0, signer.length);
        SendTransferState state = ft.sendFUL(in, localFilename, orderParams, null, ebicsSigner, transportOnly);
        try {
            while (ft.nextChunk(state)) {
            }
        }
        catch (IOException io) {
            throw new TransmittedException(fileType, state, io);
        }
        return state.getOrderID().getValue();
    }

    @Override
    public java.security.interfaces.RSAPublicKey getEncrPubKey() {
        return this.securityToken.getEncrPubKey();
    }

    @Override
    public EbicsBank getBank() {
        return this.bank;
    }

    @Override
    public String getPartnerID() {
        return this.settings.getCustomerId();
    }

    @Override
    public synchronized String nextOrderID(String orderType) {
        if (this.bankUser == null) {
            throw new RuntimeException("No bankUser, no ordernumber!");
        }
        if (this.bankUser.getId() != null) {
            this.bankUser = BankUser.findById(this.bankUser.getId());
        }
        String next = "A000";
        if (this.bankUser.getOrderNumber() != null) {
            next = OrderNumber.next(this.bankUser.getOrderNumber());
        }
        this.bankUser.setOrderNumber(next);
        if (this.bankUser.getId() != null) {
            this.bankUser.save();
        }
        return next;
    }

    @Override
    public byte[] authenticate(byte[] digest) {
        return this.securityToken.authenticate(digest);
    }

    @Override
    public byte[] decrypt(byte[] encryptedKey) throws IllegalBlockSizeException, BadPaddingException {
        return this.securityToken.decrypt(encryptedKey);
    }

    @Override
    public EbicsPartner getPartner() {
        return this;
    }

    @Override
    public String getSecurityMedium() {
        return this.securityToken.getSecurityMedium();
    }

    @Override
    public String getUserID() {
        return this.bankUser.getDefaultUser();
    }

    @Override
    public SignatureVersion getSignatureVersion() {
        return SignatureVersion.getInstance(this.bankUser.getSignatureVersion());
    }

    public ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.getInstance(this.settings.getProtocolVersion());
    }

    @Override
    public byte[] sign(byte[] digest, String filename, Date fileDate, String orderType) {
        if (this.pregeneratedSignatur != null) {
            return this.pregeneratedSignatur;
        }
        if (this.verifyDigest != null) {
            if (!Arrays.equals(digest, this.verifyDigest)) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("EbicsWorker.fileModification", new Object[0]), filename));
            }
            this.verifyDigest = null;
        }
        return this.securityToken.getSignature(this.bankUser.getDefaultUser(), digest, filename, fileDate, orderType);
    }

    public void setVerifyDigest(byte[] digest) {
        this.verifyDigest = digest;
    }

    public boolean initialize(File keyDir, Locale locale) throws GeneralSecurityException, IOException, EbicsException {
        String userId = this.getUserID();
        Date iniDate = new Date();
        KeyManagement km = new KeyManagement(this.session);
        this.refreshEntities();
        java.security.interfaces.RSAPublicKey sigKey = this.securityToken.getSigPubKey();
        if (sigKey == null) {
            return false;
        }
        java.security.interfaces.RSAPublicKey authKey = this.securityToken.getAuthPubKey();
        java.security.interfaces.RSAPublicKey encrKey = this.securityToken.getEncrPubKey();
        List<X509Certificate> sigCerts = this.securityToken.getSigCerts();
        List<X509Certificate> encrCerts = this.securityToken.getEncrCerts();
        List<X509Certificate> authCerts = this.securityToken.getAuthCerts();
        SignatureVersion sigVersion = this.getSignatureVersion();
        km.sendINI(sigVersion, sigKey, sigCerts);
        km.sendHIA(encrKey, encrCerts, authKey, authCerts);
        this.bankUser.setState(BankUser.UserState.CREATED);
        this.save();
        File iniPdf = EbicsWorker.getINILetter(keyDir, this.settings);
        if (!iniPdf.getParentFile().exists()) {
            iniPdf.getParentFile().mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(iniPdf);
        if (sigCerts != null && sigCerts.size() > 0) {
            HIALetter.printINIandHIA(fout, this.bank.getHostId(), this.getPartnerID(), userId, sigVersion.getValue(), sigCerts.get(0), this.session.getEncryptionHandler().getVersion(), encrCerts.get(0), this.session.getAuthenticationHandler().getVersion(), authCerts.get(0), iniDate, locale);
        } else if ("https://authsrv.conet24.com/ebics/EbicsServlet".equals(this.getBank().getURL().toExternalForm()) && "AUTHOSER".equals(this.getBank().getHostId()) && AUTHSERV_AUTHKEY != null && AUTHSERV_ENCKEY != null) {
            HIALetter.printINIandHIA((OutputStream)fout, this.settings.getDisplayName(), this.bank.getHostId(), this.getPartnerID(), userId, this.bankUser.getUser().getName(), sigVersion.getValue(), sigKey, this.session.getEncryptionHandler().getVersion(), AUTHSERV_ENCKEY, this.session.getAuthenticationHandler().getVersion(), AUTHSERV_AUTHKEY, iniDate, locale);
        } else {
            HIALetter.printINIandHIA((OutputStream)fout, this.settings.getDisplayName(), this.bank.getHostId(), this.getPartnerID(), userId, this.bankUser.getUser().getName(), sigVersion.getValue(), sigKey, this.session.getEncryptionHandler().getVersion(), encrKey, this.session.getAuthenticationHandler().getVersion(), authKey, iniDate, locale);
        }
        fout.close();
        this.bankUser.setIniLetter(iniPdf);
        this.bankUser.save();
        return true;
    }

    public EbicsSession getEbicsSession() {
        return this.session;
    }

    private void refreshEntities() {
        if (this.settings != null && this.settings.getBankId() != null) {
            this.settings = BankSettings.getById(this.settings.getBankId());
        }
        if (this.bankUser != null && this.bankUser.getId() != null) {
            this.bankUser = BankUser.findById(this.bankUser.getId());
        }
    }

    private void save() {
        this.settings.save();
        if (this.bankUser != null) {
            this.bankUser.save();
        }
    }

    public static File getINILetter(BankUser forBankUser) throws IOException {
        if (forBankUser.getIniLetter() != null) {
            String userID = forBankUser.getDefaultUser() != null ? forBankUser.getDefaultUser() : "";
            File iniFile = Util.createTempFile("INI_" + userID + EbicsWorker.getUniqueId(forBankUser.getBank()) + "_", "pdf", true);
            try (FileOutputStream fileOutputStream = new FileOutputStream(iniFile);){
                fileOutputStream.write(forBankUser.getIniLetter());
            }
            return iniFile;
        }
        return EbicsWorker.getINILetter(Util.getKeyDirectory(forBankUser.getUser()), forBankUser.getBank());
    }

    public static File getINILetter(File keyDir, BankSettings settings) {
        if (keyDir == null) {
            try {
                return Util.createTempFile("INI_" + EbicsWorker.getUniqueId(settings), "pdf", true);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create tmp file for INI letter: " + e.getMessage());
            }
        }
        return new File(keyDir, EbicsWorker.getUniqueId(settings) + ".pdf");
    }

    public static String getUniqueId(BankSettings settings) {
        if (settings == null || settings.getBankId() == null) {
            return "null";
        }
        return String.valueOf(settings.getBankId() - 1);
    }

    public Retry getRetry() {
        return this.retry;
    }

    public void setRetrys(Retry retry) {
        this.retry = retry;
    }

    public static HPDResponseOrderData getHpdResponseOrderData(BankSettings settings) {
        byte[] s = settings.getBankParameters();
        if (s == null) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(s);
        try {
            ObjectInputStream oin = new ObjectInputStream(bin);
            return (HPDResponseOrderData)oin.readObject();
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        try {
            AUTHSERV_ENCKEY = Provider.buildKey(new BigInteger("E47B04C5F95D431B9C66A29E6274A199A15DB6D794DD709AF26182370B1EA69F9D9E32E6D49008076722E13276FCD2B35EE41F66236AB7A93761841F4619EC19BDBA3A12DCA5FD4D83B5F10B46695059619D8BAE9FFC974210AA459AB9B2BDF3416B920BA0EA558DACCD4099348ABE163CEB39C588429633F387DBBCA23F7BC039F41BF230857358CA7D6E7D3D26003889DF22373E2B0660E222C1D42850CE8E7D83EC767A1E8F560D3B2B49A45DFF700FF2F084EF7711B9F9AB72F5F9EC87F5B2DEF0C114E6C2F27F89EA1478D7EA97DF207C9793426BD257999E26B3613062401A1AE84453F26E91B274F5AB8C285456EF20EA81AEDB75E78D7F2D30D4DA49", 16), new BigInteger("010001", 16));
            AUTHSERV_AUTHKEY = Provider.buildKey(new BigInteger("8B8B8263BBB708B72ED128F2B6F1066C5CD7A4EB1678F4987654BBAA362AB7DEEEC2BEF3E2BBB8CDDC283101B5BE159B169B5A107A5C76E04BE57DDC948ABBC7CDDCBAC6EDD0A43D265B6A22DE59C2818FEA24FC14FE313F90A02A90D340AAB4D092DB38D57B331C037DD080EAECFDC3896D3D621EF65387630A7791AF8C5836852F2169658F3B925926B0391F8B4D35514A1971E543DF6650E7C3E69AB8B040B2DA3F9E1F6CBA706249342F233E3A7590C2128D2A1D2A4649AB0A3D809E0F4993854F85223F165F597AD9A96F6075B957F941031DA60839084760F2958993242BD23AE693204B27D968210E06B7CFAF34563609F6A2B55C21FBC298C9A1E931", 16), new BigInteger("010001", 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface IAcceptHashes {
        public boolean accept(EncryptionVersion var1, String var2, String var3, AuthenticationVersion var4, String var5, String var6);
    }
}

