/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.bank;

import de.businesslogics.io.Streams;
import de.businesslogics.util.ChangeAwareProperties;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.KeyStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Keybag {
    private static final char[] PASSWORD = "CHANGEIT".toCharArray();
    private final File myFile;
    private final ChangeAwareProperties properties;

    public Keybag(File file) throws IOException, InvalidPasswordException {
        this.myFile = file;
        this.properties = new ChangeAwareProperties();
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            byte[] enc = Streams.readAll(in);
            in.close();
            ByteArrayInputStream bin = new ByteArrayInputStream(KeyStore.decryptData(enc, PASSWORD));
            this.properties.load(bin);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void save() throws IOException, InvalidPasswordException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.properties.store(bout, null);
        byte[] enc = KeyStore.encryptData(bout.toByteArray(), PASSWORD);
        FileOutputStream fout = new FileOutputStream(this.myFile);
        fout.write(enc);
        fout.close();
    }
}

