/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.bank;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KeyUtil;
import de.businesslogics.banking.api.ProxyPasswordUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.bank.Keybag;
import de.businesslogics.banking.bank.PropertiesKeys;
import de.businesslogics.banking.bank.SecurityToken;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.client.CertificateAsKey;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.A004PrivateKey;
import de.businesslogics.zkasecurity.A004Signature;
import de.businesslogics.zkasecurity.A005PrivateKey;
import de.businesslogics.zkasecurity.A006PrivateKey;
import de.businesslogics.zkasecurity.E001PrivateKey;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.KeyStore;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.RSAPrivateKey;
import de.businesslogics.zkasecurity.SimplePasswordCallback;
import de.businesslogics.zkasecurity.X001PrivateKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.security.auth.x500.X500Principal;

public class DatabaseToken
implements SecurityToken {
    public static final int MIN_KEY_LENGTH_E002 = 2048;
    public static final int MAX_KEY_LENGTH_E002 = 16384;
    public static final int MIN_KEY_LENGTH_X002 = 2048;
    public static final int MAX_KEY_LENGTH_X002 = 16384;
    @Deprecated
    public static final int KEY_LENGTH_A004 = 1024;
    public static final int DEFAULT_KEY_LENGTH_A005 = 2048;
    public static final int MIN_KEY_LENGTH_A005 = 2048;
    public static final int MAX_KEY_LENGTH_A005 = 4096;
    public static final int DEFAULT_KEY_LENGTH_A006 = 2048;
    public static final int MIN_KEY_LENGTH_A006 = 2048;
    public static final int MAX_KEY_LENGTH_A006 = 4096;
    private static final byte[] SPR_BYTES = new byte[]{32};
    public static boolean userKeysInKeybag = true;
    public static final String KEYBAG_IN_DATABASE = "DATABASE";
    public static final String KEYBAG_IN_DATABASE_MIGRATION_NEEDED = "DATABASE_MIGRATION_NEEDED";
    public static final PasswordCallback PASSWORD_CALLBACK = "uBBrfFqT6Is7hDTJue7u"::toCharArray;
    @Deprecated
    private static final PasswordCallback EMPTY_PASSWORD_CALLBACK = () -> new char[0];
    private RSAPrivateKey sigKey;
    private E001PrivateKey e001;
    private X001PrivateKey x001;
    private List<X509Certificate> sigCerts;
    private List<X509Certificate> encrCerts;
    private List<X509Certificate> authCerts;

    public static boolean checkPassword(User user, char[] loginPassword, BLLogger logger) throws GeneralSecurityException, IOException {
        try {
            if (!EncryptData.checkLoginKey(KeyStore.decryptData(EncryptData.getEncryptedKey(user.getEncryptionKey()), loginPassword))) {
                logger.logError("decrypted enc_key does not match expected enc_key");
                byte[] encKey = DatabaseToken.createEncKey(loginPassword);
                logger.logWarning("if password is correct, use this as enc_key: " + HexTool.toHex(encKey));
                return false;
            }
            DatabaseToken.migrateTransportKeys(user, () -> loginPassword);
            return true;
        }
        catch (InvalidPasswordException e) {
            logger.logError("Password wrong for user " + user.getName() + "(" + e.getMessage() + ")");
            return false;
        }
    }

    public static boolean updateImportedUserEncKey(User user, char[] passwordArray, byte[] userEncKey, BLLogger logger) throws InvalidPasswordException, IOException {
        try {
            byte[] newEncKey = DatabaseToken.createEncKey(passwordArray);
            Set<String> possibleEncKeys = ApplicationInfo.findImportedEncKeys();
            if (possibleEncKeys == null || possibleEncKeys.size() == 0) {
                logger.logError("Could not check password of imported user " + user.getName() + ". No IMPORT_ENC_KEY entries exist. If password is correct, use this as enc_key: " + HexTool.toHex(newEncKey));
                return false;
            }
            byte[] decryptedUserEncKey = KeyStore.decryptData(EncryptData.getEncryptedKey(userEncKey), passwordArray);
            for (String possibleEncKey : possibleEncKeys) {
                byte[] decryptedDataEncKey = EncryptData.getDecryptedKey(possibleEncKey);
                if (!Arrays.equals(decryptedUserEncKey, decryptedDataEncKey)) continue;
                logger.logInfo("Password of imported user " + user.getName() + " is correct, update enc key ...");
                user.setEncryptionKey(newEncKey);
                user.save();
                return true;
            }
            logger.logError("Could not verify password of imported user " + user.getName() + ". IMPORT_ENC_KEY entries do not fit. If password is correct, use this as enc_key: " + HexTool.toHex(newEncKey));
        }
        catch (Exception e) {
            logger.logError("Could not check password of imported user " + user.getName(), e);
        }
        return false;
    }

    private static byte[] createEncKey(final char[] loginPassword) throws GeneralSecurityException, IOException {
        return EncryptData.getInstance().copyKey(new EncryptData.KeyEncryptionHandler(){

            @Override
            public byte[] encryptKey(byte[] key) throws GeneralSecurityException, IOException {
                return KeyStore.encryptData(key, loginPassword);
            }

            @Override
            public byte[] decryptKey(byte[] key) {
                return null;
            }
        });
    }

    public static void updateLoginPassword(User user, char[] oldPassword, char[] newPassword) throws InvalidPasswordException, IOException {
        DatabaseToken.updateLoginPassword(user, oldPassword, newPassword, Util.logger);
    }

    public static void updateLoginPassword(User user, char[] oldPassword, char[] newPassword, BLLogger logger) throws InvalidPasswordException, IOException {
        byte[] decryptedKey = KeyStore.decryptData(EncryptData.getEncryptedKey(user.getEncryptionKey()), oldPassword);
        user.setEncryptionKey(KeyStore.encryptData(decryptedKey, newPassword));
        byte[] encryptedData = user.getProxyPassword();
        if (ProxyPasswordUtil.isEncryptedWithLoginPassword(encryptedData)) {
            user.setProxyPassword(ProxyPasswordUtil.encryptWithNewLoginPassword(oldPassword, newPassword, encryptedData));
        }
        if (userKeysInKeybag) {
            PasswordCallback oldPasswordCallback = () -> oldPassword;
            PasswordCallback newPasswordCallback = () -> newPassword;
            ArrayList<Keybag> userKeybagToStore = new ArrayList<Keybag>();
            for (BankUser bankUser : BankUser.findBanksForUser(user)) {
                Keybag keybag = DatabaseToken.loadKeybag(bankUser);
                if (keybag == null) {
                    if (!BankUser.UserState.READY.equals((Object)bankUser.getState())) continue;
                    throw new RuntimeException("Can not find the keybag for " + DatabaseToken.getBankUserInfo(bankUser));
                }
                try {
                    RSAPrivateKey privKey;
                    boolean hasE001Entry = false;
                    boolean hasX001Entry = false;
                    String propKey = bankUser.getDefaultUser() + "_E001";
                    if (keybag.getProperties().containsKey(propKey)) {
                        privKey = E001PrivateKey.fromPKCS(HexTool.fromHex(keybag.getProperties().getProperty(propKey)), bankUser.getDefaultUser(), oldPasswordCallback);
                        keybag.getProperties().put(propKey, HexTool.toHex(privKey.toPKCS(newPasswordCallback)));
                        hasE001Entry = true;
                    }
                    propKey = bankUser.getDefaultUser() + "_X001";
                    if (keybag.getProperties().containsKey(propKey)) {
                        privKey = X001PrivateKey.fromPKCS(HexTool.fromHex(keybag.getProperties().getProperty(propKey)), bankUser.getDefaultUser(), oldPasswordCallback);
                        keybag.getProperties().put(propKey, HexTool.toHex(privKey.toPKCS(newPasswordCallback)));
                        hasX001Entry = true;
                    }
                    if (!hasE001Entry || !hasX001Entry) {
                        if (logger != null) {
                            logger.logError("Could not change login password of " + DatabaseToken.getBankUserInfo(bankUser) + ": KeyBag does not contain transport keys");
                        }
                        throw new IOException("KeyBag does not contain transport keys");
                    }
                }
                catch (InvalidPasswordException e) {
                    if (logger != null) {
                        logger.logError("Could not change login password of " + DatabaseToken.getBankUserInfo(bankUser), e);
                    }
                    throw e;
                }
                catch (GeneralSecurityException e) {
                    if (logger != null) {
                        logger.logError("Could not change login password of " + DatabaseToken.getBankUserInfo(bankUser), e);
                    }
                    throw new RuntimeException(e);
                }
                userKeybagToStore.add(keybag);
            }
            for (Keybag updatedKeybag : userKeybagToStore) {
                updatedKeybag.save();
            }
        }
        user.save();
    }

    private static String getBankUserInfo(BankUser bankUser) {
        BankSettings bank = bankUser.getBank();
        File file = DatabaseToken.getKeybagFile(bankUser);
        StringBuilder sb = new StringBuilder("bankUser ");
        sb.append(bankUser.getDefaultUser());
        sb.append(" at bank ");
        sb.append(bank.getDisplayName());
        sb.append(" with ID ");
        sb.append(bank.getBankId());
        if (file != null) {
            if (file.exists()) {
                sb.append(" and keyBag file ");
            } else {
                sb.append(" and non-existing keyBag file ");
            }
            sb.append(file.getAbsolutePath());
        }
        return sb.toString();
    }

    public static void updateSignaturePassword(User user, char[] oldPassword, char[] newPassword) throws InvalidPasswordException, IOException {
        PasswordCallback oldPasswordCallback = () -> oldPassword;
        PasswordCallback newPasswordCallback = () -> newPassword;
        ArrayList<Keybag> userKeybagToStore = new ArrayList<Keybag>();
        Keybag keybag = null;
        String propKey = null;
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            byte[] oldSigKeyEncrypted;
            boolean sigKeyInDatabase = KEYBAG_IN_DATABASE.equals(bankUser.getUser().getKeyDirectory());
            if (sigKeyInDatabase) {
                oldSigKeyEncrypted = bankUser.getSigKey();
                if (oldSigKeyEncrypted == null) {
                    continue;
                }
            } else {
                keybag = DatabaseToken.loadKeybag(bankUser);
                if (keybag == null) {
                    if (!BankUser.UserState.READY.equals((Object)bankUser.getState())) continue;
                    if (Util.logger != null) {
                        Util.logger.logError("Can not find the keybag for " + DatabaseToken.getBankUserInfo(bankUser));
                    }
                    throw new RuntimeException("Can not find the keybag for " + DatabaseToken.getBankUserInfo(bankUser));
                }
                propKey = bankUser.getDefaultUser() + "_" + bankUser.getSignatureVersion();
                oldSigKeyEncrypted = HexTool.fromHex(keybag.getProperties().getProperty(propKey));
            }
            try {
                byte[] newSigKeyEncrypted = (switch (PropertiesKeys.SignatureVersion.valueOf(bankUser.getSignatureVersion())) {
                    case PropertiesKeys.SignatureVersion.A004 -> A004PrivateKey.fromPKCS(oldSigKeyEncrypted, bankUser.getDefaultUser(), oldPasswordCallback);
                    case PropertiesKeys.SignatureVersion.A005 -> A005PrivateKey.fromPKCS(oldSigKeyEncrypted, oldPasswordCallback);
                    case PropertiesKeys.SignatureVersion.A006 -> A006PrivateKey.fromPKCS(oldSigKeyEncrypted, oldPasswordCallback);
                    default -> {
                        if (Util.logger != null) {
                            Util.logger.logError("Unknown signature key type " + bankUser.getSignatureVersion() + " of " + DatabaseToken.getBankUserInfo(bankUser));
                        }
                        throw new RuntimeException("Unknown signature key type " + bankUser.getSignatureVersion() + " of " + DatabaseToken.getBankUserInfo(bankUser));
                    }
                }).toPKCS(newPasswordCallback);
                if (sigKeyInDatabase) {
                    bankUser.setSigKey(newSigKeyEncrypted);
                    bankUser.save();
                    continue;
                }
                keybag.getProperties().setProperty(propKey, HexTool.toHex(newSigKeyEncrypted));
                userKeybagToStore.add(keybag);
            }
            catch (InvalidPasswordException e) {
                throw e;
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        for (Keybag updatedKeybag : userKeybagToStore) {
            updatedKeybag.save();
        }
        user.save();
    }

    public static X500Principal getDnForBank(String customerId, String userId) {
        return new X500Principal("CN=" + userId + ", O=" + customerId);
    }

    private static List<X509Certificate> getSelfCert(X500Principal dn, RSAPrivateKey privKey, boolean withoutExpirationDate, int keyUsage) throws GeneralSecurityException {
        if (dn == null) {
            return null;
        }
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        KeyPair p = new KeyPair(privKey.getPublicKey(), privKey.getPrivateKey());
        list.add(EncryptionHandler.createSelfSignedCertificate(p, dn, withoutExpirationDate, keyUsage));
        return list;
    }

    private static void migrateTransportKeys(User user, PasswordCallback loginPasswordCallback) throws GeneralSecurityException, IOException {
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            DatabaseToken.migrateTransportKeys(bankUser, loginPasswordCallback);
        }
        if (KEYBAG_IN_DATABASE_MIGRATION_NEEDED.equals(user.getKeyDirectory())) {
            user.setKeyDirectory(KEYBAG_IN_DATABASE);
            user.save();
        }
    }

    public static void migrateTransportKeys(BankUser bankUser, PasswordCallback loginPasswordCallback) throws GeneralSecurityException, IOException {
        boolean reEncryptTransportKeys = KEYBAG_IN_DATABASE_MIGRATION_NEEDED.equals(bankUser.getUser().getKeyDirectory());
        Keybag keybag = DatabaseToken.loadKeybag(bankUser);
        if (keybag == null && !reEncryptTransportKeys) {
            return;
        }
        if (userKeysInKeybag && bankUser.getEncrKey() != null && bankUser.getAuthKey() != null) {
            String propKey;
            if (bankUser.getEncrKey() != null && bankUser.getEncrKey().length > 0) {
                E001PrivateKey encrKey;
                try {
                    encrKey = E001PrivateKey.fromPKCS(bankUser.getEncrKey(), bankUser.getDefaultUser(), PASSWORD_CALLBACK);
                }
                catch (Exception e) {
                    encrKey = E001PrivateKey.fromPKCS(bankUser.getEncrKey(), bankUser.getDefaultUser(), EMPTY_PASSWORD_CALLBACK);
                }
                propKey = bankUser.getDefaultUser() + "_E001";
                keybag.getProperties().put(propKey, HexTool.toHex(encrKey.toPKCS(loginPasswordCallback)));
                bankUser.setEncrKey(null);
            }
            if (bankUser.getAuthKey() != null && bankUser.getAuthKey().length > 0) {
                X001PrivateKey authKey;
                try {
                    authKey = X001PrivateKey.fromPKCS(bankUser.getAuthKey(), bankUser.getDefaultUser(), PASSWORD_CALLBACK);
                }
                catch (Exception e) {
                    authKey = X001PrivateKey.fromPKCS(bankUser.getAuthKey(), bankUser.getDefaultUser(), EMPTY_PASSWORD_CALLBACK);
                }
                propKey = bankUser.getDefaultUser() + "_X001";
                keybag.getProperties().put(propKey, HexTool.toHex(authKey.toPKCS(loginPasswordCallback)));
                bankUser.setAuthKey(null);
            }
            if (bankUser.getEncrCert() != null && bankUser.getEncrCert().length > 0) {
                keybag.getProperties().put("E001_CERT", HexTool.toHex(bankUser.getEncrCert()));
                bankUser.setEncrCert(null);
            }
            if (bankUser.getAuthCert() != null && bankUser.getAuthCert().length > 0) {
                keybag.getProperties().put("X001_CERT", HexTool.toHex(bankUser.getAuthCert()));
                bankUser.setAuthCert(null);
            }
            keybag.save();
            bankUser.save();
        } else if (!userKeysInKeybag && (reEncryptTransportKeys || bankUser.getEncrKey() == null || bankUser.getAuthKey() == null)) {
            String propKey = bankUser.getDefaultUser() + "_E001";
            Object currentEncrKey = reEncryptTransportKeys ? bankUser.getEncrKey() : (Object)(keybag != null && keybag.getProperties().containsKey(propKey) ? HexTool.fromHex(keybag.getProperties().getProperty(propKey)) : null);
            if (currentEncrKey != null) {
                E001PrivateKey encrKey = E001PrivateKey.fromPKCS(currentEncrKey, bankUser.getDefaultUser(), loginPasswordCallback);
                bankUser.setEncrKey(encrKey.toPKCS(PASSWORD_CALLBACK));
            } else {
                bankUser.setEncrKey(null);
            }
            propKey = bankUser.getDefaultUser() + "_X001";
            Object currentAuthKey = reEncryptTransportKeys ? bankUser.getAuthKey() : (Object)(keybag != null && keybag.getProperties().containsKey(propKey) ? HexTool.fromHex(keybag.getProperties().getProperty(propKey)) : null);
            if (currentAuthKey != null) {
                X001PrivateKey authKey = X001PrivateKey.fromPKCS(currentAuthKey, bankUser.getDefaultUser(), loginPasswordCallback);
                bankUser.setAuthKey(authKey.toPKCS(PASSWORD_CALLBACK));
            } else {
                bankUser.setAuthKey(null);
            }
            if (bankUser.isWithCerts()) {
                if (keybag != null && keybag.getProperties().containsKey("E001_CERT")) {
                    bankUser.setEncrCert(HexTool.fromHex(keybag.getProperties().getProperty("E001_CERT")));
                }
                if (keybag != null && keybag.getProperties().containsKey("X001_CERT")) {
                    bankUser.setAuthCert(HexTool.fromHex(keybag.getProperties().getProperty("X001_CERT")));
                }
            }
            bankUser.save();
        }
    }

    public static Keybag loadKeybag(BankUser bankUser) throws InvalidPasswordException, IOException {
        if (bankUser == null || bankUser.getId() == null || bankUser.getUser().getKeyDirectory() == null || bankUser.getState() == BankUser.UserState.USED_NO_INI) {
            return null;
        }
        if (KEYBAG_IN_DATABASE.equals(bankUser.getUser().getKeyDirectory()) || KEYBAG_IN_DATABASE_MIGRATION_NEEDED.equals(bankUser.getUser().getKeyDirectory())) {
            return null;
        }
        File keybagFile = DatabaseToken.getKeybagFile(bankUser);
        if (keybagFile.isFile()) {
            return new Keybag(keybagFile);
        }
        if (Util.logger != null) {
            Util.logger.logError("No keybag file found, expected file \"" + keybagFile.getAbsolutePath() + "\"");
        }
        return null;
    }

    public static File getKeybagFile(BankUser bankUser) {
        File keybagFile = new File(bankUser.getUser().getKeyDirectory(), bankUser.getBank().getUniqueKey() + ".keybag");
        if (!keybagFile.isAbsolute()) {
            keybagFile = new File(Util.WORKSPACEDIR, keybagFile.getPath());
        }
        return keybagFile;
    }

    public static DatabaseToken createNewToken(String customerId, String userId, PropertiesKeys.SignatureVersion signatureVersion, int sigKeyLength, int encrKeyLength, int authKeyLength, boolean withCertificates, boolean withoutExpirationDate, ProtocolVersion protocolVersion) throws GeneralSecurityException {
        DatabaseToken result = new DatabaseToken(null, null, null, null, null);
        KeyUtil keyUtil = new KeyUtil(protocolVersion);
        if (signatureVersion != null) {
            result.generateNewSignatureKey(customerId, userId, signatureVersion, sigKeyLength, withCertificates, withoutExpirationDate, keyUtil);
        }
        result.generateTransportKeys(customerId, userId, keyUtil.getAllowedKeyLength(KeyUtil.KeyType.E002, encrKeyLength), keyUtil.getAllowedKeyLength(KeyUtil.KeyType.X002, authKeyLength), withCertificates, withoutExpirationDate);
        return result;
    }

    public static DatabaseToken getInstance(BankUser bankUser, char[] loginPassword) throws GeneralSecurityException, IOException {
        List<X509Certificate> sigCert;
        List<X509Certificate> authCert;
        List<X509Certificate> encrCert;
        boolean save = false;
        E001PrivateKey e001 = null;
        X001PrivateKey x001 = null;
        if (userKeysInKeybag) {
            SimplePasswordCallback loginPasswordCallback = new SimplePasswordCallback(loginPassword);
            Keybag keybag = DatabaseToken.loadKeybag(bankUser);
            if (keybag != null && keybag.getProperties() != null) {
                Object propkey = bankUser.getDefaultUser() + "_E001";
                if (!keybag.getProperties().containsKey(propkey)) {
                    throw new IOException("Missing transport keys for " + DatabaseToken.getBankUserInfo(bankUser));
                }
                e001 = E001PrivateKey.fromPKCS(HexTool.fromHex(keybag.getProperties().getProperty((String)propkey)), bankUser.getDefaultUser(), loginPasswordCallback);
                propkey = bankUser.getDefaultUser() + "_X001";
                if (!keybag.getProperties().containsKey(propkey)) {
                    throw new IOException("Missing transport keys for " + DatabaseToken.getBankUserInfo(bankUser));
                }
                x001 = X001PrivateKey.fromPKCS(HexTool.fromHex(keybag.getProperties().getProperty((String)propkey)), bankUser.getDefaultUser(), loginPasswordCallback);
                propkey = "E001_CERT";
                encrCert = keybag.getProperties().containsKey(propkey) ? DatabaseToken.loadCertsFromImage(HexTool.fromHex(keybag.getProperties().getProperty((String)propkey))) : null;
                propkey = "X001_CERT";
                authCert = keybag.getProperties().containsKey(propkey) ? DatabaseToken.loadCertsFromImage(HexTool.fromHex(keybag.getProperties().getProperty((String)propkey))) : null;
                propkey = "A00X_CERT";
                sigCert = keybag.getProperties().containsKey(propkey) ? DatabaseToken.loadCertsFromImage(HexTool.fromHex(keybag.getProperties().getProperty((String)propkey))) : null;
            } else {
                encrCert = null;
                authCert = null;
                sigCert = null;
            }
        } else {
            if (bankUser.getEncrKey() == null || bankUser.getAuthKey() == null) {
                throw new IOException("Missing transport keys for " + DatabaseToken.getBankUserInfo(bankUser));
            }
            try {
                e001 = E001PrivateKey.fromPKCS(bankUser.getEncrKey(), bankUser.getDefaultUser(), PASSWORD_CALLBACK);
            }
            catch (Exception e) {
                e001 = E001PrivateKey.fromPKCS(bankUser.getEncrKey(), bankUser.getDefaultUser(), EMPTY_PASSWORD_CALLBACK);
                bankUser.setEncrKey(e001.toPKCS(PASSWORD_CALLBACK));
                save = true;
            }
            try {
                x001 = X001PrivateKey.fromPKCS(bankUser.getAuthKey(), bankUser.getDefaultUser(), PASSWORD_CALLBACK);
            }
            catch (Exception e) {
                x001 = X001PrivateKey.fromPKCS(bankUser.getAuthKey(), bankUser.getDefaultUser(), EMPTY_PASSWORD_CALLBACK);
                bankUser.setAuthKey(x001.toPKCS(PASSWORD_CALLBACK));
                save = true;
            }
            if (save) {
                bankUser.save();
            }
            encrCert = DatabaseToken.loadCertsFromImage(bankUser.getEncrCert());
            authCert = DatabaseToken.loadCertsFromImage(bankUser.getAuthCert());
            sigCert = DatabaseToken.loadCertsFromImage(bankUser.getSigCert());
        }
        return new DatabaseToken(e001, x001, encrCert, authCert, sigCert);
    }

    public static DatabaseToken copyToken(DatabaseToken existing, BankUser bankUser) throws GeneralSecurityException {
        RSAPrivateKey sigKey;
        if (existing == null) {
            return null;
        }
        E001PrivateKey e001 = new E001PrivateKey(bankUser.getDefaultUser(), existing.e001.getPrivateKey(), existing.e001.getPublicKey());
        X001PrivateKey x001 = new X001PrivateKey(bankUser.getDefaultUser(), existing.x001.getPrivateKey(), existing.x001.getPublicKey());
        BankSettings bank = bankUser.getBank();
        X500Principal dn = DatabaseToken.getDnForBank(bank.getCustomerId(), bankUser.getDefaultUser());
        List<X509Certificate> encrCerts = existing.encrCerts == null ? null : DatabaseToken.getSelfCert(dn, e001, bank.useCertsWithoutExpirationDate(), 40);
        List<X509Certificate> authCerts = existing.authCerts == null ? null : DatabaseToken.getSelfCert(dn, x001, bank.useCertsWithoutExpirationDate(), 128);
        if (existing.sigKey instanceof A004PrivateKey) {
            sigKey = new A004PrivateKey(bankUser.getDefaultUser(), existing.sigKey.getPrivateKey(), existing.sigKey.getPublicKey());
        } else if (existing.sigKey instanceof A005PrivateKey) {
            sigKey = new A005PrivateKey(existing.sigKey.getPrivateKey(), existing.sigKey.getPublicKey());
        } else if (existing.sigKey instanceof A006PrivateKey) {
            sigKey = new A006PrivateKey(existing.sigKey.getPrivateKey(), existing.sigKey.getPublicKey());
        } else {
            throw new RuntimeException("Signature key of existing bank access has unknown signature version ! Stored version is = " + bankUser.getSignatureVersion());
        }
        List<X509Certificate> sigCerts = existing.sigCerts == null ? null : DatabaseToken.getSelfCert(dn, sigKey, bank.useCertsWithoutExpirationDate(), 64);
        DatabaseToken result = new DatabaseToken(e001, x001, encrCerts, authCerts, sigCerts);
        result.sigKey = sigKey;
        return result;
    }

    private static List<X509Certificate> loadCertsFromImage(byte[] data) throws CertificateException, IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream dataInputStream = new ByteArrayInputStream(data);
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        while (((InputStream)dataInputStream).available() > 0) {
            result.add((X509Certificate)certificateFactory.generateCertificate(dataInputStream));
        }
        return result;
    }

    private DatabaseToken(E001PrivateKey e001, X001PrivateKey x001, List<X509Certificate> encrCerts, List<X509Certificate> authCerts, List<X509Certificate> sigCerts) {
        this.e001 = e001;
        this.x001 = x001;
        this.encrCerts = encrCerts;
        this.authCerts = authCerts;
        this.sigCerts = sigCerts;
    }

    @Override
    public RSAPublicKey getSigPubKey() {
        RSAPublicKey publicKeyFromCerts = this.getPublicKeyFromCerts(this.sigCerts);
        if (publicKeyFromCerts != null) {
            return publicKeyFromCerts;
        }
        if (this.sigKey != null) {
            return this.sigKey.getPublicKey();
        }
        return null;
    }

    @Override
    public RSAPublicKey getEncrPubKey() {
        RSAPublicKey publicKeyFromCerts = this.getPublicKeyFromCerts(this.encrCerts);
        return publicKeyFromCerts != null ? publicKeyFromCerts : this.e001.getPublicKey();
    }

    @Override
    public RSAPublicKey getAuthPubKey() {
        RSAPublicKey publicKeyFromCerts = this.getPublicKeyFromCerts(this.authCerts);
        return publicKeyFromCerts != null ? publicKeyFromCerts : this.x001.getPublicKey();
    }

    private RSAPublicKey getPublicKeyFromCerts(List<X509Certificate> certs) {
        if (certs != null && certs.size() > 0) {
            return new CertificateAsKey(Provider.convertX509Data(certs));
        }
        return null;
    }

    @Override
    public List<X509Certificate> getSigCerts() {
        return this.sigCerts;
    }

    @Override
    public List<X509Certificate> getEncrCerts() {
        return this.encrCerts;
    }

    @Override
    public List<X509Certificate> getAuthCerts() {
        return this.authCerts;
    }

    @Override
    public byte[] authenticate(byte[] digest) {
        return this.x001.authenticate(digest);
    }

    @Override
    public byte[] decrypt(byte[] encryptedKey) throws IllegalBlockSizeException, BadPaddingException {
        return this.e001.decrypt(encryptedKey);
    }

    @Override
    public String getSecurityMedium() {
        return "0000";
    }

    @Override
    public byte[] getSignature(String userId, byte[] digest, String filename, Date fileDate, String orderType) {
        if (this.sigKey instanceof A004PrivateKey) {
            return A004Signature.createSignatureFile(userId, filename, fileDate, orderType, ((A004PrivateKey)this.sigKey).sign(digest));
        }
        if (this.sigKey instanceof A005PrivateKey) {
            return ((A005PrivateKey)this.sigKey).sign(digest);
        }
        if (this.sigKey instanceof A006PrivateKey) {
            return ((A006PrivateKey)this.sigKey).sign(digest, null);
        }
        throw new NullPointerException();
    }

    public boolean isEmpty() {
        return this.e001 == null && this.x001 == null;
    }

    public boolean loadSignatureKey(BankUser bankUser, PasswordCallback passwordCallback) throws GeneralSecurityException, IOException {
        byte[] sigKeyEncrypted;
        Keybag keybag;
        String signatureVersion = bankUser.getSignatureVersion();
        if (!userKeysInKeybag || KEYBAG_IN_DATABASE.equals(bankUser.getUser().getKeyDirectory()) || KEYBAG_IN_DATABASE_MIGRATION_NEEDED.equals(bankUser.getUser().getKeyDirectory())) {
            keybag = null;
            sigKeyEncrypted = bankUser.getSigKey();
        } else {
            keybag = DatabaseToken.loadKeybag(bankUser);
            if (keybag == null) {
                return false;
            }
            sigKeyEncrypted = HexTool.fromHex(keybag.getProperties().getProperty(bankUser.getDefaultUser() + "_" + signatureVersion));
        }
        if (sigKeyEncrypted == null) {
            return false;
        }
        if (PropertiesKeys.SignatureVersion.A004.name().equals(signatureVersion)) {
            this.sigKey = A004PrivateKey.fromPKCS(sigKeyEncrypted, bankUser.getDefaultUser(), passwordCallback);
        } else if (PropertiesKeys.SignatureVersion.A005.name().equals(signatureVersion)) {
            this.sigKey = A005PrivateKey.fromPKCS(sigKeyEncrypted, passwordCallback);
        } else if (PropertiesKeys.SignatureVersion.A006.name().equals(signatureVersion)) {
            this.sigKey = A006PrivateKey.fromPKCS(sigKeyEncrypted, passwordCallback);
        } else {
            return false;
        }
        if (keybag != null && keybag.getProperties().contains("A00X_CERT")) {
            this.sigCerts = DatabaseToken.loadCertsFromImage(keybag.getProperties().getProperty(bankUser.getDefaultUser() + "A00X_CERT").getBytes());
        }
        return true;
    }

    public static boolean checkSignatureKeyInKeybag(BankUser bankUser, char[] signaturePassword) {
        Keybag keybag;
        try {
            keybag = DatabaseToken.loadKeybag(bankUser);
            if (keybag == null) {
                return false;
            }
        }
        catch (Exception e) {
            Util.logger.logError("Could not load keybag", e);
            return false;
        }
        return DatabaseToken.checkKeybag(bankUser, keybag, signaturePassword);
    }

    public static boolean checkKeybag(BankUser bankUser, Keybag keybag, char[] signaturePassword) {
        if (PropertiesKeys.SignatureVersion.A004.name().equals(bankUser.getSignatureVersion())) {
            try {
                KeyStore.decryptStore(HexTool.fromHex(keybag.getProperties().getProperty(bankUser.getDefaultUser() + "_A004")), signaturePassword);
            }
            catch (Exception e) {
                Util.logger.logError("Could not load A004 key for " + DatabaseToken.getBankUserInfo(bankUser), e);
                return false;
            }
        } else if (PropertiesKeys.SignatureVersion.A005.name().equals(bankUser.getSignatureVersion())) {
            try {
                KeyStore.decryptStore(HexTool.fromHex(keybag.getProperties().getProperty(bankUser.getDefaultUser() + "_A005")), signaturePassword);
            }
            catch (Exception e) {
                Util.logger.logError("Could not load A005 key for " + DatabaseToken.getBankUserInfo(bankUser), e);
                return false;
            }
        } else if (PropertiesKeys.SignatureVersion.A006.name().equals(bankUser.getSignatureVersion())) {
            try {
                KeyStore.decryptStore(HexTool.fromHex(keybag.getProperties().getProperty(bankUser.getDefaultUser() + "_A006")), signaturePassword);
            }
            catch (Exception e) {
                Util.logger.logError("Could not load A006 key for " + DatabaseToken.getBankUserInfo(bankUser), e);
                return false;
            }
        } else {
            Util.logger.logError("Invalid signature version of " + DatabaseToken.getBankUserInfo(bankUser));
            return false;
        }
        if (keybag.getProperties().contains("A00X_CERT")) {
            try {
                DatabaseToken.loadCertsFromImage(keybag.getProperties().getProperty(bankUser.getDefaultUser() + "A00X_CERT").getBytes());
            }
            catch (Exception e) {
                Util.logger.logError("Could not load certificates for " + DatabaseToken.getBankUserInfo(bankUser), e);
                return false;
            }
        }
        return true;
    }

    private void generateNewSignatureKey(String customerId, String userId, PropertiesKeys.SignatureVersion signatureVersion, int signatureKeyLength, boolean withCertificates, boolean withoutExpirationDate, KeyUtil keyUtil) throws GeneralSecurityException {
        if (signatureVersion == null) {
            return;
        }
        switch (signatureVersion) {
            case A004: {
                this.sigKey = new A004PrivateKey(userId, null);
                break;
            }
            case A005: {
                this.sigKey = new A005PrivateKey(keyUtil.getAllowedKeyLength(KeyUtil.KeyType.A005, signatureKeyLength), null);
                break;
            }
            case A006: {
                this.sigKey = new A006PrivateKey(keyUtil.getAllowedKeyLength(KeyUtil.KeyType.A006, signatureKeyLength), null);
            }
        }
        if (withCertificates) {
            X500Principal dn = DatabaseToken.getDnForBank(customerId, userId);
            this.sigCerts = DatabaseToken.getSelfCert(dn, this.sigKey, withoutExpirationDate, 64);
        } else {
            this.sigCerts = null;
        }
    }

    private void generateTransportKeys(String customerId, String userId, int encryKeyLength, int authKeyLength, boolean withCertificates, boolean withoutExpirationDate) throws GeneralSecurityException {
        this.e001 = new E001PrivateKey(userId, null, encryKeyLength);
        this.x001 = new X001PrivateKey(userId, null, authKeyLength);
        if (withCertificates) {
            X500Principal dn = DatabaseToken.getDnForBank(customerId, userId);
            this.encrCerts = DatabaseToken.getSelfCert(dn, this.e001, withoutExpirationDate, 40);
            this.authCerts = DatabaseToken.getSelfCert(dn, this.x001, withoutExpirationDate, 128);
        } else {
            this.encrCerts = null;
            this.authCerts = null;
        }
    }

    public void saveSignatureKey(BankUser bankUser, char[] signaturePassword) throws IOException, InvalidPasswordException {
        byte[] sigCertsEncoded;
        String propertyKey;
        if (this.sigKey instanceof A004PrivateKey) {
            propertyKey = bankUser.getDefaultUser() + "_A004";
            bankUser.setSignatureVersion(PropertiesKeys.SignatureVersion.A004.name());
        } else if (this.sigKey instanceof A005PrivateKey) {
            propertyKey = bankUser.getDefaultUser() + "_A005";
            bankUser.setSignatureVersion(PropertiesKeys.SignatureVersion.A005.name());
        } else if (this.sigKey instanceof A006PrivateKey) {
            propertyKey = bankUser.getDefaultUser() + "_A006";
            bankUser.setSignatureVersion(PropertiesKeys.SignatureVersion.A006.name());
        } else {
            if (Util.logger != null) {
                Util.logger.logError("No valid signature key defined for " + DatabaseToken.getBankUserInfo(bankUser));
            }
            throw new RuntimeException("No valid signature key defined for " + DatabaseToken.getBankUserInfo(bankUser));
        }
        SimplePasswordCallback passwordCallback = new SimplePasswordCallback(signaturePassword);
        byte[] sigKeyEncrypted = this.sigKey.toPKCS(passwordCallback);
        if (this.sigCerts != null && !this.sigCerts.isEmpty()) {
            try {
                sigCertsEncoded = DatabaseToken.encodeCertificate(this.sigCerts);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        } else {
            sigCertsEncoded = null;
        }
        if (!userKeysInKeybag || KEYBAG_IN_DATABASE.equals(bankUser.getUser().getKeyDirectory()) || KEYBAG_IN_DATABASE_MIGRATION_NEEDED.equals(bankUser.getUser().getKeyDirectory())) {
            bankUser.setSigKey(sigKeyEncrypted);
        } else {
            Keybag keybag = this.getKeybag(bankUser, true);
            keybag.getProperties().put(propertyKey, HexTool.toHex(sigKeyEncrypted));
            if (sigCertsEncoded != null) {
                keybag.getProperties().put("A00X_CERT", HexTool.toHex(sigCertsEncoded));
            } else {
                keybag.getProperties().remove("A00X_CERT");
            }
            keybag.save();
        }
        bankUser.setSigCert(sigCertsEncoded);
        bankUser.setSigKeyLength(this.sigKey.getPublicKey().getModulus().bitLength());
    }

    private Keybag getKeybag(BankUser bankUser, boolean delete) throws IOException, InvalidPasswordException {
        File keybagFile;
        File keydir = new File(bankUser.getUser().getKeyDirectory());
        if (!keydir.isAbsolute()) {
            keydir = new File(Util.WORKSPACEDIR, bankUser.getUser().getKeyDirectory());
        }
        if ((keybagFile = new File(keydir, bankUser.getBank().getUniqueKey() + ".keybag")).exists() && delete) {
            keybagFile.delete();
        }
        return new Keybag(keybagFile);
    }

    public void saveTransportKeys(BankUser bankUser, char[] loginPassword) throws IOException, GeneralSecurityException {
        if (userKeysInKeybag) {
            if (loginPassword == null) {
                throw new UnsupportedOperationException("Saving without password is not supported. Use saveSignatureKey!");
            }
            Keybag keybag = this.getKeybag(bankUser, false);
            SimplePasswordCallback passwordCallback = new SimplePasswordCallback(loginPassword);
            if (this.e001 != null) {
                keybag.getProperties().put(bankUser.getDefaultUser() + "_E001", HexTool.toHex(this.e001.toPKCS(passwordCallback)));
            }
            if (this.x001 != null) {
                keybag.getProperties().put(bankUser.getDefaultUser() + "_X001", HexTool.toHex(this.x001.toPKCS(passwordCallback)));
            }
            if (this.encrCerts != null && !this.encrCerts.isEmpty()) {
                keybag.getProperties().put("E001_CERT", HexTool.toHex(DatabaseToken.encodeCertificate(this.encrCerts)));
            } else {
                keybag.getProperties().remove("E001_CERT");
            }
            if (this.authCerts != null && !this.authCerts.isEmpty()) {
                keybag.getProperties().put("X001_CERT", HexTool.toHex(DatabaseToken.encodeCertificate(this.authCerts)));
            } else {
                keybag.getProperties().remove("X001_CERT");
            }
            keybag.save();
            bankUser.setEncrKeyLength(this.e001.getPublicKey().getModulus().bitLength());
            bankUser.setAuthKeyLength(this.x001.getPublicKey().getModulus().bitLength());
        } else {
            if (this.e001 != null) {
                bankUser.setEncrKey(this.e001.toPKCS(PASSWORD_CALLBACK));
                bankUser.setEncrKeyLength(this.e001.getPublicKey().getModulus().bitLength());
            } else {
                bankUser.setEncrKey(null);
                bankUser.setEncrKeyLength(0);
            }
            if (this.x001 != null) {
                bankUser.setAuthKey(this.x001.toPKCS(PASSWORD_CALLBACK));
                bankUser.setAuthKeyLength(this.x001.getPublicKey().getModulus().bitLength());
            } else {
                bankUser.setAuthKey(null);
                bankUser.setAuthKeyLength(0);
            }
        }
        bankUser.setAuthCert(DatabaseToken.encodeCertificate(this.authCerts));
        bankUser.setEncrCert(DatabaseToken.encodeCertificate(this.encrCerts));
    }

    @Override
    public boolean hasTransportKeys() {
        return this.e001 != null && this.x001 != null;
    }

    @Override
    public boolean hasTransportCertificates() {
        return this.encrCerts != null && !this.encrCerts.isEmpty() && this.authCerts != null && !this.authCerts.isEmpty();
    }

    @Override
    public boolean hasSignatureCertificates() {
        return this.sigCerts != null && !this.sigCerts.isEmpty();
    }

    public static byte[] encodeCertificate(List<X509Certificate> certChain) throws GeneralSecurityException, IOException {
        if (certChain == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (X509Certificate cert : certChain) {
            byteArrayOutputStream.write(cert.getEncoded());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void saveLockUserSignature(BankUser bankUser) {
        byte[] digest = SignatureHandler.getInstance(SignatureVersion.getInstance(bankUser.getSignatureVersion())).getMessageDigest().digest(SPR_BYTES);
        byte[] signed = this.getSignature(bankUser.getDefaultUser(), digest, null, null, "SPR");
        bankUser.setLockUserSignature(signed);
    }
}

