/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.data;

import de.businesslogics.banking.awzel.data.EncodingBufferedWriter;
import de.businesslogics.banking.awzel.data.ReportCreationHandler;
import de.businesslogics.banking.database.vo.AwzelDikaEntry;
import de.businesslogics.banking.database.vo.AwzelDirInvEntry;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.AwzelParticipantContactPerson;
import de.businesslogics.banking.database.vo.AwzelTransitEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class ReportCreationXmlHandler
implements ReportCreationHandler {
    private static final Charset ENCODING = Charset.forName("ISO-8859-1");
    private static final DateFormat XML_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final EncodingBufferedWriter writer;
    private int indent;

    public ReportCreationXmlHandler(OutputStream out) {
        this.writer = new EncodingBufferedWriter(out, ENCODING);
    }

    @Override
    public void startReport(AwzelParticipantContactPerson sender, AwzelParticipantContactPerson originator, AwzelParticipantContactPerson addressee, String comment) throws IOException {
        this.writer.appendData("<?xml version=\"1.0\" encoding=\"");
        this.writer.appendData(ENCODING.displayName());
        this.writer.appendData("\"?>\n");
        this.openElement("LIEFERUNG-AWZEL", new Attribute("xmlns", "http://www.bundesbank.de/xmw/2003-01-01"), new Attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"), new Attribute("xmlns:schemaLocation", "http://www.bundesbank.de/xmw/2003-01-01 BbkXmwAwzel.xsd"), new Attribute("version", "1.0"), new Attribute("erstellzeit", XML_DATE_FORMAT.format(new Date())), new Attribute("stufe", "Produktion"), new Attribute("bereich", "Statistik"));
        this.writeAddress("ABSENDER", sender);
        this.writeAddress("ERSTELLER", originator);
        this.writeAddress("ADRESSAT", addressee);
        if (comment != null) {
            this.writeElement("KOMMENTAR", comment, new Attribute[0]);
        }
    }

    @Override
    public void addReportEntry(AwzelEntry entry, int month, int year) throws IOException {
        this.openElement("MELDUNG", new Attribute("erstellzeit", XML_DATE_FORMAT.format(new Date())));
        this.writeAddress("MELDEPFLICHTIGER", entry.getEntryReporter());
        if (entry.getComment() != null) {
            this.writeElement("KOMMENTAR", entry.getComment(), new Attribute[0]);
        }
        this.writeElement("MELDETERMIN", String.format("%1$04d-%2$02d", year, month), new Attribute[0]);
        if (entry.getReportReference() != null) {
            this.writeElement("MELDUNGSREF", entry.getReportReference(), new Attribute[0]);
        }
        this.openElement("VDR_04", new Attribute[0]);
        if (entry.getType() == AwzelEntry.EntryType.DIKA) {
            this.writeDikaEntry(entry);
        } else if (entry.getType() == AwzelEntry.EntryType.TRANSIT) {
            this.writeTransitEntry(entry);
        } else if (entry.getType() == AwzelEntry.EntryType.DIRINV) {
            this.writeDirinvEntry(entry);
        }
        this.closeElement("VDR_04");
        this.closeElement("MELDUNG");
    }

    @Override
    public void endReport() throws IOException {
        this.closeElement("LIEFERUNG-AWZEL");
        this.writer.appendData("\n");
        this.writer.flush();
    }

    private void writeAddress(String tagname, AwzelParticipantContactPerson participant) throws IOException {
        if (participant == null) {
            return;
        }
        this.openElement(tagname, new Attribute[0]);
        if (participant.getCompany() != null && participant.getCompany().getInstituteId() != null) {
            this.writeElement("FIRMENNR", participant.getCompany().getInstituteId(), new Attribute[0]);
        }
        if (participant.getCompany() != null && participant.getCompany().getName() != null) {
            this.writeElement("NAME", participant.getCompany().getName(), new Attribute[0]);
        }
        if (participant.getCompany() != null && participant.getCompany().getStreet() != null) {
            this.writeElement("STRASSE", participant.getCompany().getStreet(), new Attribute[0]);
        } else if (participant.getCompany() != null && participant.getCompany().getPostOfficeBox() != null) {
            this.writeElement("POSTFACH", participant.getCompany().getPostOfficeBox(), new Attribute[0]);
        }
        if (participant.getCompany() != null && participant.getCompany().getZipCode() != null) {
            this.writeElement("PLZ", participant.getCompany().getZipCode(), new Attribute[0]);
        }
        if (participant.getCompany() != null && participant.getCompany().getTown() != null) {
            this.writeElement("ORT", participant.getCompany().getTown(), new Attribute[0]);
        }
        if (participant.getCompany() != null && participant.getCompany().getCountry() != null) {
            this.writeElement("LAND", participant.getCompany().getCountry(), new Attribute[0]);
        }
        this.openElement("KONTAKT", new Attribute[0]);
        if (participant.getTitle() != null) {
            this.writeElement("ANREDE", participant.getTitle(), new Attribute[0]);
        }
        if (participant.getFirstName() != null) {
            this.writeElement("VORNAME", participant.getFirstName(), new Attribute[0]);
        }
        if (participant.getSurname() != null) {
            this.writeElement("ZUNAME", participant.getSurname(), new Attribute[0]);
        }
        if (participant.getDepartment() != null) {
            this.writeElement("ABTEILUNG", participant.getDepartment(), new Attribute[0]);
        }
        if (participant.getPhone() != null) {
            this.writeElement("TELEFON", participant.getPhone(), new Attribute[0]);
        }
        if (participant.getFax() != null) {
            this.writeElement("FAX", participant.getFax(), new Attribute[0]);
        }
        if (participant.getEmail() != null) {
            this.writeElement("EMAIL", participant.getEmail(), new Attribute[0]);
        }
        if (participant.getExtranetId() != null) {
            this.writeElement("EXTRANET-ID", participant.getExtranetId(), new Attribute[0]);
        }
        this.closeElement("KONTAKT");
        this.closeElement(tagname);
    }

    private void writeDikaEntry(AwzelEntry entry) throws IOException {
        AwzelDikaEntry dikaEntry = entry.getDikaEntry();
        if (dikaEntry == null) {
            return;
        }
        this.openElement("DIKAPPOSTEN", new Attribute("belegart", entry.getCategory()), new Attribute("kennzahl", entry.getServiceCode()), new Attribute("zahlungszweck", this.appendRawDataToStringBuilder(new StringBuilder(), dikaEntry.getPurpose())));
        this.writeAmount(dikaEntry.getAmountInEurDouble(), dikaEntry.getCountryCode(), dikaEntry.getReferenceAmount(), dikaEntry.getSettlementKey(), entry.isCancellation());
        this.closeElement("DIKAPPOSTEN");
    }

    private void writeTransitEntry(AwzelEntry awzelEntry) throws IOException {
        if (awzelEntry.getTransitEntries() == null || awzelEntry.getTransitEntries().size() == 0) {
            return;
        }
        this.openElement("TRANSITPOSTEN", new Attribute("belegart", awzelEntry.getCategory()), new Attribute("kennzahl", awzelEntry.getServiceCode()));
        for (AwzelTransitEntry entry : awzelEntry.getTransitEntries()) {
            this.openElement("TRANSIT", new Attribute("warencode", entry.getWareCode()), new Attribute("warenbez", this.appendRawDataToStringBuilder(new StringBuilder(), entry.getWareName())));
            this.writeAmount(entry.getAmountInEurDouble(), entry.getCountryCode(), entry.getReferenceAmount(), entry.getSettlementKey(), awzelEntry.isCancellation());
            this.closeElement("TRANSIT");
        }
        this.closeElement("TRANSITPOSTEN");
    }

    private void writeDirinvEntry(AwzelEntry awzelEntry) throws IOException {
        if (awzelEntry.getDirInvEntries() == null || awzelEntry.getDirInvEntries().size() == 0) {
            return;
        }
        this.openElement("DIRINVPOSTEN", new Attribute("belegart", awzelEntry.getCategory()), new Attribute("kennzahl", awzelEntry.getServiceCode()));
        for (AwzelDirInvEntry entry : awzelEntry.getDirInvEntries()) {
            this.openElement("WERTPAPIER", new Attribute("isin", entry.getIsin()), new Attribute("bezeichnung", this.appendRawDataToStringBuilder(new StringBuilder(), entry.getLabel())));
            StringBuilder stockNumberBuilder = new StringBuilder();
            if (awzelEntry.isCancellation().booleanValue()) {
                stockNumberBuilder.append('-');
            }
            stockNumberBuilder.append(entry.getStockNumber());
            this.writeElement("STUECK", stockNumberBuilder.toString(), new Attribute[0]);
            this.writeAmount(entry.getAmountInEurDouble(), entry.getCountryCode(), entry.getReferenceAmount(), entry.getSettlementKey(), awzelEntry.isCancellation());
            this.closeElement("WERTPAPIER");
        }
        this.closeElement("DIRINVPOSTEN");
    }

    private void writeAmount(Double amountInEur, String countryCode, String amountReference, Character settlementKey, boolean cancellation) throws IOException {
        StringBuilder amountBuilder = new StringBuilder();
        if (cancellation) {
            amountBuilder.append('-');
        }
        amountBuilder.append(Math.round(amountInEur / 1000.0));
        this.writeElement("BETRAG", amountBuilder.toString(), new Attribute("land", countryCode), new Attribute("betragsref", this.appendRawDataToStringBuilder(new StringBuilder(), amountReference)), new Attribute("verrkz", settlementKey));
    }

    private void openElement(String tagname, Attribute ... attributes) throws IOException {
        StringBuilder builder = new StringBuilder();
        this.appendNewLineToStringBuilder(builder);
        builder.append('<');
        builder.append(tagname);
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                attribute.appendToStringBuilder(builder);
            }
        }
        builder.append('>');
        this.writer.appendData(builder);
        ++this.indent;
    }

    private void closeElement(String tagname) throws IOException {
        StringBuilder builder = new StringBuilder();
        --this.indent;
        this.appendNewLineToStringBuilder(builder);
        builder.append('<');
        builder.append('/');
        builder.append(tagname);
        builder.append('>');
        this.writer.appendData(builder);
    }

    private void writeElement(String tagname, String content, Attribute ... attributes) throws IOException {
        StringBuilder builder = new StringBuilder();
        this.appendNewLineToStringBuilder(builder);
        builder.append('<');
        builder.append(tagname);
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                attribute.appendToStringBuilder(builder);
            }
        }
        if (content == null) {
            builder.append(' ');
            builder.append('/');
            builder.append('>');
        } else {
            builder.append('>');
            this.appendRawDataToStringBuilder(builder, content.trim());
            builder.append('<');
            builder.append('/');
            builder.append(tagname);
            builder.append('>');
        }
        this.writer.appendData(builder);
    }

    private StringBuilder appendNewLineToStringBuilder(StringBuilder builder) {
        builder.append('\n');
        for (int i = 0; i < this.indent; ++i) {
            builder.append('\t');
        }
        return builder;
    }

    private StringBuilder appendRawDataToStringBuilder(StringBuilder builder, CharSequence rawData) {
        if (rawData == null) {
            return builder;
        }
        for (int i = 0; i < rawData.length(); ++i) {
            if (rawData.charAt(i) == '<') {
                builder.append("&lt;");
                continue;
            }
            if (rawData.charAt(i) == '>') {
                builder.append("&gt;");
                continue;
            }
            if (rawData.charAt(i) == '&') {
                builder.append("&amp;");
                continue;
            }
            if (rawData.charAt(i) == '\"') {
                builder.append("&quot;");
                continue;
            }
            if (rawData.charAt(i) == '\'') {
                builder.append("&apos;");
                continue;
            }
            if (rawData.charAt(i) == ' ' || rawData.charAt(i) == '\t' || rawData.charAt(i) == '\r' || rawData.charAt(i) == '\n') {
                if (builder.charAt(builder.length() - 1) == ' ') continue;
                builder.append(' ');
                continue;
            }
            builder.append(rawData.charAt(i));
        }
        return builder;
    }

    private static final class Attribute {
        private final String name;
        private final String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value != null ? String.valueOf(value) : null;
        }

        public StringBuilder appendToStringBuilder(StringBuilder builder) {
            if (this.value == null || this.value.length() == 0) {
                return builder;
            }
            builder.append(' ');
            builder.append(this.name);
            builder.append('=');
            builder.append('\"');
            if (this.value.length() > 80) {
                builder.append(this.value, 0, 80);
            } else {
                builder.append(this.value);
            }
            builder.append('\"');
            return builder;
        }
    }
}

