/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.data;

import de.businesslogics.banking.awzel.data.EncodingBufferedWriter;
import de.businesslogics.banking.awzel.data.ReportCreationHandler;
import de.businesslogics.banking.database.vo.AwzelDikaEntry;
import de.businesslogics.banking.database.vo.AwzelDirInvEntry;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.AwzelParticipantContactPerson;
import de.businesslogics.banking.database.vo.AwzelTransitEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class ReportCreationCsvHandler
implements ReportCreationHandler {
    private final EncodingBufferedWriter writer;

    public ReportCreationCsvHandler(OutputStream out) {
        this.writer = new EncodingBufferedWriter(out, Charset.forName("ISO-8859-15"));
    }

    @Override
    public void startReport(AwzelParticipantContactPerson sender, AwzelParticipantContactPerson originator, AwzelParticipantContactPerson addressee, String comment) throws IOException {
    }

    @Override
    public void addReportEntry(AwzelEntry entry, int month, int year) throws IOException {
        block3: {
            block4: {
                block2: {
                    if (entry.getType() != AwzelEntry.EntryType.DIKA) break block2;
                    this.addReportDikaEntry(entry.getDikaEntry());
                    break block3;
                }
                if (entry.getType() != AwzelEntry.EntryType.DIRINV) break block4;
                for (AwzelDirInvEntry dirinvEntry : entry.getDirInvEntries()) {
                    this.addReportDirinvEntry(dirinvEntry);
                }
                break block3;
            }
            if (entry.getType() != AwzelEntry.EntryType.TRANSIT) break block3;
            for (AwzelTransitEntry transitEntry : entry.getTransitEntries()) {
                this.addTransitEntry(transitEntry);
            }
        }
    }

    @Override
    public void endReport() throws IOException {
        this.writer.flush();
    }

    private void addReportDikaEntry(AwzelDikaEntry dikaEntry) throws IOException {
        if (dikaEntry == null) {
            return;
        }
        if (dikaEntry.getAbstractEntry().getCategory() != null) {
            this.writer.appendCharacter((char)(dikaEntry.getAbstractEntry().getCategory() + 48));
        }
        this.writer.appendCharacter(';');
        this.writer.appendData(dikaEntry.getAbstractEntry().getServiceCode());
        this.writer.appendCharacter(';');
        this.writer.appendData(dikaEntry.getPurpose());
        this.writer.appendCharacter(';');
        this.writer.appendData(dikaEntry.getAbstractEntry().getCountryCode());
        this.writer.appendCharacter(';');
        if (dikaEntry.getAmountInEur() != null) {
            if (dikaEntry.getAbstractEntry().isCancellation().booleanValue()) {
                this.writer.appendCharacter('-');
            }
            this.writer.appendData(String.valueOf(dikaEntry.getAmountInEurDouble().intValue()));
        }
        this.writer.appendCharacter('\n');
    }

    private void addReportDirinvEntry(AwzelDirInvEntry dirInvEntry) throws IOException {
        if (dirInvEntry == null) {
            return;
        }
        if (dirInvEntry.getAbstractEntry().getCategory() != null) {
            this.writer.appendCharacter((char)(dirInvEntry.getAbstractEntry().getCategory() + 48));
        }
        this.writer.appendCharacter(';');
        this.writer.appendData(dirInvEntry.getAbstractEntry().getServiceCode());
        this.writer.appendCharacter(';');
        this.writer.appendData(dirInvEntry.getLabel());
        this.writer.appendCharacter(';');
        this.writer.appendData(dirInvEntry.getCountryCode());
        this.writer.appendCharacter(';');
        if (dirInvEntry.getAmountInEur() != null) {
            if (dirInvEntry.getAbstractEntry().isCancellation().booleanValue()) {
                this.writer.appendCharacter('-');
            }
            this.writer.appendData(String.valueOf(dirInvEntry.getAmountInEurDouble().intValue()));
        }
        this.writer.appendCharacter(';');
        this.writer.appendData(dirInvEntry.getIsin());
        this.writer.appendCharacter(';');
        this.writer.appendData(dirInvEntry.getStockNumber().toString());
        this.writer.appendCharacter('\n');
    }

    private void addTransitEntry(AwzelTransitEntry transitEntry) throws IOException {
        if (transitEntry == null) {
            return;
        }
        if (transitEntry.getAbstractEntry().getCategory() != null) {
            this.writer.appendCharacter((char)(transitEntry.getAbstractEntry().getCategory() + 48));
        }
        this.writer.appendCharacter(';');
        this.writer.appendData(transitEntry.getAbstractEntry().getServiceCode());
        this.writer.appendCharacter(';');
        this.writer.appendData(transitEntry.getWareName());
        this.writer.appendCharacter(';');
        this.writer.appendData(transitEntry.getCountryCode());
        this.writer.appendCharacter(';');
        if (transitEntry.getAmountInEur() != null) {
            if (transitEntry.getAbstractEntry().isCancellation().booleanValue()) {
                this.writer.appendCharacter('-');
            }
            this.writer.appendData(String.valueOf(transitEntry.getAmountInEurDouble().intValue()));
        }
        this.writer.appendCharacter(';');
        this.writer.appendData(transitEntry.getWareCode());
        this.writer.appendCharacter('\n');
    }
}

