/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class EncodingBufferedWriter {
    private final char[] buffer = new char[1024];
    private final OutputStream out;
    private final Charset encoding;
    private int bufferPos;

    public EncodingBufferedWriter(OutputStream out, Charset encoding) {
        this.out = out;
        this.encoding = encoding;
    }

    public void appendData(CharSequence sequence) throws IOException {
        if (sequence == null) {
            return;
        }
        if (this.bufferPos == this.buffer.length) {
            this.flush();
        }
        for (int i = 0; i < sequence.length(); ++i) {
            this.buffer[this.bufferPos++] = sequence.charAt(i);
            if (this.bufferPos != this.buffer.length) continue;
            this.flush();
        }
    }

    public void appendCharacter(char c) throws IOException {
        if (this.bufferPos == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.bufferPos++] = c;
        if (this.bufferPos == this.buffer.length) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        this.out.write(new String(this.buffer, 0, this.bufferPos).getBytes(this.encoding));
        this.out.flush();
        this.bufferPos = 0;
    }
}

