/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public final class WareCodeProvider {
    private final Locale locale;
    private Map<String, String> wareCodes;

    public WareCodeProvider(Locale locale) {
        this.locale = locale;
    }

    public Map<String, String> getProposals(String contents) {
        TreeMap<String, String> resultList = new TreeMap<String, String>();
        for (String key : this.getWareCodes().keySet()) {
            if (contents == null || !key.contains(contents)) continue;
            resultList.put(key, this.getWareLabel(key));
        }
        return resultList;
    }

    public String getWareLabel(String warecodeString) {
        StringBuilder result = new StringBuilder();
        if (warecodeString != null) {
            result.append(warecodeString);
            String description = this.getWareCodes().get(warecodeString);
            if (description != null) {
                result.append(" - ");
                if (description.length() > 45) {
                    result.append(description.substring(0, 45) + "\u2026");
                } else {
                    result.append(description);
                }
            }
        }
        return result.toString();
    }

    public String getWareDescription(String warecode) {
        return this.getWareCodes().get(warecode);
    }

    private synchronized Map<String, String> getWareCodes() {
        if (this.wareCodes == null) {
            ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.banking.awzel.api.warecode", this.locale);
            this.wareCodes = new HashMap<String, String>();
            for (String bundleKey : bundle.keySet()) {
                this.wareCodes.put(bundleKey, bundle.getString(bundleKey));
            }
        }
        return this.wareCodes;
    }
}

