/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.api;

import de.businesslogics.banking.awzel.api.AwzelApi;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AwzelDikaEntry;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public abstract class StatementBookingReportCollector {
    private static final List<String> IGNORED_TRANSACTION_CODES = new ArrayList<String>();
    protected int numberOfImportedStatements;

    protected final boolean checkBooking(CmBooking booking) {
        if (CmStatement.AdviceTypes.contains((Object)booking.getStatement().getType())) {
            return false;
        }
        String foreignCountryCode = this.determineForeignCountryCode(booking);
        if (foreignCountryCode == null || AwzelApi.COUNTRY_CODE_GERMANY.equals(foreignCountryCode)) {
            return false;
        }
        if (booking.getAmount() == null) {
            return false;
        }
        BigDecimal amountInEur = AwzelApi.getAmountInEuro(booking.getAmount(), booking.getCurrency());
        if (amountInEur != null && amountInEur.abs().compareTo(AwzelApi.MIN_REPORT_AMOUNT) <= 0) {
            return false;
        }
        if (booking.getGvc() != null && IGNORED_TRANSACTION_CODES.contains(booking.getGvc())) {
            return false;
        }
        String endToEndId = booking.getEndToEndId() != null ? booking.getEndToEndId() : (booking.getCustomerReference() != null ? booking.getCustomerReference() : null);
        return endToEndId == null || !AwzelEntry.hasEntryForEndToEndId(endToEndId, booking.getAccount().getBank().getTenant());
    }

    public final AwzelEntry storeStatementBooking(CmBooking booking) {
        if (booking == null) {
            return null;
        }
        Date d = booking.getBookingDate();
        if (d == null && (d = booking.getValueDate()) == null) {
            Timestamp ts = booking.getStatement().getCreationDate();
            d = ts != null ? new Date(ts.getTime()) : new Date(System.currentTimeMillis());
        }
        String monthString = AwzelApi.DATA_FILE_MONTH_FORMAT.format(d);
        AwzelEntry result = new AwzelEntry();
        result.setReportMonth(monthString);
        if (booking.getEndToEndId() != null) {
            result.setEndToEndId(booking.getEndToEndId());
        } else if (booking.getCustomerReference() != null) {
            result.setEndToEndId(booking.getCustomerReference());
        }
        result.setTenant(booking.getAccount().getBank().getTenant());
        result.setType(AwzelEntry.EntryType.DIKA);
        AwzelDikaEntry dikaEntry = new AwzelDikaEntry();
        result.setDikaEntry(dikaEntry);
        dikaEntry.setPurpose(booking.getPurpose());
        String referenceAmount = booking.getCurrency() != null && booking.getAmount() != null ? String.format("%1$s %2$.2f", booking.getCurrency().toString(), booking.getAmount().abs().doubleValue()) : null;
        BigDecimal amountInEur = AwzelApi.getAmountInEuro(booking.getAmount(), booking.getCurrency());
        if (amountInEur != null) {
            dikaEntry.setAmountInEur(amountInEur.abs().doubleValue());
        }
        dikaEntry.setCountryCode(this.determineForeignCountryCode(booking));
        dikaEntry.setReferenceAmount(referenceAmount);
        result.setCmBooking(booking);
        result.setOrigin(AwzelEntry.Origin.ACCOUNT_STATEMENT);
        result.save();
        return result;
    }

    private String determineForeignCountryCode(CmBooking booking) {
        Account a = booking.getAccount();
        String ownAccountCountry = a.getIban() != null ? AwzelApi.getCountryCodeFromAccountString(null, a.getIban()) : (a.getGermanAccountNumber() != null ? AwzelApi.getCountryCodeFromAccountString(a.getGermanBankCode(), a.getGermanAccountNumber()) : "XY");
        if (ownAccountCountry != null && !AwzelApi.COUNTRY_CODE_GERMANY.equals(ownAccountCountry)) {
            return null;
        }
        String partnerAccountCountry = AwzelApi.getCountryCodeFromAccountString(booking.getCounterPartyBankCode(), booking.getCounterPartyAccountNumber());
        String foreignCountryCode = AwzelApi.COUNTRY_CODE_GERMANY.equals(ownAccountCountry) ? partnerAccountCountry : (AwzelApi.COUNTRY_CODE_GERMANY.equals(partnerAccountCountry) ? ownAccountCountry : (ownAccountCountry != null ? ownAccountCountry : partnerAccountCountry));
        return foreignCountryCode;
    }

    static {
        IGNORED_TRANSACTION_CODES.add("079");
        IGNORED_TRANSACTION_CODES.add("091");
        IGNORED_TRANSACTION_CODES.add("092");
        IGNORED_TRANSACTION_CODES.add("188");
        IGNORED_TRANSACTION_CODES.add("189");
        IGNORED_TRANSACTION_CODES.add("190");
        IGNORED_TRANSACTION_CODES.add("191");
        IGNORED_TRANSACTION_CODES.add("192");
        IGNORED_TRANSACTION_CODES.add("194");
        IGNORED_TRANSACTION_CODES.add("195");
        IGNORED_TRANSACTION_CODES.add("196");
        IGNORED_TRANSACTION_CODES.add("197");
        IGNORED_TRANSACTION_CODES.add("198");
    }
}

