/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.api;

import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.util.BLLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public final class ServiceCodeProvider {
    private static final Map<String, Map<ServiceCodeDetails, String>> SERVICE_CODES_MAP = new HashMap<String, Map<ServiceCodeDetails, String>>();
    private static final int MAX_LENGTH_LABEL = 50;
    private final AwzelEntry.EntryType entryType;
    private final BLLogger logger;
    private final Locale locale;
    private Map<ServiceCodeDetails, String> serviceCodes;
    private int category;

    public ServiceCodeProvider(AwzelEntry.EntryType entryType, BLLogger logger, Locale locale) {
        this.entryType = entryType;
        this.logger = logger;
        this.locale = locale;
    }

    public List<ServiceCodeDetails> getProposals(String search) {
        if (this.serviceCodes == null) {
            this.loadServiceCodes();
        }
        ArrayList<ServiceCodeDetails> result = new ArrayList<ServiceCodeDetails>();
        for (ServiceCodeDetails codeDetails : this.serviceCodes.keySet()) {
            if (!codeDetails.doesMatchEntryType(this.entryType) || !codeDetails.isCategorySupported(this.category) || !codeDetails.doesMatchContents(search)) continue;
            result.add(codeDetails);
        }
        return result;
    }

    public String getServiceDescription(String serviceCode) {
        if (this.serviceCodes == null) {
            this.loadServiceCodes();
        }
        if (serviceCode == null || serviceCode.length() != 3) {
            return "";
        }
        for (ServiceCodeDetails details : this.serviceCodes.keySet()) {
            if (!details.serviceCode.equals(serviceCode) || !details.doesMatchEntryType(this.entryType) || !details.isCategorySupported(this.category)) continue;
            return this.serviceCodes.get(details);
        }
        return "";
    }

    public void setCategory(int category) {
        this.category = category;
    }

    private synchronized void loadServiceCodes() {
        if (this.serviceCodes != null) {
            return;
        }
        this.serviceCodes = SERVICE_CODES_MAP.get(this.locale.getLanguage());
        if (this.serviceCodes != null) {
            return;
        }
        this.serviceCodes = new TreeMap<ServiceCodeDetails, String>();
        SERVICE_CODES_MAP.put(this.locale.getLanguage(), this.serviceCodes);
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.banking.awzel.api.servicecode", this.locale);
        for (String key : bundle.keySet()) {
            int[] categories;
            AwzelEntry.EntryType entryType;
            int partStartPos;
            String serviceCode;
            int partEndPos = key.indexOf(46);
            if (partEndPos < 0 && key.length() == 3) {
                serviceCode = key;
                partStartPos = -1;
            } else if (partEndPos == 3) {
                serviceCode = key.substring(0, 3);
                partStartPos = 4;
            } else {
                this.logger.logWarning("Ignoring bundle key: " + key);
                continue;
            }
            if (partStartPos > 0 && key.length() > partStartPos + 1) {
                String entryTypeString;
                partEndPos = key.indexOf(46, partStartPos);
                if (partEndPos < partStartPos) {
                    entryTypeString = key.substring(partStartPos).toUpperCase();
                } else {
                    entryTypeString = key.substring(partStartPos, partEndPos).toUpperCase();
                    partStartPos = partEndPos + 1;
                }
                entryType = "DIKA".equals(entryTypeString) ? AwzelEntry.EntryType.DIKA : ("TRANSIT".equals(entryTypeString) ? AwzelEntry.EntryType.TRANSIT : ("DIRINV".equals(entryTypeString) ? AwzelEntry.EntryType.DIRINV : null));
            } else {
                entryType = null;
            }
            if (partStartPos > 0 && key.length() > partStartPos) {
                categories = new int[key.length() - partStartPos];
                for (int categoryPos = 0; categoryPos < categories.length; ++categoryPos) {
                    categories[categoryPos] = key.charAt(partStartPos + categoryPos) - 48;
                    if (categories[categoryPos] >= 1 && categories[categoryPos] <= 6) continue;
                    this.logger.logWarning("Invalid category in key: " + key);
                }
            } else {
                categories = null;
            }
            this.serviceCodes.put(new ServiceCodeDetails(serviceCode, entryType, categories), bundle.getString(key));
            if (!AwzelEntry.EntryType.DIRINV.equals((Object)entryType)) continue;
            this.serviceCodes.put(new ServiceCodeDetails(serviceCode, AwzelEntry.EntryType.DIKA, categories), bundle.getString(key));
        }
    }

    public final class ServiceCodeDetails
    implements Comparable<ServiceCodeDetails> {
        private final String serviceCode;
        private final AwzelEntry.EntryType entryType;
        private final int[] categories;
        private String label;
        private boolean labelShortened;
        private int hashCode;

        private ServiceCodeDetails(String serviceCode, AwzelEntry.EntryType entryType, int[] categories) {
            this.serviceCode = serviceCode;
            this.categories = categories;
            this.entryType = entryType;
            this.hashCode = 0;
        }

        public String getServiceCode() {
            return this.serviceCode;
        }

        public boolean doesMatchEntryType(AwzelEntry.EntryType checkEntryType) {
            if (this.entryType == null) {
                return true;
            }
            return this.entryType == checkEntryType;
        }

        public boolean isCategorySupported(int checkCategory) {
            if (this.categories == null || this.categories.length == 0 || checkCategory == 0) {
                return true;
            }
            for (int category : this.categories) {
                if (checkCategory != category) continue;
                return true;
            }
            return false;
        }

        public boolean doesMatchContents(String contents) {
            if (contents == null || contents.length() == 0) {
                return true;
            }
            return this.serviceCode.startsWith(contents);
        }

        public String getLabel() {
            if (this.label == null) {
                StringBuilder labelBuilder = new StringBuilder(this.serviceCode).append(" - ").append(ServiceCodeProvider.this.serviceCodes.get(this));
                if (labelBuilder.length() >= 50) {
                    this.label = labelBuilder.substring(0, 50) + "...";
                    this.labelShortened = true;
                } else {
                    this.label = labelBuilder.toString();
                    this.labelShortened = false;
                }
            }
            return this.label;
        }

        public String getDescription() {
            if (this.label == null) {
                this.getLabel();
            }
            if (this.labelShortened) {
                return ServiceCodeProvider.this.serviceCodes.get(this);
            }
            return null;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            for (int i = 0; this.serviceCode != null && i < this.serviceCode.length(); ++i) {
                this.hashCode = (this.hashCode << 4) + (this.serviceCode.charAt(i) - 48 & 0xF);
            }
            this.hashCode = this.entryType != null ? (this.hashCode << 2) + (this.entryType.ordinal() + 1 & 3) : (this.hashCode <<= 2);
            int categorymask = 0;
            for (int i = 0; this.categories != null && i < this.categories.length; ++i) {
                categorymask |= 1 << this.categories[i] - 1;
            }
            this.hashCode = (this.hashCode << 6) + categorymask;
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ServiceCodeDetails)) {
                return false;
            }
            return this.compareTo((ServiceCodeDetails)obj) == 0;
        }

        @Override
        public int compareTo(ServiceCodeDetails o) {
            if (o == null) {
                return 1;
            }
            return this.hashCode() - o.hashCode();
        }
    }
}

