/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.awzel.PreferenceConstants;
import de.businesslogics.banking.awzel.api.AwzelApiMessages;
import de.businesslogics.banking.awzel.data.ExportFormat;
import de.businesslogics.banking.awzel.data.ReportCreationHandler;
import de.businesslogics.banking.awzel.data.ReportCreationInfo;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.AwzelExport;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.util.BLLogger;
import io.ebean.Query;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;

public abstract class ReportCreationRunnerApi
implements Runnable {
    private final File directory;
    private final ReportCreationInfo info;
    private final User user;
    private final BLLogger logger;
    private final Locale locale;
    private final boolean forcePlain;
    private String reporterId;
    private List<File> resultFiles;
    private List<AwzelExport> exports;

    protected ReportCreationRunnerApi(File directory, ReportCreationInfo info, User user, BLLogger logger, Locale locale, boolean forcePlain) {
        this.directory = directory;
        this.info = info;
        this.user = user;
        this.logger = logger;
        this.locale = locale;
        this.forcePlain = forcePlain;
        if (!directory.isDirectory() && !directory.mkdirs()) {
            logger.logWarning("Failed to created target directory for AWV report file: " + directory.getAbsolutePath());
        }
    }

    protected ReportCreationRunnerApi(File directory, ReportCreationInfo info, User user, BLLogger logger, Locale locale, List<AwzelExport> exports, boolean forcePlain) {
        this.directory = directory;
        this.info = info;
        this.user = user;
        this.logger = logger;
        this.locale = locale;
        this.exports = exports;
        this.forcePlain = forcePlain;
        if (!directory.isDirectory() && !directory.mkdirs()) {
            logger.logWarning("Failed to created target directory for AWV report file: " + directory.getAbsolutePath());
        }
    }

    @Override
    public void run() {
        ExportFormat format = ExportFormat.getByName(new DatabasePreferenceStore(Preference.ApplicationId.AWZEL, this.user).getString(PreferenceConstants.EXPORT_FORMAT));
        ArrayList<Integer> entriesToUpdate = new ArrayList<Integer>();
        if (format == ExportFormat.XML) {
            File tempFile = this.createExportFile(format, AwzelEntry.getEntriesForMonthAndReporter(this.info.getMonth(), this.info.getYear(), this.user, this.info.getReporter()), entriesToUpdate, false);
            StringBuilder filenameBuilder = new StringBuilder(String.format("awzel_%1$04d%2$02d_", this.info.getYear(), this.info.getMonth()));
            if (this.reporterId == null) {
                filenameBuilder.append(this.info.getSender().getCompany().getInstituteId());
            } else {
                filenameBuilder.append(this.reporterId);
            }
            filenameBuilder.append(".xml");
            File exportFile = new File(this.directory, filenameBuilder.toString());
            if (!this.moveFileIfNotEmpty(tempFile, exportFile)) {
                return;
            }
            this.addResultFile(exportFile);
        } else if (format == ExportFormat.CSV) {
            File file;
            File servicesTempFile = this.createExportFile(format, AwzelEntry.getServicesEntriesForMonth(this.info.getMonth(), this.info.getYear(), this.user), entriesToUpdate, true);
            File capitalTempFile = this.createExportFile(format, AwzelEntry.getCapitalEntriesForMonth(this.info.getMonth(), this.info.getYear(), this.user), entriesToUpdate, true);
            File transitTempFile = this.createExportFile(format, AwzelEntry.getTransitEntriesForMonth(this.info.getMonth(), this.info.getYear(), this.user), entriesToUpdate, true);
            File dirinvTempFile = this.createExportFile(format, AwzelEntry.getDirInvEntriesForMonth(this.info.getMonth(), this.info.getYear(), this.user), entriesToUpdate, true);
            if (entriesToUpdate.isEmpty()) {
                this.handleError(BankingApiMessages.getString(this.locale, "GeneralMessages.noEntriesToExport", new Object[0]));
                return;
            }
            String filePrefix = String.format("awzel_%1$04d_%2$02d_", this.info.getYear(), this.info.getMonth());
            if (servicesTempFile != null) {
                file = new File(this.directory, filePrefix + AwzelApiMessages.getString(this.locale, "ReportCreationRunner.csv.services", new Object[0]) + ".csv");
                this.moveFileIfNotEmpty(servicesTempFile, file);
                this.addResultFile(file);
            }
            if (capitalTempFile != null) {
                file = new File(this.directory, filePrefix + AwzelApiMessages.getString(this.locale, "ReportCreationRunner.csv.capital", new Object[0]) + ".csv");
                this.moveFileIfNotEmpty(capitalTempFile, file);
                this.addResultFile(file);
            }
            if (transitTempFile != null) {
                file = new File(this.directory, filePrefix + AwzelApiMessages.getString(this.locale, "ReportCreationRunner.csv.transit", new Object[0]) + ".csv");
                this.moveFileIfNotEmpty(transitTempFile, file);
                this.addResultFile(file);
            }
            if (dirinvTempFile != null) {
                file = new File(this.directory, filePrefix + AwzelApiMessages.getString(this.locale, "ReportCreationRunner.csv.dirinv", new Object[0]) + ".csv");
                this.moveFileIfNotEmpty(dirinvTempFile, file);
                this.addResultFile(file);
            }
            if (servicesTempFile != null && servicesTempFile.isFile() && !servicesTempFile.delete()) {
                this.logger.logWarning("Failed to delete temporary AWV services file " + servicesTempFile.getAbsolutePath());
                servicesTempFile.deleteOnExit();
            }
            if (capitalTempFile != null && capitalTempFile.isFile() && !capitalTempFile.delete()) {
                this.logger.logWarning("Failed to delete temporary AWV capital file " + capitalTempFile.getAbsolutePath());
                capitalTempFile.deleteOnExit();
            }
            if (transitTempFile != null && transitTempFile.isFile() && !transitTempFile.delete()) {
                this.logger.logWarning("Failed to delete temporary AWV transit file " + transitTempFile.getAbsolutePath());
                transitTempFile.deleteOnExit();
            }
            if (dirinvTempFile != null && dirinvTempFile.isFile() && !dirinvTempFile.delete()) {
                this.logger.logWarning("Failed to delete temporary AWV dirinv file " + dirinvTempFile.getAbsolutePath());
                dirinvTempFile.deleteOnExit();
            }
        }
        AwzelEntry.markEntriesAsExported(entriesToUpdate);
    }

    public final List<File> getResultFiles() {
        return this.resultFiles;
    }

    protected abstract boolean askToOverwrite(File var1);

    protected abstract void notifyListenersForCreatedExportFile();

    protected abstract void handleError(String var1);

    private File createExportFile(ExportFormat format, Query<AwzelEntry> query, List<Integer> entriesToUpdate, boolean hideErrorMessage) {
        MyConsumer consumer = new MyConsumer(format, entriesToUpdate);
        query.findEach((Consumer)consumer);
        if (!consumer.hasExportedData) {
            if (!hideErrorMessage) {
                this.handleError(BankingApiMessages.getString(this.locale, "GeneralMessages.noEntriesToExport", new Object[0]));
            }
            return null;
        }
        consumer.endReport();
        if (consumer.exception != null) {
            this.handleError(AwzelApiMessages.getString(this.locale, "ReportCreationRunner.exportFailed", consumer.exception.getLocalizedMessage()));
            this.logger.logError("Failed to create export file!", consumer.exception);
            return null;
        }
        return consumer.tempFile;
    }

    private boolean moveFileIfNotEmpty(File fromFile, File toFile) {
        if (fromFile == null || fromFile.isDirectory()) {
            return true;
        }
        if (fromFile.length() == 0L) {
            if (!fromFile.delete()) {
                fromFile.deleteOnExit();
                this.logger.logWarning("Failed to delete empty AWV report file " + fromFile.getAbsolutePath());
            }
            return true;
        }
        if (toFile.exists()) {
            if (!this.askToOverwrite(toFile)) {
                if (!fromFile.delete()) {
                    fromFile.deleteOnExit();
                    this.logger.logWarning("Failed to delete created AWV report file " + fromFile.getAbsolutePath());
                }
                return false;
            }
            if (!toFile.delete()) {
                this.logger.logWarning("Failed to delete old AWV report file " + toFile.getAbsolutePath());
            }
        }
        if (Util.copyFiles(fromFile, toFile)) {
            this.storeExportInformation(toFile.getAbsolutePath());
            return true;
        }
        return false;
    }

    private void storeExportInformation(String exportFile) {
        String monthString = String.format("%04d%02d", this.info.getYear(), this.info.getMonth());
        AwzelExport awzelExport = AwzelExport.findByMonth(monthString, this.info.getTenant());
        if (awzelExport == null) {
            awzelExport = new AwzelExport();
            awzelExport.setMonth(monthString);
            awzelExport.setTenant(this.info.getTenant());
        }
        awzelExport.setExportTime(new Timestamp(System.currentTimeMillis()));
        awzelExport.setExportUser(this.user.getName());
        awzelExport.setExportFile(exportFile);
        awzelExport.save();
        if (this.exports != null) {
            this.exports.add(awzelExport);
        }
        this.notifyListenersForCreatedExportFile();
    }

    private boolean addResultFile(File file) {
        if (file == null || file.length() == 0L) {
            return false;
        }
        if (this.resultFiles == null) {
            this.resultFiles = new ArrayList<File>();
        }
        return this.resultFiles.add(file);
    }

    private class MyConsumer
    implements Consumer<AwzelEntry> {
        private boolean hasExportedData = false;
        private File tempFile;
        private OutputStream tempFileOutputStream;
        private ReportCreationHandler handler;
        private boolean multipleReporterIds = false;
        private Exception exception;
        private final ExportFormat format;
        private final List<Integer> entriesToUpdate;

        public MyConsumer(ExportFormat format, List<Integer> entriesToUpdate) {
            this.format = format;
            this.entriesToUpdate = entriesToUpdate;
        }

        @Override
        public void accept(AwzelEntry awzelEntry) {
            this.hasExportedData = true;
            try {
                if (this.tempFile == null) {
                    this.tempFile = File.createTempFile("awzel_export_", ".tmp", ReportCreationRunnerApi.this.directory);
                    this.tempFileOutputStream = ReportCreationRunnerApi.this.forcePlain ? new FileOutputStream(this.tempFile) : EncryptData.getInstance().openOutputStream(this.tempFile);
                    this.multipleReporterIds = false;
                    this.handler = this.format.getReportCreationHandler(this.tempFileOutputStream);
                    this.handler.startReport(ReportCreationRunnerApi.this.info.getSender(), ReportCreationRunnerApi.this.info.getOriginator(), ReportCreationRunnerApi.this.info.getAddressee(), ReportCreationRunnerApi.this.info.getComment());
                }
                this.handler.addReportEntry(awzelEntry, ReportCreationRunnerApi.this.info.getMonth(), ReportCreationRunnerApi.this.info.getYear());
                this.entriesToUpdate.add(awzelEntry.getId());
                if (!this.multipleReporterIds) {
                    if (ReportCreationRunnerApi.this.reporterId == null) {
                        ReportCreationRunnerApi.this.reporterId = awzelEntry.getEntryReporter().getCompany().getInstituteId();
                    } else if (!ReportCreationRunnerApi.this.reporterId.equals(awzelEntry.getEntryReporter().getCompany().getInstituteId())) {
                        ReportCreationRunnerApi.this.reporterId = null;
                        this.multipleReporterIds = true;
                    }
                }
            }
            catch (IOException | GeneralSecurityException e) {
                this.exception = e;
            }
        }

        public void endReport() {
            try {
                this.handler.endReport();
                this.tempFileOutputStream.close();
            }
            catch (IOException io) {
                this.exception = io;
            }
        }
    }
}

