/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.api;

import de.businesslogics.banking.awzel.api.AwzelApi;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AwzelDikaEntry;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public abstract class PaymentReportCollector<PaymentType> {
    protected int numberOfImportedPayments;

    public final boolean checkPayment(PaymentType payment) {
        String ownCountry;
        Account account = this.getOriginatorAccount(payment);
        if (account != null && !AwzelApi.COUNTRY_CODE_GERMANY.equals(ownCountry = account.getGermanBankCode() != null && account.getGermanAccountNumber() != null ? AwzelApi.getCountryCodeFromAccountString(account.getGermanBankCode(), account.getGermanAccountNumber()) : (account.getIban() != null ? AwzelApi.getCountryCodeFromAccountString(null, account.getIban()) : "XY"))) {
            return false;
        }
        String foreignCountry = this.getRecipientISOCountry(payment);
        if (foreignCountry == null || AwzelApi.COUNTRY_CODE_GERMANY.equals(foreignCountry)) {
            return false;
        }
        if (this.getAmount(payment) == null) {
            return false;
        }
        BigDecimal amountInEur = AwzelApi.getAmountInEuro(this.getAmount(payment), this.getCurrency(payment));
        return amountInEur == null || amountInEur.compareTo(AwzelApi.MIN_REPORT_AMOUNT) > 0;
    }

    public final AwzelEntry storePayment(PaymentType payment) {
        if (payment == null) {
            throw new IllegalArgumentException("Unable to store null payment!");
        }
        Date executionDate = this.getExecutionDate(payment);
        return this.storePayment(payment, AwzelApi.DATA_FILE_MONTH_FORMAT.format(this.getAWVDate(executionDate)));
    }

    private Date getAWVDate(Date executionDate) {
        Date today = Calendar.getInstance().getTime();
        if (executionDate == null) {
            return today;
        }
        if (executionDate.before(today)) {
            return today;
        }
        return executionDate;
    }

    public AwzelEntry storePayment(PaymentType payment, String monthString) {
        if (payment == null) {
            throw new IllegalArgumentException("Unable to store null payment!");
        }
        AwzelEntry result = new AwzelEntry();
        result.setReportMonth(monthString);
        result.setType(AwzelEntry.EntryType.DIKA);
        result.setEndToEndId(this.getReference(payment));
        result.setTenant(this.getTenant(payment));
        AwzelDikaEntry dikaEntry = new AwzelDikaEntry();
        result.setDikaEntry(dikaEntry);
        String referenceAmount = String.format("%1$s %2$.2f", this.getCurrency(payment).toString(), this.getAmount(payment).doubleValue());
        if (AwzelApi.EUR.equals(this.getCurrency(payment))) {
            dikaEntry.setAmountInEur(this.getAmount(payment).doubleValue());
        } else {
            BigDecimal amountInEurDecimal = AwzelApi.getAmountInEuro(this.getAmount(payment), this.getCurrency(payment));
            if (amountInEurDecimal != null) {
                dikaEntry.setAmountInEur(amountInEurDecimal.doubleValue());
            }
        }
        dikaEntry.setCountryCode(this.getRecipientISOCountry(payment));
        dikaEntry.setReferenceAmount(referenceAmount);
        dikaEntry.setPurpose(this.getPurpose(payment));
        result.setSignedPayment(this.getSignedPayment(payment));
        result.setOrigin(AwzelEntry.Origin.PAYMENT);
        result.save();
        return result;
    }

    protected abstract Account getOriginatorAccount(PaymentType var1);

    protected abstract Date getExecutionDate(PaymentType var1);

    protected abstract String getReference(PaymentType var1);

    protected abstract BigDecimal getAmount(PaymentType var1);

    protected abstract Currency getCurrency(PaymentType var1);

    protected abstract String getRecipientISOCountry(PaymentType var1);

    protected abstract String getPurpose(PaymentType var1);

    protected abstract Tenant getTenant(PaymentType var1);

    protected abstract SignedPayment getSignedPayment(PaymentType var1);
}

