/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public final class CountryProvider {
    private final Locale locale;
    private Map<String, String> countries;

    public CountryProvider(Locale locale) {
        this.locale = locale;
    }

    public List<String> getCountryLabels() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.getCountries().keySet()) {
            result.add(this.getCountryLabel(key));
        }
        Collections.sort(result);
        return new ArrayList<String>(result);
    }

    public String getCountryLabel(String countryCode) {
        StringBuilder result = new StringBuilder();
        if (countryCode != null) {
            result.append(countryCode).append(" - ");
            String countryName = this.getCountries().get(countryCode);
            if (countryName != null) {
                if (countryName.length() > 45) {
                    result.append(countryName.substring(0, 45)).append("\u2026");
                } else {
                    result.append(countryName);
                }
            }
        }
        return result.toString();
    }

    public String getISOCountryCode(String countryLabel) {
        if (countryLabel != null) {
            for (String key : this.getCountries().keySet()) {
                if (!this.getCountryLabel(key).equals(countryLabel)) continue;
                return key;
            }
        }
        return null;
    }

    public String getCountryNameByISOCode(String countryISOCode) {
        if (countryISOCode == null) {
            return null;
        }
        return this.getCountries().get(countryISOCode);
    }

    public String getCountryName(String countryLabel) {
        if (countryLabel != null) {
            for (String key : this.getCountries().keySet()) {
                if (!this.getCountryLabel(key).equals(countryLabel)) continue;
                return this.getCountries().get(key);
            }
        }
        return null;
    }

    private Map<String, String> getCountries() {
        if (this.countries == null) {
            this.countries = new HashMap<String, String>();
            ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.banking.awzel.api.countries", this.locale);
            for (String bundleKey : bundle.keySet()) {
                this.countries.put(bundleKey, bundle.getString(bundleKey));
            }
        }
        return this.countries;
    }
}

