/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel.api;

import de.businesslogics.banking.database.vo.AwzelDikaEntry;
import de.businesslogics.banking.database.vo.AwzelDirInvEntry;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.AwzelTransitEntry;
import de.businesslogics.banking.database.vo.PaymentExchangeRate;
import de.businesslogics.util.Currency;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;

public final class AwzelApi {
    public static final Pattern ISIN_PATTERN = Pattern.compile("[A-Z]{2}[0-9A-Z]{10}");
    public static final Pattern PHONE_PATTERN = Pattern.compile("(\\+?[\\d ]+)?(\\([\\d ]+\\))?([\\d ]+/)?[\\d \\-]+");
    public static final Pattern EXTRANET_ID_PATTERN = Pattern.compile("(E|e)(X|x)(N|n)[A-Za-z0-9]{5}");
    public static final Pattern SIMPLE_MAIL_PATTERN = Pattern.compile("([\\S && [^@\\.]]{1})([\\S && [^@]]*)@([\\S && [^@]]*)\\.([\\S* && [^@\\.]]{2,4})");
    public static final String COUNTRY_CODE_GERMANY = Locale.GERMANY.getCountry();
    public static final String COUNTRY_CODE_UNKNOWN = "XY";
    public static final BigDecimal MIN_REPORT_AMOUNT = BigDecimal.valueOf(50000L);
    public static final DateFormat DATA_FILE_MONTH_FORMAT = new SimpleDateFormat("yyyyMM");
    public static final Currency EUR = Currency.getInstance("EUR");

    public static boolean isEntryValid(AwzelEntry entry) {
        if (entry == null) {
            return false;
        }
        if (entry.getEntryReporter() == null || entry.getEntryReporter().getCompany() == null || entry.getEntryReporter().getCompany().getInstituteId() == null || entry.getEntryReporter().getCompany().getName() == null || entry.getEntryReporter().getSurname() == null || entry.getEntryReporter().getPhone() == null || entry.getEntryReporter().getEmail() == null) {
            return false;
        }
        if (entry.getServiceCode() == null || entry.getServiceCode().length() != 3) {
            return false;
        }
        AwzelEntry.EntryType entryType = entry.getType();
        if (entryType == AwzelEntry.EntryType.DIKA) {
            if (entry.getDikaEntries() == null || entry.getDikaEntries().size() != 1) {
                return false;
            }
            AwzelDikaEntry dikaEntry = entry.getDikaEntry();
            if (entry.getCategory() == null || entry.getCategory() < 1 || entry.getCategory() > 4) {
                return false;
            }
            if (dikaEntry.getPurpose() == null || dikaEntry.getPurpose().length() == 0) {
                return false;
            }
            return dikaEntry.getAmountInEur() != null && dikaEntry.getCountryCode() != null;
        }
        if (entryType == AwzelEntry.EntryType.TRANSIT) {
            if (entry.getTransitEntries() == null || entry.getTransitEntries().size() == 0) {
                return false;
            }
            if (entry.getCategory() == null || entry.getCategory() < 5 || entry.getCategory() > 6) {
                return false;
            }
            for (AwzelTransitEntry transitEntry : entry.getTransitEntries()) {
                if (AwzelApi.isTransitEntryValid(transitEntry)) continue;
                return false;
            }
            return true;
        }
        if (entryType == AwzelEntry.EntryType.DIRINV) {
            if (entry.getDirInvEntries() == null || entry.getDirInvEntries().size() == 0) {
                return false;
            }
            if (entry.getCategory() == null || entry.getCategory() < 3 || entry.getCategory() > 4) {
                return false;
            }
            for (AwzelDirInvEntry dirInvEntry : entry.getDirInvEntries()) {
                if (AwzelApi.isDirInvEntryValid(dirInvEntry)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isTransitEntryValid(AwzelTransitEntry transitEntry) {
        if (transitEntry == null) {
            return false;
        }
        if (transitEntry.getWareCode() == null) {
            return false;
        }
        return transitEntry.getAmountInEur() != null && transitEntry.getCountryCode() != null;
    }

    public static boolean isDirInvEntryValid(AwzelDirInvEntry dirInvEntry) {
        if (dirInvEntry == null) {
            return false;
        }
        if (dirInvEntry.getIsin() == null || dirInvEntry.getLabel() == null || dirInvEntry.getStockNumber() == null || dirInvEntry.getStockNumber() == 0) {
            return false;
        }
        return dirInvEntry.getAmountInEur() != null && dirInvEntry.getCountryCode() != null;
    }

    public static boolean isEntryCancelable(AwzelEntry entry) {
        return entry != null && entry.isExported() != false && entry.isCancellation() == false;
    }

    public static AwzelEntry createCancellationFromAwzelEntry(AwzelEntry entry) {
        AwzelEntry newEntry = new AwzelEntry();
        newEntry.setType(entry.getType());
        newEntry.setReportMonth(entry.getReportMonth());
        newEntry.setEntryReporter(entry.getEntryReporter());
        newEntry.setCategory(entry.getCategory());
        newEntry.setServiceCode(entry.getServiceCode());
        newEntry.setReportReference(entry.getReportReference());
        newEntry.setComment(entry.getComment());
        newEntry.setTenant(entry.getTenant());
        newEntry.setCancellation(true);
        newEntry.setExported(false);
        if (entry.getType() == AwzelEntry.EntryType.DIKA) {
            AwzelDikaEntry oldDikaEntry = entry.getDikaEntry();
            if (oldDikaEntry != null) {
                AwzelDikaEntry newDikaEntry = new AwzelDikaEntry();
                newDikaEntry.setAbstractEntry(newEntry);
                newDikaEntry.setPurpose(oldDikaEntry.getPurpose());
                newDikaEntry.setAmountInEur(oldDikaEntry.getAmountInEur());
                newDikaEntry.setCountryCode(oldDikaEntry.getCountryCode());
                newDikaEntry.setReferenceAmount(oldDikaEntry.getReferenceAmount());
                newDikaEntry.setSettlementKey(oldDikaEntry.getSettlementKey());
                newEntry.setDikaEntry(newDikaEntry);
            }
        } else if (entry.getType() == AwzelEntry.EntryType.TRANSIT) {
            ArrayList<AwzelTransitEntry> transitEntries = new ArrayList<AwzelTransitEntry>();
            for (AwzelTransitEntry transitEntry : entry.getTransitEntries()) {
                AwzelTransitEntry currentTransitEntry = new AwzelTransitEntry();
                currentTransitEntry.setAbstractEntry(newEntry);
                currentTransitEntry.setWareCode(transitEntry.getWareCode());
                currentTransitEntry.setWareName(transitEntry.getWareName());
                currentTransitEntry.setAmountInEur(transitEntry.getAmountInEur());
                currentTransitEntry.setCountryCode(transitEntry.getCountryCode());
                currentTransitEntry.setReferenceAmount(transitEntry.getReferenceAmount());
                currentTransitEntry.setSettlementKey(transitEntry.getSettlementKey());
                transitEntries.add(currentTransitEntry);
            }
            newEntry.setTransitEntries(transitEntries);
        } else if (entry.getType() == AwzelEntry.EntryType.DIRINV) {
            ArrayList<AwzelDirInvEntry> dirInvEntries = new ArrayList<AwzelDirInvEntry>();
            for (AwzelDirInvEntry dirInvEntry : entry.getDirInvEntries()) {
                AwzelDirInvEntry currentDirInvEntry = new AwzelDirInvEntry();
                currentDirInvEntry.setAbstractEntry(newEntry);
                currentDirInvEntry.setIsin(dirInvEntry.getIsin());
                currentDirInvEntry.setLabel(dirInvEntry.getLabel());
                currentDirInvEntry.setStockNumber(dirInvEntry.getStockNumber());
                currentDirInvEntry.setAmountInEur(dirInvEntry.getAmountInEur());
                currentDirInvEntry.setCountryCode(dirInvEntry.getCountryCode());
                currentDirInvEntry.setReferenceAmount(dirInvEntry.getReferenceAmount());
                currentDirInvEntry.setSettlementKey(dirInvEntry.getSettlementKey());
                dirInvEntries.add(currentDirInvEntry);
            }
            newEntry.setDirInvEntries(dirInvEntries);
        }
        newEntry.save();
        return newEntry;
    }

    public static AwzelEntry createNewEntryForConversion(AwzelEntry entry, AwzelEntry.EntryType newEntryType) {
        if (newEntryType == null || newEntryType == entry.getType()) {
            return entry;
        }
        AwzelEntry newEntry = new AwzelEntry();
        newEntry.setType(newEntryType);
        newEntry.setReportMonth(entry.getReportMonth());
        newEntry.setEntryReporter(entry.getEntryReporter());
        newEntry.setCategory(entry.getCategory());
        newEntry.setServiceCode(entry.getServiceCode());
        newEntry.setReportReference(entry.getReportReference());
        newEntry.setComment(entry.getComment());
        newEntry.setTenant(entry.getTenant());
        if (newEntry.getType() == AwzelEntry.EntryType.DIKA) {
            AwzelApi.loadDikaEntryData(entry, newEntry);
        } else if (newEntry.getType() == AwzelEntry.EntryType.DIRINV) {
            AwzelApi.loadDirInvEntryData(entry, newEntry);
        } else if (newEntry.getType() == AwzelEntry.EntryType.TRANSIT) {
            AwzelApi.loadTransitEntryData(entry, newEntry);
        } else {
            return null;
        }
        return newEntry;
    }

    private static void loadTransitEntryData(AwzelEntry oldEntry, AwzelEntry newAbstractEntry) {
        if (oldEntry.getType() == AwzelEntry.EntryType.DIKA) {
            AwzelTransitEntry transitEntry = new AwzelTransitEntry();
            AwzelDikaEntry dikaEntry = oldEntry.getDikaEntry();
            transitEntry.setAmountInEur(dikaEntry.getAmountInEur());
            transitEntry.setCountryCode(dikaEntry.getCountryCode());
            transitEntry.setReferenceAmount(dikaEntry.getReferenceAmount());
            transitEntry.setSettlementKey(dikaEntry.getSettlementKey());
            newAbstractEntry.addTransitEntry(transitEntry);
        } else if (oldEntry.getType() == AwzelEntry.EntryType.DIRINV) {
            for (AwzelDirInvEntry dirInvEntry : oldEntry.getDirInvEntries()) {
                AwzelTransitEntry transitEntry = new AwzelTransitEntry();
                transitEntry.setAmountInEur(dirInvEntry.getAmountInEur());
                transitEntry.setCountryCode(dirInvEntry.getCountryCode());
                transitEntry.setReferenceAmount(dirInvEntry.getReferenceAmount());
                transitEntry.setSettlementKey(dirInvEntry.getSettlementKey());
                newAbstractEntry.addTransitEntry(transitEntry);
            }
        }
    }

    private static void loadDirInvEntryData(AwzelEntry oldEntry, AwzelEntry newAbstractEntry) {
        if (oldEntry.getType() == AwzelEntry.EntryType.DIKA) {
            AwzelDirInvEntry dirInvEntry = new AwzelDirInvEntry();
            AwzelDikaEntry dikaEntry = oldEntry.getDikaEntry();
            dirInvEntry.setAmountInEur(dikaEntry.getAmountInEur());
            dirInvEntry.setCountryCode(dikaEntry.getCountryCode());
            dirInvEntry.setReferenceAmount(dikaEntry.getReferenceAmount());
            dirInvEntry.setSettlementKey(dikaEntry.getSettlementKey());
            newAbstractEntry.addDirInvEntry(dirInvEntry);
        } else if (oldEntry.getType() == AwzelEntry.EntryType.TRANSIT) {
            for (AwzelTransitEntry transitEntry : oldEntry.getTransitEntries()) {
                AwzelDirInvEntry dirInvEntry = new AwzelDirInvEntry();
                dirInvEntry.setAmountInEur(transitEntry.getAmountInEur());
                dirInvEntry.setCountryCode(transitEntry.getCountryCode());
                dirInvEntry.setReferenceAmount(transitEntry.getReferenceAmount());
                dirInvEntry.setSettlementKey(transitEntry.getSettlementKey());
                newAbstractEntry.addDirInvEntry(dirInvEntry);
            }
        }
    }

    private static void loadDikaEntryData(AwzelEntry oldEntry, AwzelEntry newAbstractEntry) {
        AwzelDikaEntry newDikaEntry = new AwzelDikaEntry();
        Long amountInEur = null;
        String countryCode = null;
        Character settlementKey = null;
        boolean multipleCountries = false;
        boolean multipleSettlementKeys = false;
        if (oldEntry.getType() == AwzelEntry.EntryType.DIRINV) {
            for (AwzelDirInvEntry dirInvEntry : oldEntry.getDirInvEntries()) {
                if (amountInEur == null) {
                    amountInEur = dirInvEntry.getAmountInEur();
                    continue;
                }
                if (dirInvEntry.getAmountInEur() != null) {
                    amountInEur = amountInEur + dirInvEntry.getAmountInEur();
                }
                if (!multipleCountries && dirInvEntry.getCountryCode() != null) {
                    if (countryCode == null) {
                        countryCode = dirInvEntry.getCountryCode();
                    } else if (!dirInvEntry.getCountryCode().equals(countryCode)) {
                        countryCode = null;
                        multipleCountries = true;
                    }
                }
                if (multipleSettlementKeys || dirInvEntry.getSettlementKey() == null) continue;
                if (settlementKey == null) {
                    settlementKey = dirInvEntry.getSettlementKey();
                    continue;
                }
                if (dirInvEntry.getSettlementKey().equals(settlementKey)) continue;
                settlementKey = null;
                multipleSettlementKeys = true;
            }
        } else if (oldEntry.getType() == AwzelEntry.EntryType.TRANSIT) {
            for (AwzelTransitEntry transitEntry : oldEntry.getTransitEntries()) {
                if (amountInEur == null) {
                    amountInEur = transitEntry.getAmountInEur();
                    continue;
                }
                if (transitEntry.getAmountInEur() != null) {
                    amountInEur = amountInEur + transitEntry.getAmountInEur();
                }
                if (!multipleCountries && transitEntry.getCountryCode() != null) {
                    if (countryCode == null) {
                        countryCode = transitEntry.getCountryCode();
                    } else if (!transitEntry.getCountryCode().equals(countryCode)) {
                        countryCode = null;
                        multipleCountries = true;
                    }
                }
                if (multipleSettlementKeys || transitEntry.getSettlementKey() == null) continue;
                if (settlementKey == null) {
                    settlementKey = transitEntry.getSettlementKey();
                    continue;
                }
                if (transitEntry.getSettlementKey().equals(settlementKey)) continue;
                settlementKey = null;
                multipleSettlementKeys = true;
            }
        }
        if (amountInEur != null) {
            newDikaEntry.setAmountInEur(amountInEur);
        }
        newDikaEntry.setCountryCode(countryCode);
        newDikaEntry.setSettlementKey(settlementKey);
        newAbstractEntry.setDikaEntry(newDikaEntry);
    }

    public static String getCountryCodeFromAccountString(String bankCode, String accountNumber) {
        if (accountNumber == null) {
            return COUNTRY_CODE_UNKNOWN;
        }
        if (RegularExpressions.IBAN.matches(accountNumber)) {
            return accountNumber.substring(0, 2);
        }
        if (bankCode != null && RegularExpressions.BIC.matches(bankCode)) {
            return bankCode.substring(4, 6);
        }
        if (bankCode != null ? RegularExpressions.GERMAN_BANK_CODE.matches(bankCode) && RegularExpressions.GERMAN_ACCOUNT_NUMBER.matches(accountNumber) : RegularExpressions.GERMAN_ACCOUNT_NUMBER.matches(accountNumber)) {
            return COUNTRY_CODE_GERMANY;
        }
        return COUNTRY_CODE_UNKNOWN;
    }

    public static BigDecimal getAmountInEuro(BigDecimal amount, Currency currency) {
        if (currency == null || EUR.equals(currency)) {
            return amount;
        }
        PaymentExchangeRate exchangeRate = PaymentExchangeRate.findExchangeRate(currency.getCurrencyCode());
        if (exchangeRate == null) {
            return null;
        }
        return exchangeRate.convertToEURO(amount);
    }

    private AwzelApi() {
    }
}

