/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.awzel;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.PreferenceBundleHandler;
import de.businesslogics.banking.awzel.data.ExportFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public enum PreferenceConstants implements DatabasePreferenceConstant
{
    COLLECT_FROM_STATEMENTS("CollectFromStatements", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, true),
    COLLECT_FROM_PAYMENTS("CollectFromPayments", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, true),
    REMEMBER_ON_STARTUP("RememberOnStartup", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    REPORT_WITHOUT_CONVERSION("ConvertWithoutConversion", "prompt", DatabasePreferenceConstant.DataType.ENUM_RADIO, false, true, true),
    INITIALIZED_SETTINGS("InitializedSettings", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    EXPORT_FORMAT("ExportFormat", ExportFormat.XML.name(), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false);

    private static final PreferenceBundleHandler bundleHandler;
    private final String id;
    private String defaultValue;
    private final DatabasePreferenceConstant.DataType type;
    private final boolean userSpecific;
    private final boolean onlyAdmin;
    private final boolean onlyAdminOrTenantAdmin;

    private PreferenceConstants(String id, String defaultValue, DatabasePreferenceConstant.DataType type, boolean userSpecific, boolean onlyAdmin, boolean onlyAdminOrTenantAdmin) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.type = type;
        this.userSpecific = userSpecific;
        this.onlyAdmin = onlyAdmin;
        this.onlyAdminOrTenantAdmin = onlyAdminOrTenantAdmin;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public boolean isUserSpecific() {
        return this.userSpecific;
    }

    @Override
    public DatabasePreferenceConstant.DataType getType() {
        return this.type;
    }

    @Override
    public boolean isOnlyConfigurableByAdmin() {
        return this.onlyAdmin;
    }

    @Override
    public boolean isOnlyConfigurableByAdminOrTenantAdmin() {
        return this.onlyAdminOrTenantAdmin;
    }

    @Override
    public String getLabel(Locale locale) {
        return bundleHandler.getString(this.id, locale);
    }

    @Override
    public String[][] getSelectableOptions(Locale locale) {
        if (this == REPORT_WITHOUT_CONVERSION) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.no", new Object[0]), "never"}, {BankingApiMessages.getString(locale, "GeneralMessages.alwaysAsk", new Object[0]), "prompt"}, {BankingApiMessages.getString(locale, "GeneralMessages.yes", new Object[0]), "always"}};
        }
        if (this == EXPORT_FORMAT) {
            String[][] exportFormatLabelsAndValues = new String[ExportFormat.values().length][2];
            for (int i = 0; i < ExportFormat.values().length; ++i) {
                exportFormatLabelsAndValues[i] = new String[]{bundleHandler.getString(EXPORT_FORMAT.getId() + ".format." + ExportFormat.values()[i].name().toLowerCase(), locale), ExportFormat.values()[i].name()};
            }
            return exportFormatLabelsAndValues;
        }
        return null;
    }

    static {
        bundleHandler = new PreferenceBundleHandler(){

            @Override
            protected ResourceBundle loadBundle(Locale locale) {
                return ResourceBundle.getBundle("de.businesslogics.banking.awzel.PreferenceConstants", locale);
            }
        };
    }
}

