/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.sepa;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum SepaSequenceType {
    OOFF,
    FRST,
    RCUR,
    FNAL;

    private static final Map<String, ResourceBundle> BUNDLES;

    public static SepaSequenceType getByName(String name) {
        for (SepaSequenceType sequenceType : SepaSequenceType.values()) {
            if (!sequenceType.name().equals(name)) continue;
            return sequenceType;
        }
        return null;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        ResourceBundle bundle = BUNDLES.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.banking.api.sepa.SepaSequenceType", locale);
            BUNDLES.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("SepaSequenceType." + this.name().toLowerCase());
        }
        catch (MissingResourceException e) {
            return "!SepaSequenceType." + this.name().toLowerCase() + "!";
        }
    }

    static {
        BUNDLES = new HashMap<String, ResourceBundle>();
    }
}

