/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.sepa;

import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.util.StringUtils;

public class SepaSchemeHandler {
    private static final String[] outdatedSchemes = new String[]{"pain.001.003.03", "pain.001.002.03", "pain.001.002.02", "pain.001.001.02", "pain.008.003.02", "pain.008.002.02", "pain.008.002.01"};

    public static GeneralSEPAWriter.Version getSepaVersion(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        PaymentTransferType.Scheme scheme = SepaSchemeHandler.getScheme(bank, pmtType);
        if (scheme == null) {
            scheme = SepaSchemeHandler.getDefaultScheme(bank, pmtType);
        }
        return SepaSchemeHandler.getVersionFromScheme(scheme);
    }

    private static GeneralSEPAWriter.Version getVersionFromScheme(PaymentTransferType.Scheme scheme) {
        if (scheme != null) {
            if (PaymentTransferType.Scheme.pain00100109.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.Iso00100109;
            }
            if (PaymentTransferType.Scheme.pain00800108.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.Iso00800108;
            }
            if (PaymentTransferType.Scheme.pain00100108.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.Iso00100108;
            }
            if (PaymentTransferType.Scheme.pain00100103.equals((Object)scheme) || PaymentTransferType.Scheme.pain00800102.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.V25Iso;
            }
            if (PaymentTransferType.Scheme.pain00100102.equals((Object)scheme) || PaymentTransferType.Scheme.pain00800101.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.V24Iso;
            }
            if (PaymentTransferType.Scheme.pain00100103dk.equals((Object)scheme) || PaymentTransferType.Scheme.pain00800102dk.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.V30;
            }
            if (PaymentTransferType.Scheme.pain00100303dk.equals((Object)scheme) || PaymentTransferType.Scheme.pain00800302dk.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.V27;
            }
            if (PaymentTransferType.Scheme.pain00100203dk.equals((Object)scheme) || PaymentTransferType.Scheme.pain00800202dk.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.V25;
            }
            if (PaymentTransferType.Scheme.pain00100202dk.equals((Object)scheme) || PaymentTransferType.Scheme.pain00800201dk.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.V24;
            }
            if (PaymentTransferType.Scheme.pain00100103ch.equals((Object)scheme) || PaymentTransferType.Scheme.pain00800102ch.equals((Object)scheme)) {
                return GeneralSEPAWriter.Version.V30Ch;
            }
            if (PaymentTransferType.Scheme.NONE.equals((Object)scheme)) {
                return null;
            }
        }
        return null;
    }

    public static PaymentTransferType.Scheme getScheme(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        PaymentTransferType pmtTransferType = PaymentTransferType.findByBankAndPmtType(bank, pmtType);
        if (pmtTransferType != null) {
            return pmtTransferType.getScheme();
        }
        return null;
    }

    private static PaymentTransferType.Scheme getDefaultScheme(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        String countryCode = "DE";
        if (bank != null) {
            countryCode = bank.getCountryCode();
        }
        return SepaSchemeHandler.getDefaultScheme(pmtType, countryCode);
    }

    public static PaymentTransferType.Scheme getDefaultScheme(PaymentTransferType.PmtType pmtType, String countryCode) {
        if (PaymentTransferType.FormatType.pain008.equals((Object)pmtType.getFormatType())) {
            if ("CH".equals(countryCode) || "FR".equals(countryCode)) {
                return PaymentTransferType.Scheme.pain00800102;
            }
            return PaymentTransferType.Scheme.pain00800102dk;
        }
        switch (pmtType) {
            case SEPA_INSTANT_TRANSFER: 
            case SEPA_FOREIGN_CURRENCY_TRANSFER: 
            case AUSTRIAN_POSTBAR_PAYMENT: 
            case AUSTRIAN_TAX_PAYMENT: 
            case AUSTRIAN_URGENT_TAX_PAYMENT: {
                return PaymentTransferType.Scheme.pain00100103;
            }
            case SEPA_FOREIGN_TRANSFER: 
            case SEPA_URGENT_FOREIGN_TRANSFER: 
            case SEPA_FOREIGN_CHEQUE: {
                if ("DE".equals(countryCode)) {
                    return PaymentTransferType.Scheme.pain00100109;
                }
                if ("CH".equals(countryCode)) {
                    return PaymentTransferType.Scheme.pain00100103ch;
                }
                return PaymentTransferType.Scheme.pain00100103;
            }
            case SWISS_DOMESTIC_TRANSFER_3: 
            case SWISS_ESR_TRANSFER: 
            case SWISS_ES1_TRANSFER: 
            case SWISS_ES2_TRANSFER: 
            case SWISS_SEPA_TRANSFER: {
                return PaymentTransferType.Scheme.pain00100103ch;
            }
        }
        if (PaymentTransferType.FormatType.pain001.equals((Object)pmtType.getFormatType())) {
            if ("CH".equals(countryCode)) {
                return PaymentTransferType.Scheme.pain00100103ch;
            }
            if ("FR".equals(countryCode) || "AT".equals(countryCode)) {
                return PaymentTransferType.Scheme.pain00100103;
            }
            return PaymentTransferType.Scheme.pain00100103dk;
        }
        return null;
    }

    @Deprecated
    public static GeneralSEPAWriter.Version getDefaultVersion(boolean isCredit, BankSettings bank) {
        if (bank == null) {
            return GeneralSEPAWriter.Version.V30;
        }
        if (isCredit) {
            if (bank.isSwissBank()) {
                return GeneralSEPAWriter.Version.V30Ch;
            }
            if (bank.isFrenchBank()) {
                return GeneralSEPAWriter.Version.V25Iso;
            }
            return GeneralSEPAWriter.Version.V30;
        }
        if (bank.isSwissBank() || bank.isFrenchBank()) {
            return GeneralSEPAWriter.Version.V25Iso;
        }
        return GeneralSEPAWriter.Version.V30;
    }

    public static PaymentTransferType.Scheme[] getSchemes(PaymentTransferType.PmtType pmtType) {
        switch (pmtType) {
            case SEPA_INSTANT_TRANSFER: {
                return new PaymentTransferType.Scheme[]{PaymentTransferType.Scheme.pain00100103, PaymentTransferType.Scheme.pain00100108, PaymentTransferType.Scheme.pain00100109};
            }
            case SEPA_FOREIGN_CURRENCY_TRANSFER: 
            case AUSTRIAN_POSTBAR_PAYMENT: 
            case AUSTRIAN_TAX_PAYMENT: 
            case AUSTRIAN_URGENT_TAX_PAYMENT: 
            case SEPA_FOREIGN_TRANSFER: 
            case SEPA_URGENT_FOREIGN_TRANSFER: 
            case SEPA_FOREIGN_CHEQUE: {
                return new PaymentTransferType.Scheme[]{PaymentTransferType.Scheme.pain00100103, PaymentTransferType.Scheme.pain00100103ch, PaymentTransferType.Scheme.pain00100109};
            }
            case SWISS_DOMESTIC_TRANSFER_3: 
            case SWISS_ESR_TRANSFER: 
            case SWISS_ES1_TRANSFER: 
            case SWISS_ES2_TRANSFER: {
                return new PaymentTransferType.Scheme[]{PaymentTransferType.Scheme.pain00100103ch, PaymentTransferType.Scheme.pain00100103, PaymentTransferType.Scheme.pain00100109};
            }
            case SEPA_TRANSFER: 
            case SEPA_CONFIDENTAL_TRANSFER: 
            case SEPA_URGENT_TRANSFER: 
            case SEPA_URGENT_CONFIDENTAL_TRANSFER: 
            case SEPA_NON_SEPA_COUNTRY_TRANSFER: {
                return new PaymentTransferType.Scheme[]{PaymentTransferType.Scheme.pain00100103ch, PaymentTransferType.Scheme.pain00100102, PaymentTransferType.Scheme.pain00100103, PaymentTransferType.Scheme.pain00100103dk, PaymentTransferType.Scheme.pain00100109};
            }
            case SEPA_CORE_DIRECT_DEBIT: 
            case SEPA_B2B_DIRECT_DEBIT: {
                return new PaymentTransferType.Scheme[]{PaymentTransferType.Scheme.pain00800101, PaymentTransferType.Scheme.pain00800102, PaymentTransferType.Scheme.pain00800102dk, PaymentTransferType.Scheme.pain00800108};
            }
        }
        return null;
    }

    public static String[] getSchemeNames(PaymentTransferType.Scheme[] schemes) {
        if (schemes != null) {
            String[] schemeNames = new String[schemes.length];
            for (int i = 0; i < schemes.length; ++i) {
                schemeNames[i] = SepaSchemeHandler.getSchemeName(schemes[i]);
            }
            return schemeNames;
        }
        return null;
    }

    public static String getSchemeName(PaymentTransferType.Scheme scheme) {
        switch (scheme) {
            case pain00100109: {
                return "pain.001.001.09 (ISO, DK V 3.7 - V 3.9)";
            }
            case pain00100108: {
                return "pain.001.001.08 (ISO)";
            }
            case pain00100103: {
                return "pain.001.001.03 (ISO)";
            }
            case pain00100102: {
                return "pain.001.001.02 (ISO)";
            }
            case pain00100103dk: {
                return "pain.001.001.03 (DK V 3.0 - V 3.6)";
            }
            case pain00100303dk: {
                return "pain.001.003.03 (DK V 2.7 - V 2.9)";
            }
            case pain00100203dk: {
                return "pain.001.002.03 (DK V 2.5)";
            }
            case pain00100202dk: {
                return "pain.001.002.02 (DK V 2.4)";
            }
            case pain00100103ch: {
                return "pain.001.001.03.ch.02 (CH)";
            }
            case pain00800108: {
                return "pain.008.001.08 (ISO, DK V 3.7 - V 3.9)";
            }
            case pain00800102: {
                return "pain.008.001.02 (ISO)";
            }
            case pain00800101: {
                return "pain.008.001.01 (ISO)";
            }
            case pain00800102dk: {
                return "pain.008.001.02 (DK V 3.0 - V 3.6)";
            }
            case pain00800302dk: {
                return "pain.008.003.02 (DK V 2.7 - V 2.9)";
            }
            case pain00800202dk: {
                return "pain.008.002.02 (DK V 2.5)";
            }
            case pain00800201dk: {
                return "pain.008.002.01 (DK V 2.4)";
            }
            case pain00800102ch: {
                return "pain.008.001.01 (ISO)";
            }
            case NONE: {
                return "";
            }
        }
        return null;
    }

    public static boolean isOutdatedScheme(String scheme) {
        return StringUtils.isContainedInArray(scheme, outdatedSchemes);
    }
}

