/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.sepa;

import de.businesslogics.banking.api.AmountsSum;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Locale;
import org.xml.sax.SAXException;

public final class SepaDetailsPrinter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCreditToDocument(File file, BLDocument doc, boolean pageBreak, Locale locale, User user) throws PDFException, IOException, SAXException, GeneralSecurityException {
        InputStream in = null;
        try {
            in = EncryptData.getInstance().openInputStream(file);
            List<SEPALogicalFile> logicalFiles = GeneralSEPAExtractor.getLogicalFilesFromCCT(in);
            SepaDetailsPrinter.printLogicalFilesWithCreditTransfers(logicalFiles, doc, pageBreak, locale, user);
        }
        finally {
            Util.closeStream(in);
        }
    }

    public static void printLogicalFilesWithCreditTransfers(List<SEPALogicalFile> logicalFiles, BLDocument doc, boolean pageBreak, Locale locale, User user) throws PDFException {
        if (logicalFiles != null && logicalFiles.size() > 0) {
            doc.setPageSize(BLDocument.PageLayout.A4_LANDSCAPE);
            doc.newPage();
            boolean hideSalariesCompletely = Util.hideSalariesCompletely(user);
            boolean printSalaryAmounts = Util.printSalaries(user);
            BLFont f = BLFont.FONT_NORMAL;
            boolean first = true;
            for (SEPALogicalFile logicalFile : logicalFiles) {
                String infoCellText;
                if (first) {
                    first = false;
                } else if (pageBreak) {
                    doc.newPage();
                }
                AmountsSum amountsSum = new AmountsSum();
                if (logicalFile.getTransactions() == null || logicalFile.getTransactions().size() == 0) continue;
                SEPAPaymentData firstTransaction = logicalFile.getTransactions().get(0);
                String paymentCategory = StringUtils.checkNullAndTrim(firstTransaction.getPaymentCategory());
                BLTable<?> t = PDFCreator.getInstance().createTable(7);
                t.setWidth(96.0f);
                t.setPadding(3.0f);
                t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
                if (paymentCategory.length() > 0) {
                    textKey = firstTransaction.hasExecutionTime() ? "SepaDetailsPrinter.tableHeaderTime.withPaymentCategory" : "SepaDetailsPrinter.tableHeader.withPaymentCategory";
                    infoCellText = BankingApiMessages.getString(locale, textKey, SepaDetailsPrinter.checkForNull(logicalFile.getPmtInfId()), firstTransaction.getOriginator(), SepaDetailsPrinter.getAccountString(firstTransaction.getOriginatorBic(), firstTransaction.getOriginatorIban()), firstTransaction.getExecutionDate(), paymentCategory);
                } else {
                    textKey = firstTransaction.hasExecutionTime() ? "SepaDetailsPrinter.tableHeaderTime" : "SepaDetailsPrinter.tableHeader";
                    infoCellText = BankingApiMessages.getString(locale, textKey, SepaDetailsPrinter.checkForNull(logicalFile.getPmtInfId()), firstTransaction.getOriginator(), SepaDetailsPrinter.getAccountString(firstTransaction.getOriginatorBic(), firstTransaction.getOriginatorIban()), firstTransaction.getExecutionDate());
                }
                t.addCell(infoCellText, f, 7, Alignment.ALIGN_LEFT, null, null, BLBorder.NO_BORDER);
                t.setPadding(6.0f);
                t.addCell("", f, 7, null, null, null, BLBorder.NO_BORDER);
                t.setPadding(3.0f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.ultimateOriginator", new Object[0]), f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.recipient", new Object[0]), f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.ultimateRecipient", new Object[0]), f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.account", new Object[0]), f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), f);
                t.addCell(GeneralMessages.getInstance((Locale)locale).END_TO_END_REFERENCE, f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]), f);
                t.setHeaderRows(2);
                for (SEPAPaymentData transaction : logicalFile.getTransactions()) {
                    boolean isSalary = SEPAUtil.isSalaryPayment(transaction.getPaymentCategory(), transaction.getPurposeCode());
                    if (isSalary && hideSalariesCompletely) {
                        int i;
                        for (i = 1; i <= 4; ++i) {
                            t.addCell("");
                        }
                        t.addCell(BankingApiMessages.getString(locale, "SepaDetailsPrinter.salaryPaymentHint", new Object[0]), f);
                        for (i = 6; i <= 7; ++i) {
                            t.addCell("");
                        }
                        continue;
                    }
                    t.addCell(SepaDetailsPrinter.checkForNull(transaction.getUltimateOriginator()), f);
                    t.addCell(transaction.getRecipient(), f);
                    t.addCell(SepaDetailsPrinter.checkForNull(transaction.getUltimateRecipient()), f);
                    t.addCell(SepaDetailsPrinter.getAccountString(transaction.getRecipientBic(), transaction.getRecipientIban()), f);
                    if (transaction.hasStructuredPurpose()) {
                        String purposeReference = SepaDetailsPrinter.checkForNull(transaction.getPurposeReference());
                        String purpose = SepaDetailsPrinter.checkForNull(transaction.getPurpose());
                        if (purposeReference.length() > 0) {
                            t.addCell((String)(purpose.length() > 0 ? purposeReference + "\n" + purpose : purposeReference), f);
                        } else {
                            t.addCell(purpose, f);
                        }
                    } else {
                        t.addCell(SepaDetailsPrinter.checkForNull(transaction.getPurpose()), f);
                    }
                    t.addCell(SepaDetailsPrinter.checkForNull(transaction.getEndToEndId()), f);
                    t.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
                    if (!printSalaryAmounts && isSalary) {
                        t.addCell("");
                    } else {
                        t.addCell(PaymentUtils.formatAmount(transaction.getAmount(), transaction.getCurrency(), locale), f);
                    }
                    t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
                    amountsSum.addAmount(transaction.getAmount(), transaction.getCurrency());
                }
                t = amountsSum.addSumCells(t, 7, locale);
                doc.addTable(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContainerToDocument(boolean isCredit, File file, BLDocument doc, boolean pageBreak, Locale locale, User user) throws PDFException, IOException, SAXException, GeneralSecurityException {
        InputStream in = null;
        try {
            in = EncryptData.getInstance().openInputStream(file);
            List<SEPALogicalFile> logicalFiles = GeneralSEPAExtractor.getLogicalFilesFromContainer(in);
            if (isCredit) {
                SepaDetailsPrinter.printLogicalFilesWithCreditTransfers(logicalFiles, doc, pageBreak, locale, user);
            } else {
                SepaDetailsPrinter.printLogicalFilesWithDirectDebits(logicalFiles, doc, pageBreak, locale, user);
            }
        }
        finally {
            Util.closeStream(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebitToDocument(File file, BLDocument doc, boolean pageBreak, Locale locale, User user) throws PDFException, IOException, SAXException, GeneralSecurityException {
        InputStream in = null;
        try {
            in = EncryptData.getInstance().openInputStream(file);
            List<SEPALogicalFile> logicalFiles = GeneralSEPAExtractor.getLogicalFilesFromDebit(in);
            SepaDetailsPrinter.printLogicalFilesWithDirectDebits(logicalFiles, doc, pageBreak, locale, user);
        }
        finally {
            Util.closeStream(in);
        }
    }

    public static void printLogicalFilesWithDirectDebits(List<SEPALogicalFile> logicalFiles, BLDocument doc, boolean pageBreak, Locale locale, User user) throws PDFException {
        if (logicalFiles != null && logicalFiles.size() > 0) {
            doc.setPageSize(BLDocument.PageLayout.A4_LANDSCAPE);
            doc.newPage();
            BLFont f = BLFont.FONT_NORMAL;
            boolean printSalaries = Util.printSalaries(user);
            boolean first = true;
            for (SEPALogicalFile logicalFile : logicalFiles) {
                if (first) {
                    first = false;
                } else if (pageBreak) {
                    doc.newPage();
                }
                AmountsSum amountsSum = new AmountsSum();
                if (logicalFile.getTransactions() == null || logicalFile.getTransactions().size() == 0) continue;
                SEPAPaymentData firstTransaction = logicalFile.getTransactions().get(0);
                BLTable<?> t = PDFCreator.getInstance().createTable(7);
                t.setWidth(96.0f);
                t.setPadding(3.0f);
                t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
                String infoCellText = firstTransaction.getPaymentCategory() != null && firstTransaction.getPaymentCategory().trim().length() > 0 ? BankingApiMessages.getString(locale, "SepaDetailsPrinter.tableHeaderDebit.withPaymentCategory", SepaDetailsPrinter.checkForNull(logicalFile.getPmtInfId()), firstTransaction.getOriginator(), SepaDetailsPrinter.getAccountString(firstTransaction.getOriginatorBic(), firstTransaction.getOriginatorIban()), firstTransaction.getExecutionDate(), firstTransaction.getPaymentCategory()) : BankingApiMessages.getString(locale, "SepaDetailsPrinter.tableHeaderDebit", SepaDetailsPrinter.checkForNull(logicalFile.getPmtInfId()), firstTransaction.getOriginator(), SepaDetailsPrinter.getAccountString(firstTransaction.getOriginatorBic(), firstTransaction.getOriginatorIban()), firstTransaction.getExecutionDate());
                t.addCell(infoCellText, f, 7, Alignment.ALIGN_LEFT, null, null, BLBorder.NO_BORDER);
                t.setPadding(6.0f);
                t.addCell("", f, 7, null, null, null, BLBorder.NO_BORDER);
                t.setPadding(3.0f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.ultimatePayee", new Object[0]), f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.payer", new Object[0]), f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.ultimatePayer", new Object[0]), f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.account", new Object[0]), f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), f);
                t.addCell(GeneralMessages.getInstance((Locale)locale).END_TO_END_REFERENCE, f);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]), f);
                t.setHeaderRows(2);
                for (SEPAPaymentData transaction : logicalFile.getTransactions()) {
                    t.addCell(SepaDetailsPrinter.checkForNull(transaction.getUltimateOriginator()), f);
                    t.addCell(transaction.getRecipient(), f);
                    t.addCell(SepaDetailsPrinter.checkForNull(transaction.getUltimateRecipient()), f);
                    t.addCell(SepaDetailsPrinter.getAccountString(transaction.getRecipientBic(), transaction.getRecipientIban()), f);
                    if (transaction.hasStructuredPurpose()) {
                        String purposeReference = SepaDetailsPrinter.checkForNull(transaction.getPurposeReference());
                        String purpose = SepaDetailsPrinter.checkForNull(transaction.getPurpose());
                        if (purposeReference.length() > 0) {
                            t.addCell((String)(purpose.length() > 0 ? purposeReference + "\n" + purpose : purposeReference), f);
                        } else {
                            t.addCell(purpose, f);
                        }
                    } else {
                        t.addCell(SepaDetailsPrinter.checkForNull(transaction.getPurpose()), f);
                    }
                    t.addCell(SepaDetailsPrinter.checkForNull(transaction.getEndToEndId()), f);
                    t.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
                    if (!printSalaries && SEPAUtil.isSalaryPayment(transaction.getPaymentCategory(), transaction.getPurposeCode())) {
                        t.addCell("");
                    } else {
                        t.addCell(PaymentUtils.formatAmount(transaction.getAmount(), transaction.getCurrency(), locale), f);
                    }
                    t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
                    amountsSum.addAmount(transaction.getAmount(), transaction.getCurrency());
                }
                t = amountsSum.addSumCells(t, 7, locale);
                doc.addTable(t);
            }
        }
    }

    private static String getAccountString(String bic, String iban) {
        if (iban != null) {
            if (bic != null && bic.length() >= 8 && !bic.equals("NOTPROVIDED")) {
                return bic + " / " + IbanUtil.formatIBAN(iban);
            }
            return IbanUtil.formatIBAN(iban);
        }
        return "";
    }

    private static String checkForNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private SepaDetailsPrinter() {
    }
}

