/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.sepa;

import de.businesslogics.banking.database.vo.PaymentTransferType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum SepaDebitType {
    CORE("CDD", "pain.008.001.01.sdd", PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT),
    B2B("CDB", "pain.008.001.01.sbb", PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT),
    COR1("CD1", "pain.008.001.01.sdd", PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT);

    private static final Map<String, ResourceBundle> BUNDLES;
    public static final SepaDebitType[] allowedDebitTypes;
    private final String orderType;
    private final String fileType;
    private final PaymentTransferType.PmtType pmtType;

    public static SepaDebitType getByName(String name) {
        for (SepaDebitType debitType : SepaDebitType.values()) {
            if (!debitType.name().equals(name)) continue;
            return debitType;
        }
        return null;
    }

    public static SepaDebitType getByOrderType(String orderType) {
        for (SepaDebitType debitType : SepaDebitType.values()) {
            if (!debitType.getOrderType().equals(orderType)) continue;
            return debitType;
        }
        return null;
    }

    public static SepaDebitType getByFileType(String fileType) {
        for (SepaDebitType debitType : SepaDebitType.values()) {
            if (!debitType.getFileType().equals(fileType)) continue;
            return debitType;
        }
        return null;
    }

    private SepaDebitType(String orderType, String fileType, PaymentTransferType.PmtType pmtType) {
        this.orderType = orderType;
        this.fileType = fileType;
        this.pmtType = pmtType;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this.pmtType;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        ResourceBundle bundle = BUNDLES.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.banking.api.sepa.SepaDebitType", locale);
            BUNDLES.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("SepaDebitType." + this.name().toLowerCase());
        }
        catch (MissingResourceException e) {
            return "!SepaDebitType." + this.name().toLowerCase() + "!";
        }
    }

    static {
        BUNDLES = new HashMap<String, ResourceBundle>();
        allowedDebitTypes = new SepaDebitType[]{CORE, B2B};
    }
}

