/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.sepa;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public class SEPAPaymentDataCsvExport
extends AbstractCsvExport<SEPAPaymentData> {
    private final Locale locale;
    private final boolean exportCredits;
    private final boolean displaySalaries;

    public SEPAPaymentDataCsvExport(Locale locale, boolean exportCredits, boolean displaySalaries) {
        this.locale = locale;
        this.exportCredits = exportCredits;
        this.displaySalaries = displaySalaries;
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        GeneralMessages messages = GeneralMessages.getInstance(this.locale);
        if (this.exportCredits) {
            this.addCell(writer, messages.ORIGINATOR);
            this.addCell(writer, messages.ULTIMATE_ORIGINATOR);
            this.addCell(writer, messages.ORIGINATOR_IBAN);
            this.addCell(writer, messages.ORIGINATOR_BIC);
            this.addCell(writer, messages.RECIPIENT);
            this.addCell(writer, messages.ULTIMATE_RECIPIENT);
            this.addCell(writer, messages.RECIPIENT_IBAN);
            this.addCell(writer, messages.RECIPIENT_BIC);
        } else {
            this.addCell(writer, messages.PAYEE);
            this.addCell(writer, messages.ULTIMATE_PAYEE);
            this.addCell(writer, messages.PAYEE_IBAN);
            this.addCell(writer, messages.PAYEE_BIC);
            this.addCell(writer, messages.CREDITOR_ID);
            this.addCell(writer, messages.PAYER);
            this.addCell(writer, messages.ULTIMATE_PAYER);
            this.addCell(writer, messages.PAYER_IBAN);
            this.addCell(writer, messages.PAYER_BIC);
            this.addCell(writer, messages.MANDATE_REFERENCE);
            this.addCell(writer, messages.MANDATE_SIGN_DATE);
            this.addCell(writer, messages.SEQUENCE_TYPE);
        }
        this.addCell(writer, messages.END_TO_END_REFERENCE);
        if (this.exportCredits) {
            this.addCell(writer, messages.EXECUTION_DATE);
        } else {
            this.addCell(writer, messages.EXPIRATION_DATE);
        }
        this.addCell(writer, messages.AMOUNT);
        this.addCell(writer, messages.CURRENCY);
        this.addCell(writer, messages.PURPOSE);
        this.addCell(writer, messages.PAYMENT_CATEGORY);
        this.addCell(writer, messages.PAYMENT_TYPE);
        this.addCell(writer, messages.SINGLE_BOOKING);
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, SEPAPaymentData payment) throws IOException {
        this.addCell(writer, payment.getOriginator());
        this.addCell(writer, payment.getUltimateOriginator());
        this.addCell(writer, payment.getOriginatorIban());
        this.addCell(writer, payment.getOriginatorBic());
        if (!this.exportCredits) {
            this.addCell(writer, payment.getCreditorId());
        }
        this.addCell(writer, payment.getRecipient());
        this.addCell(writer, payment.getUltimateRecipient());
        this.addCell(writer, payment.getRecipientIban());
        this.addCell(writer, payment.getRecipientBic());
        if (!this.exportCredits) {
            this.addCell(writer, payment.getMandateId());
            this.addCell(writer, this.formatDate(payment.getMandateSignDate(), this.locale));
            this.addCell(writer, payment.getSequenceType());
        }
        this.addCell(writer, payment.getEndToEndId());
        this.addCell(writer, this.formatDate(payment.getExecutionDate(), this.locale));
        String category = payment.getPaymentCategory();
        String purposeCode = payment.getPurposeCode();
        if (!this.displaySalaries && SEPAUtil.isSalaryPayment(category, purposeCode)) {
            this.addCell(writer, null);
            this.addCell(writer, null);
        } else {
            Currency currency = payment.getCurrency();
            this.addCell(writer, this.formatAmount(payment.getAmount(), currency, this.locale), true);
            this.addCell(writer, currency.getCurrencyCode());
        }
        this.addCell(writer, payment.getPurpose());
        this.addCell(writer, category);
        this.addCell(writer, purposeCode);
        this.addCell(writer, String.valueOf(payment.displayAsSingleBooking()));
        return true;
    }
}

