/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.sepa;

import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.format.sepa.SEPAAccountType;
import de.businesslogics.iban.IbanUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AdviceSteering {
    private static final Map<String, ResourceBundle> bundles = new HashMap<String, ResourceBundle>();

    public static DisplayMode getDisplayMode(boolean displayAsSingleBooking, String sepaAccountType) {
        return AdviceSteering.getDisplayMode(displayAsSingleBooking, SEPAAccountType.getSEPAAccountType(sepaAccountType));
    }

    private static DisplayMode getDisplayMode(boolean displayAsSingleBooking, SEPAAccountType sepaAccountType) {
        if (sepaAccountType == null) {
            return displayAsSingleBooking ? DisplayMode.SingleBooking : DisplayMode.BatchBooking;
        }
        if (displayAsSingleBooking) {
            switch (sepaAccountType) {
                case NOA: {
                    return DisplayMode.SingleBooking_NoAdvice;
                }
                case SIA: {
                    return DisplayMode.SingleBooking_Details;
                }
            }
            return DisplayMode.SingleBooking;
        }
        switch (sepaAccountType) {
            case NOA: {
                return DisplayMode.BatchBooking_NoAdvice;
            }
            case CND: {
                return DisplayMode.BatchBooking_NoDetails;
            }
            case CWD: {
                return DisplayMode.BatchBooking_Details;
            }
        }
        return DisplayMode.BatchBooking;
    }

    public static DisplayMode[] getDisplayModes(Filter filter) {
        ArrayList<DisplayMode> modes = new ArrayList<DisplayMode>();
        if (Filter.EXTENDED.equals((Object)filter)) {
            for (DisplayMode displayMode : DisplayMode.values()) {
                if (displayMode.getAccountType() == null) continue;
                modes.add(displayMode);
            }
        } else if (Filter.BASE.equals((Object)filter)) {
            for (DisplayMode displayMode : DisplayMode.values()) {
                if (displayMode.getAccountType() != null) continue;
                modes.add(displayMode);
            }
        } else {
            for (DisplayMode displayMode : DisplayMode.values()) {
                modes.add(displayMode);
            }
        }
        return modes.toArray(new DisplayMode[0]);
    }

    public static boolean isAdviceSteeringSupported(Account account) {
        if (account != null) {
            if (IbanUtil.isSwissOrLiechtensteinIban(account.getIban())) {
                return true;
            }
            if (account.getBank().isSwissBank()) {
                return true;
            }
        }
        return false;
    }

    public static String getDescription(String displayMode, Locale locale) {
        ResourceBundle bundle = bundles.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.banking.api.sepa.AdviceSteering", locale);
            bundles.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("AdviceSteering." + displayMode);
        }
        catch (MissingResourceException e) {
            return "!AdviceSteering." + displayMode + "!";
        }
    }

    public static enum DisplayMode {
        SingleBooking_NoAdvice(SEPAAccountType.NOA),
        SingleBooking_Details(SEPAAccountType.SIA),
        SingleBooking,
        BatchBooking_NoAdvice(false, SEPAAccountType.NOA, true),
        BatchBooking_NoDetails(false, SEPAAccountType.CND, true),
        BatchBooking_Details(false, SEPAAccountType.CWD, false),
        BatchBooking(false, null, false);

        private final boolean singleBooking;
        private final SEPAAccountType accountType;
        private final boolean isConfidental;

        private DisplayMode() {
            this(null);
        }

        private DisplayMode(SEPAAccountType accountType) {
            this(true, accountType, false);
        }

        private DisplayMode(boolean singleBooking, SEPAAccountType accountType, boolean isConfidental) {
            this.singleBooking = singleBooking;
            this.isConfidental = isConfidental;
            this.accountType = accountType;
        }

        public boolean singleBooking() {
            return this.singleBooking;
        }

        public SEPAAccountType getAccountType() {
            return this.accountType;
        }

        public boolean isConfidental() {
            return this.isConfidental;
        }
    }

    public static enum Filter {
        BASE,
        EXTENDED,
        ALL;

    }
}

