/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.mt101;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum MT101FeeType {
    SHA("SHA"),
    OUR("OUR"),
    BEN("BEN");

    private static final Map<String, ResourceBundle> bundles;
    private String key;

    public static MT101FeeType getByKey(String key) {
        for (MT101FeeType feeType : MT101FeeType.values()) {
            if (!feeType.key.equals(key)) continue;
            return feeType;
        }
        return null;
    }

    private MT101FeeType(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        ResourceBundle bundle = bundles.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.banking.api.mt101.MT101FeeType", locale);
            bundles.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("MT101FeeType." + this.key);
        }
        catch (MissingResourceException e) {
            return "!MT101FeeType." + this.key + "!";
        }
    }

    static {
        bundles = new HashMap<String, ResourceBundle>();
    }
}

