/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.mt101;

import de.businesslogics.banking.api.AmountsSum;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.format.swift.mt101.MT101Extractor;
import de.businesslogics.format.swift.mt101.MT101LogicalFile;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;

public class MT101DetailsPrinter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToDocument(File file, BLDocument doc, boolean pageBreak, Locale locale) throws Exception {
        InputStream in = null;
        try {
            in = EncryptData.getInstance().openInputStream(file);
            List<MT101LogicalFile> logicalFiles = new MT101Extractor().getLogicalFiles(in);
            if (logicalFiles != null && logicalFiles.size() > 0) {
                doc.setPageSize(BLDocument.PageLayout.A4_LANDSCAPE);
                doc.newPage();
                BLFont f = BLFont.FONT_NORMAL;
                BLTable<?> t = null;
                boolean first = true;
                for (MT101LogicalFile logicalFile : logicalFiles) {
                    List<MT101PaymentData> transactions;
                    if (first) {
                        first = false;
                    } else if (pageBreak) {
                        doc.newPage();
                    }
                    if ((transactions = logicalFile.getPayments()) == null || transactions.size() == 0) continue;
                    MT101PaymentData firstTransaction = transactions.get(0);
                    String message = BankingApiMessages.getString(locale, "SepaDetailsPrinter.tableHeader", firstTransaction.getSenderReference(), firstTransaction.getOriginatorName(), MT101DetailsPrinter.getBankConnection(firstTransaction.getReceiverBic(), firstTransaction.getOriginatorAccount()), firstTransaction.getExecutionDateAsDate());
                    int countColumns = 5;
                    t = PDFCreator.getInstance().createTable(countColumns);
                    t.setWidth(96.0f);
                    t.setPadding(3.0f);
                    t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
                    t.addCell(message, f, 7, Alignment.ALIGN_LEFT, null, null, BLBorder.NO_BORDER);
                    t.setPadding(6.0f);
                    t.addCell("", f, 7, null, null, null, BLBorder.NO_BORDER);
                    t.setPadding(3.0f);
                    t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.recipient", new Object[0]), f);
                    t.addCell(GeneralMessages.getInstance((Locale)locale).BANK_CONNECTION, f);
                    t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), f);
                    t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.referenceNumber", new Object[0]), f);
                    t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]), f);
                    t.setHeaderRows(2);
                    AmountsSum amountsSum = new AmountsSum();
                    for (MT101PaymentData transaction : logicalFile.getPayments()) {
                        t.addCell(StringUtils.getStringFromStringArray(transaction.getRecipientAddress(), "\n"), f);
                        t.addCell(MT101DetailsPrinter.getBankConnection(transaction.getRecipientBankCode(), transaction.getRecipientAccount(), transaction.getIntermediaryBankCode(), locale), f);
                        t.addCell(StringUtils.getStringFromStringArray(transaction.getPurposeArray(), "\n"), f);
                        t.addCell(transaction.getTransactionReference(), f);
                        t.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
                        t.addCell(PaymentUtils.formatAmount(transaction.getAmount(), transaction.getCurrency(), locale), f);
                        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
                        amountsSum.addAmount(transaction.getAmount(), transaction.getCurrency());
                    }
                    t = amountsSum.addSumCells(t, countColumns, locale);
                    doc.addTable(t);
                }
            }
        }
        finally {
            Util.closeStream(in);
        }
    }

    private static String getBankConnection(String bankCode, String accountNumber) {
        return MT101DetailsPrinter.getBankConnection(bankCode, accountNumber, null, null);
    }

    private static String getBankConnection(String bankCode, String accountNumber, String intermediary, Locale locale) {
        StringBuilder sb = new StringBuilder();
        if (bankCode != null && bankCode.trim().length() > 0) {
            sb.append(bankCode.trim());
            sb.append(" / ");
        }
        if (IbanUtil.checkIban(accountNumber)) {
            sb.append(IbanUtil.formatIBAN(accountNumber));
        } else {
            sb.append(accountNumber);
        }
        if (intermediary != null && intermediary.length() > 0) {
            sb.append("\n");
            sb.append(GeneralMessages.getInstance((Locale)locale).INTERMEDIARY_INSTITUTION);
            sb.append(":\n");
            sb.append(intermediary);
        }
        return sb.toString();
    }
}

