/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.dta;

import de.businesslogics.banking.api.AmountsSum;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.format.dta.DTAZVExtractor;
import de.businesslogics.format.dta.DTAZVItem;
import de.businesslogics.format.dta.DTAZVLogicalFile;
import de.businesslogics.format.dta.InvalidBankcodeException;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.io.Streams;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class DtazvDetailsPrinter
implements DTAZVExtractor.DTAZVListener {
    private final SimpleDateFormat yymmdd = new SimpleDateFormat("yyMMdd");
    private final BLFont font = BLFont.FONT_NORMAL;
    private final BLDocument doc;
    private final Locale locale;
    private final boolean pageBreak;
    private Exception caught;
    private BLTable<?> table;
    private Date executionDateFromQ8;
    private AmountsSum amountsSum;
    private int pos;
    private boolean addedTable;

    public static void printPaymentInformation(File file, BLDocument document, Locale locale, boolean pageBreak) throws PDFException, IOException, GeneralSecurityException {
        document.setPageSize(BLDocument.PageLayout.A4_LANDSCAPE);
        document.newPage();
        DtazvDetailsPrinter printer = new DtazvDetailsPrinter(document, locale, pageBreak);
        Streams.copy(EncryptData.getInstance().openInputStream(file), new DTAZVExtractor(printer));
        if (printer.caught instanceof PDFException) {
            throw (PDFException)printer.caught;
        }
        if (printer.caught instanceof IOException) {
            throw (IOException)printer.caught;
        }
        if (printer.caught instanceof GeneralSecurityException) {
            throw (GeneralSecurityException)printer.caught;
        }
        if (printer.caught != null) {
            throw new RuntimeException(printer.caught);
        }
    }

    public DtazvDetailsPrinter(BLDocument doc, Locale locale, boolean pageBreak) {
        this.doc = doc;
        this.locale = locale;
        this.pageBreak = pageBreak;
    }

    @Override
    public void startLogicalFile(DTAZVLogicalFile logicalFile) {
        if (this.caught != null) {
            return;
        }
        try {
            if (this.pageBreak && this.addedTable) {
                this.doc.newPage();
            }
            this.pos = 1;
            this.amountsSum = new AmountsSum();
            this.table = PDFCreator.getInstance().createTable(6);
            this.table.setWidth(100.0f);
            this.table.setWidths(new float[]{0.05f, 0.23f, 0.23f, 0.13f, 0.23f, 0.13f});
            this.table.setPadding(3.0f);
            this.table.setHorizontalAlignment(Alignment.ALIGN_CENTER);
            this.table.addCell(BankingApiMessages.getString(this.locale, "DtazvDetailsPrinter.tableHeader", logicalFile.getOriginatorLine(0), logicalFile.getQ4(), String.valueOf(logicalFile.getOrigBankcode())), this.font, 6, Alignment.ALIGN_LEFT, null, null, BLBorder.NO_BORDER);
            this.table.setPadding(6.0f);
            this.table.addCell("", this.font, 6, Alignment.ALIGN_LEFT, null, null, BLBorder.NO_BORDER);
            this.table.setPadding(3.0f);
            this.table.addCell(BankingApiMessages.getString(this.locale, "DtazvDetailsPrinter.pos", new Object[0]), this.font);
            this.table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.recipient", new Object[0]), this.font);
            this.table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]), this.font);
            this.table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.purpose", new Object[0]), this.font);
            this.table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.executionDate", new Object[0]), this.font);
            this.table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]), this.font);
            this.table.setHeaderRows(2);
            this.executionDateFromQ8 = this.yymmdd.parse(logicalFile.getQ8());
        }
        catch (PDFException e) {
            this.caught = e;
        }
        catch (ParseException e) {
            this.caught = e;
        }
        catch (InvalidBankcodeException e) {
            this.caught = e;
        }
    }

    @Override
    public void handleItem(DTAZVItem item) {
        String cellText;
        BigDecimal amount;
        Currency currency;
        if (this.caught != null || this.table == null) {
            return;
        }
        if ("91".equals(item.getInstructionCode4())) {
            currency = Currency.getInstance("EUR");
            amount = new BigDecimal(item.getAmount()).divide(new BigDecimal(1000));
            StringBuilder sb = new StringBuilder(PaymentUtils.formatAmount(amount, currency, this.locale));
            sb.append("\n(");
            sb.append(BankingApiMessages.getString(this.locale, "GeneralMessages.counterValuePaymentIn", new Object[0]));
            sb.append(' ');
            sb.append(item.getCurrency());
            sb.append(")");
            cellText = sb.toString();
        } else {
            currency = Currency.getInstance(item.getCurrency());
            amount = new BigDecimal(item.getAmount()).divide(new BigDecimal(1000));
            cellText = PaymentUtils.formatAmount(amount, currency, this.locale);
        }
        this.amountsSum.addAmount(amount, currency);
        try {
            this.table.addCell(String.valueOf(this.pos++), this.font, Alignment.ALIGN_CENTER, null);
            this.table.addCell(StringUtils.getStringFromStringArray(item.getBeneficiary(), "\n"), this.font, Alignment.ALIGN_LEFT, null);
            StringBuilder acc = new StringBuilder(item.getBeneficiaryBIC());
            if (item.getBeneficiaryAccount() != null && item.getBeneficiaryAccount().length() > 0) {
                if (IbanUtil.checkIban(item.getBeneficiaryAccount().substring(1))) {
                    acc.append(" / ").append(IbanUtil.formatIBAN(item.getBeneficiaryAccount().substring(1)));
                } else {
                    acc.append(item.getBeneficiaryAccount());
                }
            }
            this.table.addCell(acc.toString(), this.font, Alignment.ALIGN_LEFT, null);
            this.table.addCell(StringUtils.getStringFromStringArray(item.getPurpose(), "\n"), this.font, Alignment.ALIGN_LEFT, null);
            this.table.addCell(DateFormat.getDateInstance(2, this.locale).format(this.getExecutionDate(item.getExecutionDate())), this.font, Alignment.ALIGN_CENTER, null);
            this.table.addCell(cellText, this.font, Alignment.ALIGN_RIGHT, null);
        }
        catch (PDFException e) {
            this.caught = e;
        }
    }

    @Override
    public void endLogicalFile(DTAZVLogicalFile logicalFile) {
        if (this.caught != null || this.table == null) {
            return;
        }
        try {
            this.table = this.amountsSum.addSumCells(this.table, 6, this.locale);
            this.doc.addTable(this.table);
            this.addedTable = true;
        }
        catch (PDFException e) {
            this.caught = e;
        }
    }

    @Override
    public void handleWarning(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    @Override
    public void consumeError(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    private Date getExecutionDate(String t5) {
        if (!"000000".equals(t5)) {
            try {
                return this.yymmdd.parse(t5);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this.executionDateFromQ8;
    }
}

