/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.dta;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DTAZVPaymentCsvExport
extends AbstractCsvExport<DTAZVPayment> {
    private final Locale locale;

    public DTAZVPaymentCsvExport(Locale locale) {
        this.locale = locale;
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        GeneralMessages messages = GeneralMessages.getInstance(this.locale);
        this.addCell(writer, messages.ORIGINATOR);
        this.addCell(writer, messages.ORIGINATOR_ACC_NO);
        this.addCell(writer, messages.ORIGINATOR_BLZ);
        this.addCell(writer, messages.RECIPIENT);
        this.addCell(writer, messages.RECIPIENT_ACCOUNT_NUMBER);
        this.addCell(writer, messages.RECIPIENT_BANK_CODE);
        this.addCell(writer, messages.CREATION_DATE);
        this.addCell(writer, messages.EXECUTION_DATE);
        this.addCell(writer, messages.REFERENCE);
        this.addCell(writer, messages.AMOUNT);
        this.addCell(writer, messages.CURRENCY);
        this.addCell(writer, messages.COUNTER_VALUE_CURRENCY);
        this.addCell(writer, messages.PURPOSE);
        this.addCell(writer, messages.PAYMENT_TYPE);
        this.addCell(writer, messages.FEE_TYPE);
        this.addCell(writer, messages.ADDITIONAL_INFORMATION);
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, DTAZVPayment logicalFile) throws IOException {
        List<DTAZVTransaction> transactions = logicalFile.getTransactions();
        int countTransactions = transactions.size();
        for (int i = 0; i < countTransactions; ++i) {
            DTAZVTransaction transaction = transactions.get(i);
            this.addCell(writer, logicalFile.getOriginator());
            this.addCell(writer, String.valueOf(transaction.getAccount()));
            this.addCell(writer, String.valueOf(transaction.getBlz()));
            this.addCell(writer, transaction.getRecipient());
            String iban = transaction.getIban();
            if (iban.startsWith("/")) {
                iban = iban.substring(1);
            }
            this.addCell(writer, iban);
            this.addCell(writer, transaction.getBic());
            this.addCell(writer, this.formatDate(logicalFile.getCreationDate(), this.locale));
            Date date = transaction.getExecutionDate();
            if (date == null) {
                date = logicalFile.getExecutionDate();
            }
            this.addCell(writer, this.formatDate(date, this.locale));
            this.addCell(writer, transaction.getReference());
            if (this.isCounterValuePayment(transaction)) {
                orderCurrency = transaction.getAccountCurrency();
                this.addCell(writer, this.formatAmount(transaction.getAmount(), Currency.getInstance(orderCurrency), this.locale));
                this.addCell(writer, orderCurrency);
                this.addCell(writer, transaction.getCurrency());
            } else {
                orderCurrency = transaction.getCurrency();
                this.addCell(writer, this.formatAmount(transaction.getAmount(), Currency.getInstance(orderCurrency), this.locale), true);
                this.addCell(writer, orderCurrency);
                this.addCell(writer, null);
            }
            this.addCell(writer, this.getPurpose(transaction));
            this.addCell(writer, this.getPaymentType(transaction));
            this.addCell(writer, this.getFeeType(transaction));
            this.addCell(writer, transaction.getInstructions());
            if (i >= countTransactions - 1) continue;
            this.startNewLine(writer);
        }
        return false;
    }

    private boolean isCounterValuePayment(DTAZVTransaction transaction) {
        try {
            String instrCode4 = Byte.toString(transaction.getInstructionCode4());
            return "91".equals(instrCode4);
        }
        catch (IllegalArgumentException illegal) {
            return false;
        }
    }

    private String getPurpose(DTAZVTransaction transaction) {
        StringBuilder sb = new StringBuilder(transaction.getPurpose());
        if (transaction.getPurpose2().trim().length() > 0) {
            sb.append(' ');
            sb.append(transaction.getPurpose2().trim());
        }
        if (transaction.getPurpose3().trim().length() > 0) {
            sb.append(' ');
            sb.append(transaction.getPurpose3().trim());
        }
        if (transaction.getPurpose4().trim().length() > 0) {
            sb.append(' ');
            sb.append(transaction.getPurpose4().trim());
        }
        return sb.toString();
    }

    private String getPaymentType(DTAZVTransaction transaction) {
        String s = Byte.toString(transaction.getPaymentType());
        if ("0".equals(s)) {
            return "00";
        }
        return s;
    }

    private String getFeeType(DTAZVTransaction transaction) {
        return "0" + Byte.toString(transaction.getFeeType());
    }
}

