/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.acmt;

import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.format.acmt.Account;
import de.businesslogics.format.acmt.AccountLimitInfo;
import de.businesslogics.format.acmt.Acmt01300102Writer;
import de.businesslogics.format.acmt.Acmt01700102Writer;
import de.businesslogics.format.acmt.LimitType;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;

public class AcmtUtil {
    public static File createAcmt013File(String messageId, String processId, de.businesslogics.banking.database.vo.Account account) {
        File file = null;
        try {
            file = Util.createTempFile("Acmt.013", null, false);
            String customerId = account.getBank().getCustomerId();
            try (FileOutputStream out = new FileOutputStream(file);){
                Acmt01300102Writer.write(out, messageId, processId, customerId, new Account(account.getIban(), account.getBic(), account.getCurrency()));
            }
        }
        catch (Exception e) {
            return null;
        }
        return file;
    }

    public static File createAcmt017File(String messageId, String processId, de.businesslogics.banking.database.vo.Account account, Account.LimitType accountlimitType, BigDecimal limit) {
        File file = null;
        try {
            file = Util.createTempFile("Acmt.017", null, false);
            String customerId = account.getBank().getCustomerId();
            LimitType limitType = AcmtUtil.getLimitType(accountlimitType);
            if (limitType == null) {
                // empty if block
            }
            if (limitType == LimitType.NO_LIMIT) {
                limit = null;
            }
            AccountLimitInfo accountLimitInfo = new AccountLimitInfo(new Account(account.getIban(), account.getBic(), account.getCurrency()), limitType, limit);
            try (FileOutputStream out = new FileOutputStream(file);){
                Acmt01700102Writer.write(out, messageId, processId, customerId, accountLimitInfo);
            }
        }
        catch (Exception e) {
            return null;
        }
        return file;
    }

    private static LimitType getLimitType(Account.LimitType accountlimitType) {
        if (Account.LimitType.DAY_LIMIT.equals((Object)accountlimitType)) {
            return LimitType.DAY_LIMIT;
        }
        if (Account.LimitType.TRANSACTION_LIMIT.equals((Object)accountlimitType)) {
            return LimitType.TRANSACTION_LIMIT;
        }
        if (Account.LimitType.NO_LIMIT.equals((Object)accountlimitType)) {
            return LimitType.NO_LIMIT;
        }
        return null;
    }

    public static Account.LimitType getLimitType(LimitType accountlimitType) {
        if (LimitType.DAY_LIMIT.equals((Object)accountlimitType)) {
            return Account.LimitType.DAY_LIMIT;
        }
        if (LimitType.TRANSACTION_LIMIT.equals((Object)accountlimitType)) {
            return Account.LimitType.TRANSACTION_LIMIT;
        }
        if (LimitType.NO_LIMIT.equals((Object)accountlimitType)) {
            return Account.LimitType.NO_LIMIT;
        }
        return null;
    }
}

