/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.acmt;

import de.businesslogics.banking.api.ZipHandler;
import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.banking.api.acmt.AcmtUtil;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.acmt.AccountLimitInfo;
import de.businesslogics.format.acmt.Acmt01400102Reader;
import de.businesslogics.format.iso20022.acmt01400102.Document;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class Acmt014Processing
implements ZipProcessing {
    private BLLogger logger;
    private ZipProcessingResult processingResult;
    private BankSettings bank;

    public ZipProcessingResult getProcessingResult() {
        return this.processingResult;
    }

    public Acmt014Processing(BLLogger logger, BankSettings bank) {
        this.logger = logger;
        this.bank = bank;
    }

    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        EbicsElement e = this.getDocument(in);
        if (!(e instanceof Document)) {
            throw new IOException("Unsupported acmt.014 version");
        }
        this.storeAccountLimitInfo(Acmt01400102Reader.readAccountLimitInfo((Document)e));
    }

    public void process(InputStream in) throws Exception {
        ZipHandler zipHandler = new ZipHandler(this, this.logger);
        zipHandler.process(in);
        this.processingResult = zipHandler.getProcessingResult();
    }

    private EbicsElement getDocument(InputStream in) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(Document.class);
        return EbicsHandler.parse(in, p);
    }

    private void storeAccountLimitInfo(AccountLimitInfo accountLimitInfo) {
        Account account;
        boolean isResponseToB13 = true;
        if (accountLimitInfo.getLimitType() == null) {
            isResponseToB13 = false;
        }
        if ((account = isResponseToB13 ? Account.findAccountByIbanBic(this.bank, accountLimitInfo.getAccount().getIban(), accountLimitInfo.getAccount().getBic(), accountLimitInfo.getAccount().getCurrencyCode()) : Account.findAccountByIpLimitMsgIdBic(this.bank, accountLimitInfo.getMsgId(), accountLimitInfo.getAccount().getBic())) != null) {
            if (account.getIpLimitTime() == null || account.getIpLimitTime().before(accountLimitInfo.getLimitTime())) {
                if (isResponseToB13) {
                    account.setIpLimit(accountLimitInfo.getAmount());
                    account.setIpLimitTime(accountLimitInfo.getLimitTime());
                    account.setIpLimitType(AcmtUtil.getLimitType(accountLimitInfo.getLimitType()));
                }
                account.setIpLimitState(Account.LimitState.CONFIRMED);
                account.setIpLimitMsgId(null);
                account.save();
            }
        } else if (isResponseToB13) {
            this.logger.logError("Could not find account with bank '" + this.bank.getDisplayName() + "', IBAN '" + accountLimitInfo.getAccount().getIban() + "', BIC '" + accountLimitInfo.getAccount().getBic() + "' and currency '" + accountLimitInfo.getAccount().getCurrencyCode() + "'.");
        } else {
            this.logger.logError("Could not find account with bank '" + this.bank.getDisplayName() + "', MsgId '" + accountLimitInfo.getMsgId() + "', BIC '" + accountLimitInfo.getAccount().getBic() + "'.");
        }
    }
}

