/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api.acmt;

import de.businesslogics.banking.api.ZipHandler;
import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.acmt.AccountLimitRejectionInfo;
import de.businesslogics.format.acmt.Acmt01100102Reader;
import de.businesslogics.format.iso20022.acmt01100102.Document;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class Acmt011Processing
implements ZipProcessing {
    private BLLogger logger;
    private ZipProcessingResult processingResult;
    private BankSettings bank;
    private AccountLimitRejectionInfo accountLimitRejectionInfo;

    public ZipProcessingResult getProcessingResult() {
        return this.processingResult;
    }

    public AccountLimitRejectionInfo getAccountLimitRejectionInfo() {
        return this.accountLimitRejectionInfo;
    }

    public Acmt011Processing(BLLogger logger, BankSettings bank) {
        this.logger = logger;
        this.bank = bank;
    }

    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        EbicsElement e = this.getDocument(in);
        if (!(e instanceof Document)) {
            throw new IOException("Unsupported acmt.014 version");
        }
        this.logErrorInfo(Acmt01100102Reader.readErrorInfo((Document)e));
    }

    private void logErrorInfo(AccountLimitRejectionInfo errorInfo) {
        this.accountLimitRejectionInfo = errorInfo;
        Account account = Account.findAccountByIbanBic(this.bank, errorInfo.getAccount().getIban(), errorInfo.getAccount().getBic(), errorInfo.getAccount().getCurrencyCode());
        if (account != null) {
            if (account.getIpLimitTime() == null || account.getIpLimitTime().before(errorInfo.getLimitTime())) {
                account.setIpLimitState(Account.LimitState.REJECTED);
                account.setIpLimitTime(errorInfo.getLimitTime());
                account.setIpLimitMsgId(null);
                account.save();
                for (String reason : errorInfo.getReasons()) {
                    this.logger.logError(reason);
                }
            }
        } else {
            this.logger.logError("Could not find account with bank '" + this.bank.getDisplayName() + "', IBAN '" + errorInfo.getAccount().getIban() + "', BIC '" + errorInfo.getAccount().getBic() + "' and currency '" + errorInfo.getAccount().getCurrencyCode() + "'.");
        }
    }

    public void process(InputStream in) throws Exception {
        ZipHandler zipHandler = new ZipHandler(this, this.logger);
        zipHandler.process(in);
        this.processingResult = zipHandler.getProcessingResult();
    }

    private EbicsElement getDocument(InputStream in) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(Document.class);
        return EbicsHandler.parse(in, p);
    }
}

