/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.PreferenceUtil;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class ZipProcessingResult {
    private String processingName;
    private final int countEntries;
    private final int countProcessedEntries;
    private Map<String, Exception> entryErrorMap;

    public ZipProcessingResult(String processingName, int countEntries, int countProcessedEntries, Map<String, Exception> entryErrorMap) {
        this.processingName = processingName;
        this.countEntries = countEntries;
        this.countProcessedEntries = countProcessedEntries;
        this.entryErrorMap = entryErrorMap;
    }

    public boolean hasProcessedEntries() {
        return this.countProcessedEntries > 0;
    }

    public boolean hasErrors() {
        return this.entryErrorMap.size() > 0;
    }

    public void evaluateResult(BLLogger logger, Locale locale) throws Exception {
        if (PreferenceUtil.logPerformance()) {
            logger.logInfo(this.processingName + ": Count entries = " + this.countEntries);
            logger.logInfo(this.processingName + ": Count processed entries = " + this.countProcessedEntries);
        }
        int countErrors = this.entryErrorMap.size();
        String firstErroneousEntry = null;
        Exception firstException = null;
        for (String entry : this.entryErrorMap.keySet()) {
            Exception e = this.entryErrorMap.get(entry);
            if (firstErroneousEntry == null) {
                firstErroneousEntry = entry;
                firstException = e;
            }
            logger.logError(this.processingName + ": Could not process entry '" + entry + "'" + e.getMessage());
        }
        if (countErrors == 1) {
            throw new IOException(MessageFormat.format(BankingApiMessages.getString(locale, "ZipProcessingResult.log.error", new Object[0]), firstErroneousEntry, this.countEntries, firstException.getMessage()), null);
        }
        if (countErrors > 1) {
            throw new IOException(MessageFormat.format(BankingApiMessages.getString(locale, "ZipProcessingResult.log.errors", new Object[0]), countErrors, this.countEntries, firstException.getMessage()), null);
        }
    }

    public String getDialogTitle(Locale locale) {
        return BankingApiMessages.getString(locale, "ZipProcessingResult.dialog.title", new Object[0]);
    }

    public String getDialogMessage(Locale locale) {
        if (this.countEntries > 1) {
            return MessageFormat.format(BankingApiMessages.getString(locale, "ZipProcessingResult.dialog.message", new Object[0]), this.entryErrorMap.size(), this.countEntries);
        }
        return BankingApiMessages.getString(locale, "ZipProcessingResult.dialog.message2", new Object[0]);
    }
}

