/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BaseZipHandler;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.format.sepa.MultipleInputStream;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.io.PushbackInputStream;

public final class ZipHandler
extends BaseZipHandler {
    public ZipHandler(ZipProcessing processing, BLLogger logger) {
        super(processing, logger);
    }

    public void process(InputStream in) throws Exception {
        PushbackInputStream pushback = new PushbackInputStream(in, 2);
        if (this.isZipFile(pushback)) {
            File tempFile = Util.createTempFile("ZipHandler", ".zip", false);
            SystemUtils.copyStream(pushback, tempFile, true);
            this.processZippedFile(tempFile);
        } else {
            MultipleInputStream multiple = new MultipleInputStream(pushback);
            do {
                this.processing.processUnzipped(null, multiple);
            } while (multiple.reopen());
        }
    }
}

