/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import java.text.MessageFormat;
import java.util.Locale;

public class WrongTransferTypeException
extends Exception {
    private final String transferType;
    private final String configuredTransferType;
    private final BankSettings bank;
    private final PaymentTransferType.PmtType pmtType;
    private final String dialogTitle;
    private final String dialogMessage;
    private static final long serialVersionUID = -4415567867993518040L;

    public WrongTransferTypeException(String transferType, String configuredTransferType, BankSettings bank, PaymentTransferType.PmtType pmtType, Locale locale) {
        this.transferType = transferType;
        this.configuredTransferType = configuredTransferType;
        this.pmtType = pmtType;
        this.bank = bank;
        if (Util.isOrderType(transferType)) {
            this.dialogTitle = BankingApiMessages.getString(locale, "WrongTransferTypeException.orderType.dialogTitle", new Object[0]);
            this.dialogMessage = MessageFormat.format(BankingApiMessages.getString(locale, "WrongTransferTypeException.orderType.dialogMessage", new Object[0]), PaymentTypeUtil.getUniqueSendOrderName(locale, pmtType), configuredTransferType, transferType);
        } else {
            this.dialogTitle = BankingApiMessages.getString(locale, "WrongTransferTypeException.btf.dialogTitle", new Object[0]);
            this.dialogMessage = MessageFormat.format(BankingApiMessages.getString(locale, "WrongTransferTypeException.btf.dialogMessage", new Object[0]), PaymentTypeUtil.getUniqueSendOrderName(locale, pmtType), configuredTransferType, transferType);
        }
    }

    public String getTransferType() {
        return this.transferType;
    }

    public String getConfiguredTransferType() {
        return this.configuredTransferType;
    }

    public BankSettings getBank() {
        return this.bank;
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this.pmtType;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public String getDialogMessage() {
        return this.dialogMessage;
    }
}

