/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.ClusterNode;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import java.io.File;
import java.util.List;

public class WorkspaceFileSystem {
    public static File CM_DIRECTORY;
    public static File DTI_DIRECTORY;
    public static File BKA_DIRECTORY;
    public static File BKI_DIRECTORY;
    public static File FETCH_DIR;
    public static File SENT_DIR;
    public static File NOTIFICATION_DIR;
    public static File DS_DIRECTORY;
    public static File TEMP_DIRECTORY;
    public static final ClusterNode MY_NODE;
    public static String AUT_EXPORT_BASE_PATH;
    private static FileSync FILE_SYNC;

    public static void initialize(File workspace) {
        CM_DIRECTORY = new File(workspace, "cm");
        DTI_DIRECTORY = new File(workspace, "dti");
        BKA_DIRECTORY = new File(workspace, "bka");
        BKI_DIRECTORY = new File(workspace, "bki");
        FETCH_DIR = new File(new File(workspace, "data"), "fetched");
        SENT_DIR = new File(new File(workspace, "data"), "sent");
        NOTIFICATION_DIR = new File(workspace, "notifications");
        DS_DIRECTORY = new File(workspace, "ds");
        TEMP_DIRECTORY = new File(workspace, "tmp");
    }

    public static void setFileSync(FileSync fileSync) {
        FILE_SYNC = fileSync;
    }

    private static File getDirectory(WorkspaceFile.Prefix prefix) {
        return switch (prefix) {
            case WorkspaceFile.Prefix.BKA -> BKA_DIRECTORY;
            case WorkspaceFile.Prefix.BKI -> BKI_DIRECTORY;
            case WorkspaceFile.Prefix.CM -> CM_DIRECTORY;
            case WorkspaceFile.Prefix.DATA_FETCHED -> FETCH_DIR;
            case WorkspaceFile.Prefix.DATA_SENT -> SENT_DIR;
            case WorkspaceFile.Prefix.DTI -> DTI_DIRECTORY;
            case WorkspaceFile.Prefix.DS -> DS_DIRECTORY;
            case WorkspaceFile.Prefix.NOTIFICATIONS -> NOTIFICATION_DIR;
            case WorkspaceFile.Prefix.TEMPORARY_FILE -> TEMP_DIRECTORY;
            default -> null;
        };
    }

    public static WorkspaceFile createFile(WorkspaceFile.Prefix prefix, File localFile, long size, String md5Hash, String sha256Hash) {
        if (size == 0L) {
            size = localFile.length();
        }
        WorkspaceFile workspaceFile = new WorkspaceFile();
        workspaceFile.setPrefix(prefix);
        workspaceFile.setSize(size);
        workspaceFile.setSha256Hash(sha256Hash);
        workspaceFile.setMd5Hash(md5Hash);
        File parentDir = WorkspaceFileSystem.getDirectory(prefix);
        if (parentDir == null) {
            workspaceFile.setPath(localFile.getAbsolutePath());
        } else {
            workspaceFile.setPath(localFile.getAbsolutePath().substring(parentDir.getAbsolutePath().length()));
        }
        if (MY_NODE != null) {
            workspaceFile.getClusterNodes().add(MY_NODE);
        }
        workspaceFile.save();
        return workspaceFile;
    }

    public static void delete(WorkspaceFile wf) {
        if (wf == null) {
            return;
        }
        File f = WorkspaceFileSystem.toFile(wf);
        if (f.isFile()) {
            f.delete();
        }
        wf.setDeleted(true);
        wf.save();
    }

    public static File toFile(WorkspaceFile wf) {
        String name = File.separatorChar == '/' ? wf.getPath().replace('\\', File.separatorChar) : wf.getPath().replace('/', File.separatorChar);
        return new File(WorkspaceFileSystem.getDirectory(wf.getPrefix()), name);
    }

    public static File getFile(WorkspaceFile wf) {
        File toReturn = WorkspaceFileSystem.toFile(wf);
        if (!toReturn.isFile()) {
            if (FILE_SYNC != null) {
                FILE_SYNC.getFile(wf, toReturn);
            }
            if (!toReturn.isFile()) {
                System.out.println("File " + toReturn.getAbsolutePath() + " not found or not a file");
            } else if (MY_NODE != null && !wf.getClusterNodes().contains(MY_NODE)) {
                wf.getClusterNodes().add(MY_NODE);
                wf.save();
            }
        }
        return toReturn;
    }

    static {
        MY_NODE = ClusterNode.getThisNode();
        AUT_EXPORT_BASE_PATH = null;
        FILE_SYNC = null;
    }

    public static interface FileSync {
        public void getFile(WorkspaceFile var1, File var2);
    }

    public static class CleanUpScheduler
    implements Runnable {
        @Override
        public void run() {
            if (MY_NODE == null) {
                List<WorkspaceFile> deletes = WorkspaceFile.findDeletedFiles();
                for (WorkspaceFile file : deletes) {
                    File f;
                    if (WorkspaceFile.findExisting(file) == null && (f = WorkspaceFileSystem.toFile(file)).isFile()) {
                        f.delete();
                    }
                    boolean foundReference = false;
                    switch (file.getPrefix()) {
                        case BKA: 
                        case BKI: {
                            if (DB.find(CmPdfStatement.class).where().eq("localFile", (Object)file).findCount() <= 0) break;
                            foundReference = true;
                            System.out.println("file " + file.getPath() + " (Prefix: \"+file.getPrefix()+\") still referenced, but marked as deleted");
                            break;
                        }
                        case CM: 
                        case DTI: {
                            if (DB.find(CmStatement.class).where().eq("file", (Object)file).findCount() > 0) {
                                foundReference = true;
                            }
                            if (DB.find(CmPage.class).where().eq("file", (Object)file).findCount() <= 0) break;
                            foundReference = true;
                            break;
                        }
                        case DS: {
                            if (DB.find(DsOpenOrder.class).where().eq("orderData", (Object)file).findCount() > 0) {
                                foundReference = true;
                            }
                            if (DB.find(DsOrderDetails.class).where().eq("dataFile", (Object)file).findCount() <= 0) break;
                            foundReference = true;
                            break;
                        }
                        case NOTIFICATIONS: {
                            if (DB.find(Notification.class).where().eq("file", (Object)file).findCount() <= 0) break;
                            foundReference = true;
                            break;
                        }
                        case DATA_SENT: {
                            if (DB.find(Send.class).where().eq("file", (Object)file).findCount() <= 0) break;
                            foundReference = true;
                            break;
                        }
                        case DATA_FETCHED: {
                            if (DB.find(Fetch.class).where().eq("file", (Object)file).findCount() <= 0) break;
                            foundReference = true;
                        }
                    }
                    if (foundReference) {
                        System.err.println("file " + file.getPath() + " (Prefix: " + String.valueOf((Object)file.getPrefix()) + ") still referenced, but marked as deleted");
                        continue;
                    }
                    DB.delete(file);
                }
            } else {
                List<WorkspaceFile> deletes = WorkspaceFile.findFilesToDelete(MY_NODE);
                for (WorkspaceFile fileToDelete : deletes) {
                    File f;
                    if (WorkspaceFile.findExisting(fileToDelete) == null && (f = WorkspaceFileSystem.toFile(fileToDelete)).isFile()) {
                        f.delete();
                    }
                    fileToDelete.getClusterNodes().remove(MY_NODE);
                    if (fileToDelete.getClusterNodes().isEmpty()) {
                        DB.delete(fileToDelete);
                        continue;
                    }
                    fileToDelete.save();
                }
            }
        }
    }
}

