/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.request.OrderType;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class WSSTst {
    private final List<OrderType> orderTypes = new ArrayList<OrderType>();
    private final List<RestrictedServiceType> restrictedServiceTypes = new ArrayList<RestrictedServiceType>();

    public WSSTst(File wssTestFile) {
        if (wssTestFile.exists()) {
            try (InputStream propertiesInputStream = Files.newInputStream(wssTestFile.toPath(), new OpenOption[0]);){
                Properties wssTestProperties = new Properties();
                wssTestProperties.load(propertiesInputStream);
                String ots = wssTestProperties.getProperty("ORDERTYPES");
                StringTokenizer st = new StringTokenizer(ots, ",");
                while (st.hasMoreTokens()) {
                    this.orderTypes.add(new OrderType(st.nextToken()));
                }
                String btfs = wssTestProperties.getProperty("BTFS");
                st = new StringTokenizer(btfs, ",");
                while (st.hasMoreTokens()) {
                    this.restrictedServiceTypes.add(BTFTranslator.convertFrom(st.nextToken()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<OrderType> getOrderTypes() {
        return this.orderTypes;
    }

    public List<RestrictedServiceType> getRestrictedServiceTypes() {
        return this.restrictedServiceTypes;
    }
}

