/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.DownloadableListener;
import de.businesslogics.banking.api.DownloadableNotificationsListener;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.client.WSSListener;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.util.BLLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WSSListenerImpl
implements WSSListener {
    private final BankSettings bank;
    private final Set<DownloadableListener> downloadableListeners;
    private final DownloadableListener generalDownloadableListener;
    private final DownloadableNotificationsListener downloadableNotificationListener;
    private final BLLogger logger;

    public WSSListenerImpl(BankSettings bank, Set<DownloadableListener> downloadableListeners, DownloadableListener generalDownloadableListener, DownloadableNotificationsListener downloadableNotificationListener, BLLogger logger) {
        this.bank = bank;
        this.downloadableListeners = downloadableListeners;
        this.generalDownloadableListener = generalDownloadableListener;
        this.downloadableNotificationListener = downloadableNotificationListener;
        this.logger = logger;
    }

    @Override
    public void info(TimeStamp t, Map<String, String> infos) {
    }

    @Override
    public void downloadable(TimeStamp t, List<OrderType> ots, List<RestrictedServiceType> btfs) {
        if (BankUtils.isProtocolH005OrNewer(this.bank.getProtocolVersion())) {
            this.handleDownloadableBTFsAndAdminOrderTypes(t, btfs, this.getAdminOrderTypes(ots));
        } else {
            this.handleDownloadableOrderTypes(t, ots);
        }
    }

    private List<OrderType> getAdminOrderTypes(List<OrderType> ots) {
        ArrayList<OrderType> adminOrderTypes = new ArrayList<OrderType>();
        for (OrderType ot : ots) {
            if (!OrderType.ADMIN30_FETCH_ORDER_TYPES.contains(ot)) continue;
            adminOrderTypes.add(ot);
        }
        return adminOrderTypes;
    }

    private void handleDownloadableOrderTypes(TimeStamp t, List<OrderType> ots) {
        HashSet<OrderType> unprocessedOrderTypes = new HashSet<OrderType>();
        unprocessedOrderTypes.addAll(ots);
        for (DownloadableListener listener : this.downloadableListeners) {
            unprocessedOrderTypes.removeAll(listener.downloadableOrderTypes(this.bank, t, ots));
        }
        if (this.generalDownloadableListener != null) {
            unprocessedOrderTypes.removeAll(this.generalDownloadableListener.downloadableOrderTypes(this.bank, t, unprocessedOrderTypes));
        }
        for (OrderType ot : unprocessedOrderTypes) {
            WSSListenerImpl.logDownloadable(this.logger, this.bank, t, ot.getValue());
        }
        this.downloadableNotificationListener.notificationsReceived();
    }

    private void handleDownloadableBTFsAndAdminOrderTypes(TimeStamp t, List<RestrictedServiceType> btfs, List<OrderType> ots) {
        HashSet<RestrictedServiceType> unprocessedBTFs = new HashSet<RestrictedServiceType>();
        unprocessedBTFs.addAll(btfs);
        for (DownloadableListener listener : this.downloadableListeners) {
            unprocessedBTFs.removeAll(listener.downloadableBTFs(this.bank, t, btfs));
        }
        if (this.generalDownloadableListener != null) {
            unprocessedBTFs.removeAll(this.generalDownloadableListener.downloadableBTFs(this.bank, t, unprocessedBTFs));
        }
        for (RestrictedServiceType btf : unprocessedBTFs) {
            WSSListenerImpl.logDownloadable(this.logger, this.bank, t, BTFTranslator.convertToString(btf));
        }
        HashSet<OrderType> unprocessedOrderTypes = new HashSet<OrderType>();
        unprocessedOrderTypes.addAll(ots);
        for (DownloadableListener listener : this.downloadableListeners) {
            unprocessedOrderTypes.removeAll(listener.downloadableOrderTypes(this.bank, t, ots));
        }
        if (this.generalDownloadableListener != null) {
            unprocessedOrderTypes.removeAll(this.generalDownloadableListener.downloadableOrderTypes(this.bank, t, unprocessedOrderTypes));
        }
        for (OrderType ot : unprocessedOrderTypes) {
            WSSListenerImpl.logDownloadable(this.logger, this.bank, t, ot.getValue());
        }
        this.downloadableNotificationListener.notificationsReceived();
    }

    public static void logDownloadable(BLLogger logger, BankSettings bank, TimeStamp t, String fetchType) {
        WSSListenerImpl.logDownloadable(logger, bank, t, fetchType, null);
    }

    public static void logDownloadable(BLLogger logger, BankSettings bank, TimeStamp t, String fetchType, String additionalInfo) {
        logger.logInfo("Downloadble - message from bank " + bank.getDisplayName() + (String)(t != null ? " from " + String.valueOf(t.getDate()) : "") + " for fetch type " + fetchType + (String)(additionalInfo != null ? " Additional info: " + additionalInfo : ""));
    }

    @Override
    public void closed(int closeCode, String reasonPhrase) {
    }
}

