/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.NotificationTrx;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusCode;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VopUtil {
    private static Date VOP_INFO_EXPIRATION_DATE = null;

    public static List<NotificationTrx> getVopResults(List<SEPAPaymentData> payments, String resultCode) {
        ArrayList<NotificationTrx> allNotifications = new ArrayList<NotificationTrx>();
        for (SEPAPaymentData p : payments) {
            String recipientName = p.getRecipient();
            String recipientIban = p.getRecipientIban();
            List<NotificationTrx> notifications = NotificationTrx.findVopNotifications(recipientIban, recipientName, resultCode);
            allNotifications.addAll(notifications);
        }
        return allNotifications;
    }

    public static List<NotificationTrx> getVopResults(List<SEPAPaymentData> payments, Set<String> resultCodes) {
        ArrayList<NotificationTrx> allNotifications = new ArrayList<NotificationTrx>();
        HashSet<CallSite> checkedRecipients = new HashSet<CallSite>();
        for (SEPAPaymentData p : payments) {
            String recipientIban;
            String recipientName = p.getRecipient();
            if (!checkedRecipients.add((CallSite)((Object)(recipientName + (recipientIban = p.getRecipientIban()))))) continue;
            List<NotificationTrx> notifications = NotificationTrx.findVopNotifications(recipientIban, recipientName, resultCodes);
            allNotifications.addAll(notifications);
        }
        return allNotifications;
    }

    public static boolean hasVopResults(List<SEPAPaymentData> payments, Set<String> resultCodes) {
        HashSet<CallSite> checkedRecipients = new HashSet<CallSite>();
        for (SEPAPaymentData p : payments) {
            List<NotificationTrx> notifications;
            String recipientIban;
            String recipientName = p.getRecipient();
            if (!checkedRecipients.add((CallSite)((Object)(recipientName + (recipientIban = p.getRecipientIban())))) || (notifications = NotificationTrx.findVopNotifications(recipientIban, recipientName, resultCodes)).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getVopResultCodes() {
        HashSet<String> states = new HashSet<String>();
        for (StatusCode.VopResultCodes vopResultCode : StatusCode.VopResultCodes.values()) {
            states.add(vopResultCode.name());
        }
        return states;
    }

    public static Set<String> getNonPendingVopResultCodes() {
        HashSet<String> states = new HashSet<String>();
        for (StatusCode.VopResultCodes vopResultCode : StatusCode.VopResultCodes.values()) {
            if (StatusCode.VopResultCodes.PDNG.equals((Object)vopResultCode)) continue;
            states.add(vopResultCode.name());
        }
        return states;
    }

    public static boolean isFullMatch(String vopResultCode) {
        return StatusCode.VopResultCodes.RCVC.name().equals(vopResultCode);
    }

    public static boolean isCloseMatch(String vopResultCode) {
        return StatusCode.VopResultCodes.RVMC.name().equals(vopResultCode);
    }

    public static boolean isNoMatch(String vopResultCode) {
        return StatusCode.VopResultCodes.RVNM.name().equals(vopResultCode);
    }

    public static boolean isNotApplicable(String vopResultCode) {
        return StatusCode.VopResultCodes.RVNA.name().equals(vopResultCode);
    }

    public static boolean isPending(String vopResultCode) {
        return StatusCode.VopResultCodes.PDNG.name().equals(vopResultCode);
    }

    public static boolean hasVopPermission(User user, BankSettings bank, PaymentTransferType.PmtType pmtType) {
        if (pmtType == null) {
            return false;
        }
        return VopUtil.hasVopPermission(user, bank, Collections.singletonList(pmtType));
    }

    public static boolean hasVopPermission(User user, BankSettings bank, Collection<PaymentTransferType.PmtType> pmtTypes) {
        BankUser bankUser = BankUser.findBankUser(bank, user);
        if (BankUserHtdInfo.findForBankUser(bankUser) == null) {
            return true;
        }
        for (PaymentTransferType.PmtType pmtType : pmtTypes) {
            if (!pmtType.supportsVop()) continue;
            String transferType = SendParameters.getTransferTypeVopByBank(bank, pmtType);
            if (Util.isOrderType(transferType)) {
                return UserPermission.hasPermissionForOrderType(bankUser, OrderType.TransferType.SEND, transferType);
            }
            return UserPermission.hasPermissionForFileFormat(bankUser, OrderType.TransferType.SEND, transferType);
        }
        return false;
    }

    private static Date getVopInfoExpirationDate() {
        if (VOP_INFO_EXPIRATION_DATE == null) {
            String defaultVopInfoExpirationDate = "20251201";
            String vopInfoExpirationDate = System.getProperty("vopInfoExpirationDate", defaultVopInfoExpirationDate);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                VOP_INFO_EXPIRATION_DATE = sdf.parse(vopInfoExpirationDate);
            }
            catch (Exception ignored) {
                try {
                    VOP_INFO_EXPIRATION_DATE = sdf.parse(vopInfoExpirationDate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return VOP_INFO_EXPIRATION_DATE;
    }

    public static boolean showVopInfoOnLogin() {
        return new Date().before(VopUtil.getVopInfoExpirationDate());
    }
}

