/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.Messages;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.PreferenceUtil;
import de.businesslogics.banking.api.SigningInfo;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.api.WrongTransferTypeException;
import de.businesslogics.banking.core.GeneralTexts;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.bcs.appetizer.HIALetter;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.orders.OrderInfo;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.sepa.CCTTicketI;
import de.businesslogics.format.sepa.CCTTicketWrapper;
import de.businesslogics.format.sepa.StatusCode;
import de.businesslogics.format.sepa.pain00800201.Pain00800201PmtInfTicket;
import de.businesslogics.format.sepa.pain00800201.Pain00800201Ticket;
import de.businesslogics.format.ticket.ATTHMDisplayMessageGenerator;
import de.businesslogics.format.ticket.BinaryGenerator;
import de.businesslogics.format.ticket.CCCDisplayMessageGenerator;
import de.businesslogics.format.ticket.CCCSingleTicket;
import de.businesslogics.format.ticket.CCCTicket;
import de.businesslogics.format.ticket.CCTDisplayMessageGenerator;
import de.businesslogics.format.ticket.CCTSingleTicket;
import de.businesslogics.format.ticket.CDxContainerDisplayMessageGenerator;
import de.businesslogics.format.ticket.CDxContainerSingleTicket;
import de.businesslogics.format.ticket.CDxContainerTicket;
import de.businesslogics.format.ticket.CDxDisplayMessageGenerator;
import de.businesslogics.format.ticket.CDxSingleTicket;
import de.businesslogics.format.ticket.Camt055DisplayMessageGenerator;
import de.businesslogics.format.ticket.DTAZVGenerator;
import de.businesslogics.format.ticket.DispatchNote;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.MT101Generator;
import de.businesslogics.format.ticket.SEPACreditDisplayMessageGenerator;
import de.businesslogics.format.ticket.SEPADebitDisplayMessageGenerator;
import de.businesslogics.format.ticket.XZVDisplayMessageGenerator;
import de.businesslogics.io.Streams;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class Util {
    public static final String[] BBK_DTI_ORDER_TYPES = new String[]{"DTI", "C54", "X54", "YG1", "YG2", "YWA", "YGB", "YLB", "YGD", "YGS", "YCG", "YCL", "YCD", "YCS"};
    public static final String[] DTI_ORDER_TYPES = new String[]{"DTI", "C54", "X54"};
    public static File WORKSPACEDIR = null;
    private static File tempDir = null;
    public static BLLogger logger;

    public static void initialize(File workspace, BLLogger logger) {
        WORKSPACEDIR = workspace.getAbsoluteFile();
        Util.logger = logger;
        WorkspaceFileSystem.initialize(WORKSPACEDIR);
        BLZCache.initialize(WORKSPACEDIR, logger);
    }

    public static BLDocument createBLDocument(OutputStream outputStream, BLDocument.PageLayout size, String title, boolean withLogo, Locale locale) throws PDFException {
        return Util.createBLDocument(outputStream, size, title, withLogo, locale, false);
    }

    public static BLDocument createBLDocument(OutputStream outputStream, BLDocument.PageLayout size, String title, boolean withLogo, Locale locale, boolean withMoreFooterText) throws PDFException {
        BLDocument document = PDFCreator.getInstance().createDocument(size, locale, 15.0f, 15.0f, withLogo ? 50.0f : 25.0f, withMoreFooterText ? 45.0f : 30.0f);
        document.addMetaInformation(title, BankingApiMessages.getString(locale, "Printer.author", new Object[0]), BankingApiMessages.getString(locale, "Printer.creator", new Object[0]), true, true);
        document.open(outputStream);
        return document;
    }

    public static File createTempFile(String prefix, String suffix, boolean deleteOnExit) throws IOException {
        Util.initTempDir();
        if (prefix == null || ((String)prefix).length() < 3) {
            prefix = prefix == null ? "Prefix" : (String)prefix + "___";
        }
        prefix = Util.replaceForbbidenChars((String)prefix);
        suffix = Util.replaceForbbidenChars(suffix);
        File tempfile = File.createTempFile((String)prefix, suffix, tempDir);
        if (deleteOnExit) {
            tempfile.deleteOnExit();
        }
        return tempfile;
    }

    private static String replaceForbbidenChars(String s) {
        if (s != null) {
            return s.replaceAll(RegularExpressions.FORBIDDEN_FILE_NAME_CHARS.getPattern().pattern(), "-");
        }
        return null;
    }

    public static File createTempFolder(String prefix, boolean deleteOnExit) throws IOException {
        Util.initTempDir();
        if (prefix == null || ((String)prefix).length() < 3) {
            prefix = prefix == null ? "Prefix" : (String)prefix + "___";
        }
        File tempFolder = new File(String.valueOf(Files.createTempDirectory(Paths.get(tempDir.getPath(), new String[0]), (String)prefix, new FileAttribute[0])));
        if (deleteOnExit) {
            tempFolder.deleteOnExit();
        }
        return tempFolder;
    }

    private static void initTempDir() {
        if (tempDir == null) {
            Object tmpDir = System.getProperty("de.businesslogics.tmpdir", null);
            if (tmpDir == null) {
                tmpDir = String.valueOf(WORKSPACEDIR) + File.separator + "tmp";
            }
            tempDir = new File((String)tmpDir);
        }
        tempDir.mkdirs();
    }

    public static void cleanupTempdir() {
        Util.initTempDir();
        if (tempDir.exists()) {
            Calendar c = Calendar.getInstance();
            c.add(5, -1);
            Date olderThan = c.getTime();
            Util.deleteFilesOlderThan(tempDir, olderThan);
        }
    }

    public static void deleteFilesOlderThan(File dir, Date olderThan) {
        File[] list = dir.listFiles();
        if (list == null) {
            return;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                Util.deleteFilesOlderThan(f, olderThan);
                if (f.listFiles().length != 0) continue;
                f.delete();
                continue;
            }
            if (0L >= f.lastModified() || f.lastModified() >= olderThan.getTime()) continue;
            f.delete();
        }
    }

    public static void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ioe) {
            logger.logError("IOException while closing a stream", ioe);
        }
    }

    public static boolean printLogo(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.PRINT_LOGO);
    }

    public static void applyPreferencesToPdf(File file, User user, String prefix, Locale locale) throws PDFException, IOException {
        Util.applyPreferencesToPdf(file, user, prefix, locale, null, null);
    }

    public static void applyPreferencesToPdf(File file, User user, String prefix, Locale locale, String footerText1, String footerText2) throws PDFException, IOException {
        DatabasePreferenceStore preferences = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        boolean printLogo = preferences.getBoolean(PreferenceConstants.PRINT_LOGO);
        Util.applyPreferencesToPdf(file, user, prefix, locale, null, null, printLogo);
    }

    public static void applyPreferencesToPdf(File file, User user, String prefix, Locale locale, String footerText1, String footerText2, boolean printLogo) throws PDFException, IOException {
        DatabasePreferenceStore preferences = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        boolean printPageNumbers = preferences.getBoolean(PreferenceConstants.PRINT_PAGE_NUMBERS);
        boolean printTimestamp = preferences.getBoolean(PreferenceConstants.PRINT_DATE_TIME);
        boolean printUsername = preferences.getBoolean(PreferenceConstants.PRINT_USER_NAME);
        if (printPageNumbers || printTimestamp || printUsername || printLogo || footerText1 != null || footerText2 != null) {
            Object pageNumber = null;
            if (printPageNumbers) {
                pageNumber = prefix == null ? BankingApiMessages.getString(locale, "Util.pageNumbers", new Object[0]) : prefix + " " + BankingApiMessages.getString(locale, "Util.pageNumbers", new Object[0]);
            }
            String timestamp = printTimestamp ? DateFormat.getDateTimeInstance(2, 3, locale).format(new Date()) : null;
            String username = printUsername ? user.getName() : null;
            byte[] logo = (byte[])(printLogo ? HIALetter.IMAGE : null);
            File tmp = PDFCreator.getInstance().addPageNumbersFootersAndLogo(file, new BLDocument.Footer(username, timestamp, null), (String)pageNumber, logo, footerText1, footerText2);
            File backup = new File(String.valueOf(file.getAbsoluteFile()) + ".bak");
            if (Util.copyFiles(file, backup) && Util.copyFiles(tmp, file)) {
                if (!backup.delete()) {
                    backup.deleteOnExit();
                }
            } else if (!file.isFile() && backup.isFile()) {
                Util.copyFiles(backup, file);
            }
        }
    }

    public static boolean copyFiles(File from, File to) {
        if (!from.renameTo(to)) {
            try {
                Streams.copy(Files.newInputStream(from.toPath(), new OpenOption[0]), Files.newOutputStream(to.toPath(), new OpenOption[0]));
                if (!from.delete()) {
                    from.deleteOnExit();
                }
            }
            catch (IOException e) {
                logger.logError("Failed to copy file " + from.getAbsolutePath() + " to file " + to.getAbsolutePath(), e);
                return false;
            }
        }
        return true;
    }

    public static boolean useSeparatePasswords() {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null).getBoolean(PreferenceConstants.USE_SEPARATE_PASSWORDS);
    }

    public static boolean isSyncronizationAllowed(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_SYNCHRONISATION);
    }

    public static boolean displaySalaries(User user) {
        String s = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getString(PreferenceConstants.SALARY_PERMISSIONS);
        return PreferenceConstants.SALARY_PERMISSION.FULL.toString().equals(s);
    }

    public static boolean displayOpenSalaries(User user) {
        return Util.displaySalaries(user);
    }

    public static boolean printSalaries(User user) {
        if (Util.displaySalaries(user)) {
            return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.PRINT_AMOUNTS_OF_SALARY_PAYMENTS);
        }
        return false;
    }

    public static boolean importSalaries(User user) {
        return Util.displaySalaries(user);
    }

    public static boolean hideSalariesCompletely(User user) {
        String s = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getString(PreferenceConstants.SALARY_PERMISSIONS);
        return PreferenceConstants.SALARY_PERMISSION.NO.toString().equals(s) || PreferenceConstants.SALARY_PERMISSION.PARTIAL_NO_DETAILS.toString().equals(s);
    }

    public static boolean sendSalaries(User user) {
        String s = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getString(PreferenceConstants.SALARY_PERMISSIONS);
        return !PreferenceConstants.SALARY_PERMISSION.NO.toString().equals(s);
    }

    public static void setImportSalaries(User user, boolean newValue) {
        if (newValue) {
            new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, PreferenceConstants.SALARY_PERMISSION.FULL.toString());
        }
    }

    public static File getKeyDirectory(User u) {
        if (u.getKeyDirectory() == null) {
            return null;
        }
        File f = new File(u.getKeyDirectory());
        if (!f.isAbsolute()) {
            return new File(WORKSPACEDIR, u.getKeyDirectory());
        }
        return f;
    }

    public static String checkKeyDirUnique(String keyDirString) {
        if (keyDirString == null) {
            return null;
        }
        User dummy = new User();
        if (keyDirString.startsWith(WORKSPACEDIR.getAbsolutePath())) {
            dummy.setKeyDirectory("." + keyDirString.substring(WORKSPACEDIR.getAbsolutePath().length()));
        } else {
            dummy.setKeyDirectory(keyDirString);
        }
        int i = Util.checkKeyDirUnique(dummy);
        if (i > 0) {
            return keyDirString + "_" + i;
        }
        return keyDirString;
    }

    public static int checkKeyDirUnique(User user) {
        List<User> users = User.getAll();
        users.remove(user);
        HashSet<File> keyDirs = new HashSet<File>();
        for (User u : users) {
            File f = Util.getKeyDirectory(u);
            if (f == null) continue;
            keyDirs.add(f.getAbsoluteFile());
        }
        File keyDir = Util.getKeyDirectory(user).getAbsoluteFile();
        String path = keyDir.getPath();
        int i = 0;
        while (keyDirs.contains(keyDir)) {
            keyDir = new File(path + "_" + ++i).getAbsoluteFile();
        }
        if (i > 0) {
            user.setKeyDirectory(user.getKeyDirectory() + "_" + i);
        }
        return i;
    }

    public static Calendar computeFromNow(int age, int unit) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        switch (unit) {
            case 0: {
                c.add(5, -age);
                break;
            }
            case 1: {
                c.add(3, -age);
                break;
            }
            case 2: {
                c.add(2, -age);
                break;
            }
            case 3: {
                c.add(1, -age);
            }
        }
        return c;
    }

    public static String getFormattedSizeInBytes(Long size, Locale locale) {
        if (size != null) {
            return NumberFormat.getIntegerInstance(locale).format(size) + " Bytes";
        }
        return "";
    }

    public static String getFormattedExecutionTime(Timestamp executionTime, Locale locale) {
        if (executionTime != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(executionTime);
            if (c.get(11) == 0 && c.get(12) == 0) {
                return DateFormat.getDateInstance(2, locale).format(executionTime);
            }
            return DateFormat.getDateTimeInstance(2, 3, locale).format(executionTime);
        }
        return "";
    }

    public static String getShortVopResultDescription(StatusCode.VopResultCodes result, Locale locale) {
        return Util.getShortVopResultDescription(result.name(), locale);
    }

    public static String getShortVopResultDescription(String result, Locale locale) {
        String toReturn = "";
        if (result != null) {
            String description = StatusCode.getShortDescription(result, StatusCode.StatusCodeContext.SEPA, StatusCode.StatusCodeLevel.Transaction, locale);
            toReturn = description != null ? description + " (" + result + ")" : result;
        }
        return toReturn;
    }

    public static String getNameWithIdInBrackets(String name, String id) {
        if (name != null && name.trim().length() > 0) {
            if (id != null && id.trim().length() > 0) {
                return name.trim() + " (" + id.trim() + ")";
            }
            return name.trim();
        }
        if (id != null && id.trim().length() > 0) {
            return id.trim();
        }
        return "";
    }

    public static boolean hasFetchPermission(BankUser user, String fetchType) {
        if (Util.isOrderType(fetchType) ? UserPermission.hasPermissionForOrderType(user, OrderType.TransferType.FETCH, fetchType) : UserPermission.hasPermissionForFileFormat(user, OrderType.TransferType.FETCH, fetchType)) {
            return true;
        }
        BankUserHtdInfo htd = BankUserHtdInfo.findForBankUser(user);
        return htd == null;
    }

    public static boolean isOrderType(String fetchType) {
        return RegularExpressions.ORDER_TYPE.matches(fetchType);
    }

    public static boolean isCharacterValid(char c, Pattern pattern) {
        if (Character.isISOControl(c)) {
            return true;
        }
        return pattern.matcher(String.valueOf(c)).matches();
    }

    public static String getOrderRepresentation(Send send) {
        return send.getOriginalSendType() + " " + send.getOrderNumber();
    }

    public static String getGeneralizedOrderType(OrderInfo orderInfo) {
        if (orderInfo.isH005AndHigher()) {
            return BTFTranslator.convertToString(orderInfo.getService());
        }
        if (orderInfo.getFileFormat() != null) {
            return orderInfo.getFileFormat().getValue();
        }
        if (orderInfo.getOrderType() != null) {
            return orderInfo.getOrderType().getValue();
        }
        return null;
    }

    public static void writePerformanceLogStartTime(BLLogger logger, Class<?> c, String logInfo, long startTime) {
        if (PreferenceUtil.logPerformance()) {
            Util.writePerformanceLog(logger, c, logInfo, System.currentTimeMillis() - startTime);
        }
    }

    public static void writePerformanceLogTotalTime(BLLogger logger, Class<?> c, String logInfo, long totalTime) {
        if (PreferenceUtil.logPerformance()) {
            Util.writePerformanceLog(logger, c, logInfo, totalTime);
        }
    }

    private static void writePerformanceLog(BLLogger logger, Class<?> c, String logInfo, long totalTime) {
        String sb = "PERFORMANCE-INFO from " + c.getName() + ": " + logInfo + " took " + totalTime + " ms.";
        logger.logInfo(sb);
    }

    public static void writeCMStatisticLog(BLLogger logger) {
        if (PreferenceUtil.logPerformance()) {
            int countStatements = CmStatement.findTotalCount();
            int countBookings = CmBooking.findTotalCount();
            String sb = "STATISTICS-INFO: countStatements = " + countStatements + " countBookings = " + countBookings;
            logger.logInfo(sb);
        }
    }

    private static void checkControlSum(BigDecimal givenSum, BigDecimal calculatedSum, Locale locale) throws KnownFormatException {
        if (givenSum != null && givenSum.compareTo(calculatedSum) != 0) {
            String text = MessageFormat.format(GeneralTexts.get((Locale)locale).WRONG_CONTROL_SUM, givenSum, calculatedSum);
            throw new KnownFormatException(text);
        }
    }

    private static void checkPaymentNumber(long givenNumber, long calculatedNumber, Locale locale) throws KnownFormatException {
        if (givenNumber > 0L && givenNumber != calculatedNumber) {
            String text = MessageFormat.format(GeneralTexts.get((Locale)locale).WRONG_NUMBER_OF_PAYMENTS, givenNumber, calculatedNumber);
            throw new KnownFormatException(text);
        }
    }

    public static SigningInfo parseSEPACreditFile(InputStream in, BankSettings bank, CheckServiceLevel checkServiceLevel, CheckLocalInstruments checkLocalInstruments, Locale locale) throws DisplayFileException, KnownFormatException {
        return Util.parseSEPACreditFile(in, bank, checkServiceLevel, checkLocalInstruments, null, locale);
    }

    public static SigningInfo parseSEPACreditFile(InputStream in, BankSettings bank, CheckServiceLevel checkServiceLevel, CheckLocalInstruments checkLocalInstruments, CheckSplitting checkSplitting, Locale locale) throws DisplayFileException, KnownFormatException {
        Currency currency;
        String serviceLevel;
        boolean xmlPrefixes;
        CCTTicketWrapper message;
        try {
            SEPACreditDisplayMessageGenerator gen = new SEPACreditDisplayMessageGenerator(true);
            message = gen.getMessage(in);
            xmlPrefixes = gen.hasXmlPrefixes();
        }
        catch (Exception e) {
            throw new DisplayFileException("Error generating the display file of SEPA credit file!", e);
        }
        BigDecimal totalAmount = message.getTotalAmount();
        Util.checkControlSum(message.getControlSum(), totalAmount, locale);
        long calculatedNumberOfTxs = message.getTotalNumberOfPayments();
        Util.checkPaymentNumber(message.getNumberOfTxs(), calculatedNumberOfTxs, locale);
        String[] serviceLevels = message.getServiceLevels();
        if (serviceLevels.length == 1 && (serviceLevel = StringUtils.checkNullAndTrim(serviceLevels[0])).length() > 0) {
            checkServiceLevel.checkServiceLevel(serviceLevel);
        }
        if (checkLocalInstruments != null) {
            checkLocalInstruments.checkLocalInstruments(message);
        }
        if (checkSplitting != null) {
            checkSplitting.checkSplitting(bank, calculatedNumberOfTxs, locale);
        }
        boolean hasUniqueCurrency = true;
        String currencyCode = null;
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (CCTTicketI singleTicket : message.getSingleTickets()) {
            Util.checkControlSum(singleTicket.getGivenCtrlSum(), singleTicket.getCtrlSum(), locale);
            Util.checkPaymentNumber(singleTicket.getGivenNumberOfPayments(), singleTicket.getNumberOfPayments(), locale);
            if (!hasUniqueCurrency || !(singleTicket instanceof de.businesslogics.format.sepa.CCTSingleTicket)) continue;
            de.businesslogics.format.sepa.CCTSingleTicket ticket = (de.businesslogics.format.sepa.CCTSingleTicket)singleTicket;
            if (!ticket.hasUniqueCurrency()) {
                hasUniqueCurrency = false;
            } else {
                String otherCurrencyCode;
                String string = otherCurrencyCode = ticket.getCurrency() != null ? ticket.getCurrency().getCurrencyCode() : "EUR";
                if (currencyCode == null) {
                    currencyCode = otherCurrencyCode;
                } else if (!currencyCode.equals(otherCurrencyCode)) {
                    hasUniqueCurrency = false;
                }
            }
            if (bank == null) continue;
            Currency accountCurrency = ticket.getDebitorAccountCcy();
            Account account = Account.findSEPAAccount(bank, ticket.getDebitorAccount(), accountCurrency != null ? accountCurrency.getCurrencyCode() : null, currencyCode);
            if (account == null || accounts.contains(account)) continue;
            accounts.add(account);
        }
        Currency currency2 = currency = hasUniqueCurrency ? Currency.getInstance(currencyCode) : null;
        if (currency == null) {
            totalAmount = null;
        }
        SigningInfo info = new SigningInfo(message, totalAmount, currency, message.containsSalaryPayments());
        info.setAccounts(accounts);
        info.setAdditionalFileInfoLabel(GeneralTexts.get((Locale)locale).SCHEME);
        info.setAdditionalFileInfo(Util.getScheme(message.getNameSpace()));
        if (xmlPrefixes) {
            info.setWarning(Messages.getString("SEPADisplayFileHandler.xmlPrefixes", new Object[0]));
        }
        info.setMessageId(message.getMessageIdentification());
        info.setNumberOfTxs((int)calculatedNumberOfTxs);
        return info;
    }

    public static SigningInfo parseSEPADebitFile(InputStream in, BankSettings bank, CheckDebitType checkDebitType, Locale locale) throws DisplayFileException, KnownFormatException {
        Currency currency;
        boolean xmlPrefixes;
        Pain00800201Ticket message;
        try {
            SEPADebitDisplayMessageGenerator gen = new SEPADebitDisplayMessageGenerator(true, true);
            message = gen.getMessage(in);
            xmlPrefixes = gen.hasXmlPrefixes();
        }
        catch (Exception e) {
            throw new DisplayFileException("Error generating the display file of SEPA debit file!", e);
        }
        BigDecimal totalAmount = message.getTotalAmount();
        Util.checkControlSum(message.getControlSum(), totalAmount, locale);
        long calculatedNumberOfTxs = message.getTotalNumberOfPayments();
        Util.checkPaymentNumber(message.getNumberOfTxs(), calculatedNumberOfTxs, locale);
        if (!message.isDebitTypeUnique()) {
            throw new KnownFormatException(Messages.getString("SEPADisplayFileHandler.nonUniqueDebitType", new Object[0]));
        }
        if (checkDebitType != null) {
            checkDebitType.checkDebitType(message.getDebitType());
        }
        boolean hasUniqueCurrency = true;
        String currencyCode = null;
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (Pain00800201PmtInfTicket singleTicket : message.getSingleTickets()) {
            Account account;
            Util.checkControlSum(singleTicket.getGivenCtrlSum(), singleTicket.getCtrlSum(), locale);
            Util.checkPaymentNumber(singleTicket.getGivenNumberOfPayments(), singleTicket.getNumberOfPayments(), locale);
            if (hasUniqueCurrency) {
                if (!singleTicket.hasUniqueCurrency()) {
                    hasUniqueCurrency = false;
                } else {
                    String otherCurrencyCode;
                    String string = otherCurrencyCode = singleTicket.getCurrency() != null ? singleTicket.getCurrency().getCurrencyCode() : "EUR";
                    if (currencyCode == null) {
                        currencyCode = otherCurrencyCode;
                    } else if (!currencyCode.equals(otherCurrencyCode)) {
                        hasUniqueCurrency = false;
                    }
                }
            }
            if (bank == null || (account = Account.findSEPAAccount(bank, singleTicket.getCreditorAccount(), singleTicket.getCreditorAccountCurrency(), currencyCode)) == null || accounts.contains(account)) continue;
            accounts.add(account);
        }
        Currency currency2 = currency = hasUniqueCurrency ? Currency.getInstance(currencyCode) : null;
        if (currency == null) {
            totalAmount = null;
        }
        SigningInfo info = new SigningInfo((DisplayMessage)message, totalAmount, currency);
        info.setAccounts(accounts);
        info.setAdditionalFileInfoLabel(GeneralTexts.get((Locale)locale).SCHEME);
        info.setAdditionalFileInfo(Util.getScheme(message.getNameSpace()));
        if (xmlPrefixes) {
            info.setWarning(Messages.getString("SEPADisplayFileHandler.xmlPrefixes", new Object[0]));
        }
        info.setMessageId(message.getMessageIdentification());
        info.setNumberOfTxs((int)calculatedNumberOfTxs);
        return info;
    }

    public static SigningInfo getSigningInfoSEPACreditContainerFile(CCCTicket ccc, CCCDisplayMessageGenerator gen, BankSettings bank) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        boolean hasUniqueCurrency = true;
        Currency currency = null;
        BigDecimal totalAmount = BigDecimal.ZERO;
        long totalNumberOfTxs = 0L;
        for (CCCSingleTicket container : ccc.getSingleTickets()) {
            totalAmount = totalAmount.add(container.getTotalAmount());
            totalNumberOfTxs += container.getTotalNumberOfPayments();
            for (CCTSingleTicket singleTicket : container.getSingleTickets()) {
                Account account;
                if (!hasUniqueCurrency) continue;
                Currency accountCurrency = singleTicket.getDebitorAccountCcy();
                if (currency == null) {
                    currency = accountCurrency;
                    if (currency == null) {
                        currency = Currency.getInstance("EUR");
                    }
                } else if (accountCurrency != null && !currency.equals(accountCurrency)) {
                    hasUniqueCurrency = false;
                    currency = null;
                }
                if (bank == null || (account = Account.findSEPAAccount(bank, singleTicket.getDebitorAccount(), accountCurrency != null ? accountCurrency.getCurrencyCode() : null, currency != null ? currency.getCurrencyCode() : null)) == null || accounts.contains(account)) continue;
                accounts.add(account);
            }
        }
        SigningInfo info = new SigningInfo(gen.getMessage(), totalAmount, currency, gen.containsSalary());
        info.setAccounts(accounts);
        info.setNumberOfTxs((int)totalNumberOfTxs);
        return info;
    }

    public static SigningInfo praseSEPACreditContainerFile(InputStream in, BankSettings bank) throws DisplayFileException {
        CCCTicket ccc;
        CCCDisplayMessageGenerator gen = new CCCDisplayMessageGenerator();
        try {
            ccc = (CCCTicket)gen.getMessage(in);
            if (ccc == null) {
                throw new DisplayFileException("No ticket build for file");
            }
        }
        catch (Exception io) {
            throw new DisplayFileException("Error generating the display file of SEPA credit container file!", io);
        }
        return Util.getSigningInfoSEPACreditContainerFile(ccc, gen, bank);
    }

    public static SigningInfo getSigningInfoSEPADebitContainerFile(CDxContainerTicket cdc, CDxContainerDisplayMessageGenerator gen, BankSettings bank) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        boolean hasUniqueCurrency = true;
        Currency currency = null;
        BigDecimal totalAmount = BigDecimal.ZERO;
        long totalNumberOfTxs = 0L;
        for (CDxContainerSingleTicket container : cdc.getSingleTickets()) {
            totalAmount = totalAmount.add(container.getTotalAmount());
            totalNumberOfTxs += container.getTotalNumberOfPayments();
            for (CDxSingleTicket singleTicket : container.getSingleTickets()) {
                Account account;
                if (!hasUniqueCurrency) continue;
                Currency accountCurrency = singleTicket.getCreditorAccountCcy();
                if (currency == null) {
                    currency = accountCurrency;
                    if (currency == null) {
                        currency = Currency.getInstance("EUR");
                    }
                } else if (accountCurrency != null && !currency.equals(accountCurrency)) {
                    hasUniqueCurrency = false;
                    currency = null;
                }
                if (bank == null || (account = Account.findSEPAAccount(bank, singleTicket.getCreditorAccount(), accountCurrency != null ? accountCurrency.getCurrencyCode() : null, currency != null ? currency.getCurrencyCode() : null)) == null || accounts.contains(account)) continue;
                accounts.add(account);
            }
        }
        SigningInfo info = new SigningInfo((DisplayMessage)gen.getMessage(), totalAmount, currency);
        info.setAccounts(accounts);
        info.setNumberOfTxs((int)totalNumberOfTxs);
        return info;
    }

    public static SigningInfo parseSEPADebitContainerFile(InputStream in, BankSettings bank) throws DisplayFileException {
        CDxContainerTicket cdc;
        CDxContainerDisplayMessageGenerator gen = new CDxContainerDisplayMessageGenerator();
        try {
            cdc = (CDxContainerTicket)gen.getMessage(in);
            if (cdc == null) {
                throw new DisplayFileException("No ticket build for file");
            }
        }
        catch (Exception e) {
            throw new DisplayFileException("Error generating the display file of SEPA debit container file!", e);
        }
        return Util.getSigningInfoSEPADebitContainerFile(cdc, gen, bank);
    }

    private static String getScheme(String nameSpace) {
        if (nameSpace != null) {
            int lastPos = nameSpace.lastIndexOf("pain");
            if (lastPos >= 0) {
                return nameSpace.substring(lastPos);
            }
            return nameSpace;
        }
        return null;
    }

    public static String getDisplayMessage(Send send, Locale locale) throws Exception {
        DisplayMessage message;
        String ticket = "";
        DisplayMessageGenerator generator = send.getPmtType() != null ? Util.getDisplayMessageGenerator(send.getPmtType()) : Util.getDisplayMessageGenerator(send.getOriginalSendType());
        if (generator != null && (message = generator.getMessage(EncryptData.getInstance().openInputStream(WorkspaceFileSystem.getFile(send.getFile())))) != null) {
            StringBuilder ticketBuilder = new StringBuilder();
            message.appendText(locale, ticketBuilder);
            ticket = ticketBuilder.toString();
        }
        return ticket;
    }

    public static DisplayMessageGenerator getDisplayMessageGenerator(PaymentTransferType.PmtType pmtType) {
        return Util.getDisplayMessageGenerator(pmtType.getHandlerKey());
    }

    public static DisplayMessageGenerator getDisplayMessageGenerator(String orderTypeOrBTF) {
        DisplayMessageGenerator displayMessageGenerator = DispatchNote.findGenerator(orderTypeOrBTF);
        if (displayMessageGenerator == null) {
            displayMessageGenerator = switch (orderTypeOrBTF) {
                case "AZV", "XCT:DE_dtazv" -> new DTAZVGenerator();
                case "C1C", "SDD:BIL:0C1C_pain.008_XML", "C1S", "SDD:BIL:0C1S_pain.008_SVC", "C1X", "SDD:BIL:0X1X_pain.008", "C2C", "SDD:DE:B2B_pain.008_XML", "C2S", "SDD:DE:B2B_pain.008_SVC", "C2X", "SDD:DE:0C2X_pain.008", "CDC", "SDD:DE:COR_pain.008_XML", "CDS", "SDD:DE:COR_pain.008_SVC", "CDX", "SDD:DE:0CDX_pain.008" -> new CDxContainerDisplayMessageGenerator();
                case "CCC", "SCT:DE_pain.001_XML", "CCS", "SCT:DE_pain.001_SVC", "CCX", "SCT:DE:0CCX_pain.001" -> new CCCDisplayMessageGenerator();
                case "CDD", "CDB", "SDD::B2B_pain.008", "SDD::COR_pain.008", "pain.008.001.01.sdd", "pain.008.001.01.sbb" -> new CDxDisplayMessageGenerator();
                case "CCT", "CCU", "CIP", "XCT", "XE2", "SCT_pain.001", "XCT:DE:URG_pain.001", "SCI:DE_pain.001", "pain.001.001.02.sct", "pain.001.001.03.sct" -> new CCTDisplayMessageGenerator();
                case "C55", "XCT:DE_pain.001", "SDD:DE_camt.055" -> new Camt055DisplayMessageGenerator();
                case "RFT", "RFT_mt101" -> new MT101Generator();
                case "XZZ", "XZS" -> new XZVDisplayMessageGenerator();
                case "THM", "MCT:AT:THM_pain.001_XML", "MCT:AT:THMVOI_pain.001_XML", "MCT:AT:THMINSTVOI_pain.001_XML" -> new ATTHMDisplayMessageGenerator();
                default -> new BinaryGenerator();
            };
        }
        return displayMessageGenerator;
    }

    private Util() {
    }

    public static interface CheckServiceLevel {
        public void checkServiceLevel(String var1) throws KnownFormatException;
    }

    public static interface CheckLocalInstruments {
        public void checkLocalInstruments(CCTTicketWrapper var1) throws KnownFormatException;
    }

    public static interface CheckSplitting {
        public void checkSplitting(BankSettings var1, long var2, Locale var4) throws KnownFormatException;
    }

    public static interface CheckDebitType {
        public void checkDebitType(String var1) throws KnownFormatException;
    }

    public static interface CheckTransferType {
        public void checkTransferType(String var1, BankSettings var2, File var3, Locale var4) throws WrongTransferTypeException;
    }
}

