/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.SendParameterUtil;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserEffectivePermission;
import de.businesslogics.banking.database.vo.UserPermission;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Junction;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.Update;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UserEffectivePermissions {
    public static <T> void addUserEffectivePermissions(User user, Query<T> query, boolean hideConfidences) {
        List<UserEffectivePermission> userEffectivePermissions = UserEffectivePermission.getPermissions(user);
        HashMap<PaymentTransferType.PmtType, HashSet> map = new HashMap<PaymentTransferType.PmtType, HashSet>();
        for (UserEffectivePermission userEffectivePermission : userEffectivePermissions) {
            map.computeIfAbsent(userEffectivePermission.getPmtType(), k -> new HashSet()).add(userEffectivePermission.getAccount());
        }
        if (hideConfidences) {
            map.remove((Object)PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER);
            map.remove((Object)PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER);
        }
        HashMap<HashSet, HashSet> map2 = new HashMap<HashSet, HashSet>();
        for (Map.Entry entry : map.entrySet()) {
            map2.computeIfAbsent((HashSet)entry.getValue(), k -> new HashSet()).add((PaymentTransferType.PmtType)((Object)entry.getKey()));
        }
        Junction junction = Expr.disjunction(query);
        junction.add(Expr.isNull((String)"account"));
        for (Map.Entry entry : map2.entrySet()) {
            Expression accounts = Expr.in((String)"account", (Collection)((Collection)entry.getKey()));
            Expression pmtTypes = Expr.in((String)"pmtType", (Collection)((Collection)entry.getValue()));
            junction.add(Expr.and((Expression)accounts, (Expression)pmtTypes));
        }
        junction.endJunction();
        query.where().add((Expression)junction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePermissions(BankUser bankUser) {
        BankSettings bank = bankUser.getBank();
        boolean useBTF = BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion());
        String countryCode = bank.getCountryCode();
        if (countryCode == null) {
            countryCode = "DE";
        }
        try (Transaction transaction = DB.beginTransaction();){
            for (Account account : Account.findAccountsForBank(bank)) {
                UserEffectivePermissions.updatePermissions(bank, account, bankUser, useBTF, countryCode);
            }
            DB.commitTransaction();
        }
        finally {
            DB.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePermissions(BankSettings bank) {
        boolean useBTF = BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion());
        String countryCode = bank.getCountryCode();
        if (countryCode == null) {
            countryCode = "DE";
        }
        try (Transaction transaction = DB.beginTransaction();){
            for (Account account : Account.findAccountsForBank(bank)) {
                for (BankUser bankUser : BankUser.findActiveBankUsersForBank(bank)) {
                    UserEffectivePermissions.updatePermissions(bank, account, bankUser, useBTF, countryCode);
                }
            }
            DB.commitTransaction();
        }
        finally {
            DB.endTransaction();
        }
    }

    private static void updatePermissions(BankSettings bank, Account account, BankUser bankUser, boolean useBTF, String countryCode) {
        AccountPermission accountPermission = AccountPermission.findAccountPermissionForBank(bankUser, account);
        if (accountPermission == null) {
            Update<UserEffectivePermission> delete = DB.createUpdate(UserEffectivePermission.class, "DELETE FROM UserEffectivePermission WHERE bankUser=:bankUser and account=:account");
            delete.setParameter("bankUser", (Object)bankUser.getId());
            delete.setParameter("account", (Object)account.getId());
            delete.execute();
            return;
        }
        Map<PaymentTransferType.PmtType, UserEffectivePermission> map = UserEffectivePermission.getPermissions(bankUser, account);
        Map<PaymentTransferType.PmtType, PaymentTransferType> transferTypes = PaymentTransferType.findMapByBank(bank);
        for (PaymentTransferType.PmtType pmtType : PaymentTransferType.PmtType.values()) {
            String btfOrOrderType = null;
            if (transferTypes.get((Object)pmtType) == null) {
                btfOrOrderType = useBTF ? SendParameterUtil.getDefaultBTF(pmtType, countryCode) : SendParameterUtil.getDefaultOrderType(pmtType, countryCode);
            } else {
                PaymentTransferType type = transferTypes.get((Object)pmtType);
                btfOrOrderType = useBTF ? type.getBtf() : type.getOrderType();
            }
            UserEffectivePermission userEffectivePermission = map.get((Object)pmtType);
            if (useBTF && UserPermission.hasPermissionForFileFormat(bankUser, OrderType.TransferType.SEND, btfOrOrderType) || !useBTF && UserPermission.hasPermissionForOrderType(bankUser, OrderType.TransferType.SEND, btfOrOrderType)) {
                if (userEffectivePermission != null) continue;
                UserEffectivePermission effectivePermission = new UserEffectivePermission();
                effectivePermission.setAccount(account);
                effectivePermission.setPmtType(pmtType);
                effectivePermission.setBankUser(bankUser);
                DB.save(effectivePermission);
                continue;
            }
            if (userEffectivePermission == null) continue;
            DB.delete(userEffectivePermission);
        }
    }
}

