/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class UserAPI {
    public static List<BankSettings> resetUser(User operatingUser, User userToReset, byte[] newEncryptionKey, BLLogger blLogger, BLLogger adminLogger, LockUserInBanks lockUser, boolean reset2factor) {
        List<BankSettings> toReturn = Collections.emptyList();
        File keyDirectory = null;
        try (Transaction t = DB.beginTransaction();){
            if (!userToReset.isLocalUser()) {
                if (userToReset.getKeyDirectory() != null) {
                    keyDirectory = new File(userToReset.getKeyDirectory());
                }
                if (lockUser != null & BankUser.hasAnySignature(userToReset) && (toReturn = lockUser.lockUserInBanks(userToReset)) == null) {
                    toReturn = Collections.emptyList();
                }
                BankUser.resetAllBanks(userToReset);
                if (!userToReset.isToBeImported()) {
                    userToReset.setSecurityMedium(User.SecurityMedium.SOFTWARE);
                }
                userToReset.setKeyDirectory(null);
            }
            userToReset.cleanLoginError(false);
            userToReset.cleanSignatureError();
            userToReset.setEncryptionKey(newEncryptionKey);
            userToReset.resetPassword();
            userToReset.setProxyPassword(null);
            userToReset.save();
            if (reset2factor) {
                UserAPI.deleteAllTwoFactorTokensForUser(userToReset, operatingUser, adminLogger);
            }
            t.commit();
            new AdminLogger(adminLogger).logUserReset(operatingUser, userToReset);
        }
        if (!(keyDirectory == null || "DATABASE".equals(keyDirectory) || "DATABASE_MIGRATION_NEEDED".equals(keyDirectory) || keyDirectory.renameTo(new File(keyDirectory.getParent(), "BACKUP_" + userToReset.getName())))) {
            blLogger.logWarning("Failed to create a backup for the key directory of the user " + userToReset.getName());
        }
        return toReturn;
    }

    public static boolean deleteAllTwoFactorTokensForUser(User keyUser, User operator, BLLogger adminLogger) {
        if (keyUser == null) {
            return false;
        }
        boolean success = true;
        for (Yubikey token : Yubikey.findForUser(keyUser, new Yubikey.SecurityType[0]).findList()) {
            success &= UserAPI.deleteTwoFactorTokenForUser(token, keyUser, operator, adminLogger);
        }
        return success;
    }

    public static boolean deleteTwoFactorTokenForUser(int tokenId, User keyUser, User operator, BLLogger adminLogger) {
        if (keyUser == null) {
            return false;
        }
        return UserAPI.deleteTwoFactorTokenForUser(Yubikey.findForIdAndUser(tokenId, keyUser), keyUser, operator, adminLogger);
    }

    public static boolean deleteTwoFactorTokenForUser(Yubikey token, User keyUser, User operator, BLLogger adminLogger) {
        if (token == null || keyUser == null) {
            return false;
        }
        token.delete();
        if (operator != null) {
            new AdminLogger(adminLogger).logYubikeyDeleted(operator, keyUser, token);
        }
        return true;
    }

    public static boolean hasTwoFactorToken(User keyUser) {
        if (keyUser == null) {
            return false;
        }
        return Yubikey.findForUser(keyUser, new Yubikey.SecurityType[0]).findList().size() > 0;
    }

    public static interface LockUserInBanks {
        public List<BankSettings> lockUserInBanks(User var1);
    }
}

