/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.util.Currency;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;

public final class SigningInfo
implements DisplayMessage {
    private static final long serialVersionUID = 7533670060882611371L;
    private final DisplayMessage message;
    private final BigDecimal amount;
    private final Currency currency;
    private final boolean containsSalaryPayments;
    private byte[] digest;
    private String warning;
    private List<Account> accounts;
    private String additionalFileInfoLabel;
    private String additionalFileInfo;
    private String messageId;
    private int numberOfTxs;
    private String additionalOrderInfo;
    private File additionalDocument;
    private PaymentTransferType.PmtType pmtType;

    public SigningInfo(DisplayMessage message, BigDecimal amount) {
        this(message, amount, Currency.getInstance("EUR"), false);
    }

    public SigningInfo(DisplayMessage message, BigDecimal amount, Currency currency) {
        this(message, amount, currency, false);
    }

    public SigningInfo(DisplayMessage message, BigDecimal amount, boolean containsSalaryPayments) {
        this(message, amount, Currency.getInstance("EUR"), containsSalaryPayments);
    }

    public SigningInfo(DisplayMessage message, BigDecimal amount, Currency currency, boolean containsSalaryPayments) {
        this.message = message;
        this.amount = amount;
        this.currency = currency;
        this.containsSalaryPayments = containsSalaryPayments;
    }

    public SigningInfo(DisplayMessage message) {
        this(message, null, null, false);
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this.pmtType;
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this.pmtType = pmtType;
    }

    public boolean containsSalaryPayments() {
        return this.containsSalaryPayments;
    }

    @Override
    public void appendText(Locale locale, StringBuilder buffer) {
        this.message.appendText(locale, buffer);
    }

    public String getText() {
        return this.getText(Locale.getDefault());
    }

    public String getText(Locale locale) {
        StringBuilder b = new StringBuilder();
        this.message.appendText(locale, b);
        return b.toString();
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public String getAdditionalFileInfoLabel() {
        return this.additionalFileInfoLabel;
    }

    public void setAdditionalFileInfoLabel(String additionalFileInfoLabel) {
        this.additionalFileInfoLabel = additionalFileInfoLabel;
    }

    public String getAdditionalFileInfo() {
        return this.additionalFileInfo;
    }

    public void setAdditionalFileInfo(String additionalFileInfo) {
        this.additionalFileInfo = additionalFileInfo;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public int getNumberOfTxs() {
        return this.numberOfTxs;
    }

    public void setNumberOfTxs(int numberOfTxs) {
        this.numberOfTxs = numberOfTxs;
    }

    public String getAdditionalOrderInfo() {
        return this.additionalOrderInfo;
    }

    public void setAdditionalOrderInfo(String additionalOrderInfo) {
        this.additionalOrderInfo = additionalOrderInfo;
    }

    public File getAdditionalDocument() {
        return this.additionalDocument;
    }

    public void setAdditionalDocument(File additionalDocument) {
        this.additionalDocument = additionalDocument;
    }

    public DisplayMessage getDisplayMessage() {
        return this.message;
    }
}

