/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.swift.mt940.CMUtil;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class SignedPaymentsUtil {
    private static final String SEMICOLON = ";";
    private static final long ONE_DAY = 86400000L;
    private static final long THIRTY_DAYS = 2592000000L;
    public static final String CREATE_SIGNED_PAYMENTS = "onlyAllSignedPayments";

    public static boolean connectPaymentsWithBooking() {
        Preference preference = Preference.getPreference(Preference.ApplicationId.CM, "connectPaymentsWithBooking");
        if (preference != null) {
            return Boolean.parseBoolean(preference.getValue());
        }
        return true;
    }

    public static boolean createVirtualStatements() {
        Preference preference = Preference.getPreference(Preference.ApplicationId.CM, "createVirtualStatements");
        if (preference != null) {
            return Boolean.parseBoolean(preference.getValue());
        }
        return true;
    }

    public static boolean createSignedPayments() {
        Preference preference = Preference.getPreference(Preference.ApplicationId.PAYMENTS, CREATE_SIGNED_PAYMENTS);
        if (preference != null) {
            return Boolean.parseBoolean(preference.getValue());
        }
        return SignedPaymentsUtil.createSignedPaymentsDefault();
    }

    public static boolean createSignedPaymentsDefault() {
        return false;
    }

    public static boolean doTimeCheck() {
        return true;
    }

    public static Send findPossibleSendItem(CmBooking booking, String msgId, BLLogger logger) {
        List<Send> sendItems = SignedPaymentsUtil.getSendItems(booking, msgId, logger);
        if (sendItems != null) {
            int countSendItems = sendItems.size();
            if (countSendItems == 1) {
                return sendItems.get(0);
            }
            if (countSendItems > 1) {
                logger.logWarning("Found " + countSendItems + " send orders with msgId '" + msgId + "' for a booking. No unique assignment possible!");
            }
        }
        return null;
    }

    private static List<Send> getSendItems(CmBooking booking, String msgId, BLLogger logger) {
        if (SignedPaymentsUtil.doTimeCheck()) {
            Date bookingDate = booking.getBookingDate();
            if (bookingDate != null) {
                Timestamp oldestPossibleSendTime = new Timestamp(bookingDate.getTime() - 2592000000L);
                Timestamp newestPossibleSendTime = new Timestamp(bookingDate.getTime() + 86400000L);
                return Send.findByMessageId(booking.getAccount().getBank(), msgId, oldestPossibleSendTime, newestPossibleSendTime);
            }
            logger.logWarning("Booking with msgId '" + msgId + "' has no booking date. No time check possible!");
        }
        return Send.findByMessageId(booking.getAccount().getBank(), msgId);
    }

    public static List<CmBooking> findPossibleBookings(String msgId, Account account, long sendTime, BLLogger logger) {
        if (SignedPaymentsUtil.doTimeCheck()) {
            Date oldestPossibleStatementDate = new Date(sendTime - 86400000L);
            Date newestPossibleStatementDate = new Date(sendTime + 2592000000L);
            return CmBooking.findByMsgId(msgId, account, oldestPossibleStatementDate, newestPossibleStatementDate);
        }
        return CmBooking.findByMsgId(msgId, account);
    }

    public static void connectSignedPaymentsToBooking(CmBooking booking, Send sendItem, boolean createVirtualStatements) {
        String pmtInfId = StringUtils.checkNullAndTrim(booking.getPmtInfId());
        if (pmtInfId.length() > 0) {
            String endToEndId = StringUtils.checkNullAndTrim(booking.getEndToEndId());
            if (endToEndId.length() > 0) {
                int countPayments = SignedPayment.setBookingId(booking, sendItem, pmtInfId, endToEndId);
                if (countPayments > 0) {
                    booking.setSignedPayments(Boolean.TRUE);
                }
                DB.update(booking);
            } else if (CMUtil.isCollectiveBooking(booking.getGvc())) {
                boolean hasSalaryPayments = sendItem.isWithSalaries();
                int countPayments = SignedPayment.setBookingId(booking, sendItem, pmtInfId);
                if (countPayments > 0) {
                    booking.setSignedPayments(Boolean.TRUE);
                    if (createVirtualStatements && !hasSalaryPayments) {
                        booking.setCollective(true);
                    }
                    DB.update(booking);
                    if (createVirtualStatements && !hasSalaryPayments) {
                        SignedPaymentsUtil.createVirtualStatement(sendItem, pmtInfId, booking);
                    }
                }
            }
            int countSignedPayments = SignedPayment.findCountBySend(sendItem);
            int countBookedSignedPayments = SignedPayment.findCountBookedBySend(sendItem);
            if (countBookedSignedPayments > 0) {
                if (countBookedSignedPayments == countSignedPayments) {
                    if (PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)sendItem.getPmtType())) {
                        sendItem.setSts("ACCP");
                    } else {
                        sendItem.setSts("ACSC");
                    }
                    DB.update(sendItem);
                } else if (!"PRJ".equals(sendItem.getSts())) {
                    sendItem.setSts("PBK");
                    DB.update(sendItem);
                }
            }
        }
    }

    private static void createVirtualStatement(Send sendItem, String pmtInfId, CmBooking parentBooking) {
        String uniqueId;
        Account account;
        CmStatement statement;
        List<SignedPayment> signedPayments = SignedPayment.findByPmtInfId(sendItem, pmtInfId);
        if (signedPayments != null && signedPayments.size() >= 1 && (statement = CmStatement.findByAccountAndUniqueId(account = signedPayments.get(0).getAccount(), uniqueId = sendItem.getId() + " " + pmtInfId)) == null) {
            statement = CmStatement.createStatement(uniqueId, CmStatement.Type.LOGICAL_PAYMENT_FILE, account);
            statement.setCreationDate(new Timestamp(System.currentTimeMillis()));
            statement.setReference1(pmtInfId);
            statement.setOriginalFilename(SignedPaymentsUtil.createOrderInfo(sendItem));
            BigDecimal amount = parentBooking.getAmount();
            if (amount.signum() < 0) {
                statement.setSumDebit(amount);
                statement.setCountDebit(signedPayments.size());
            } else {
                statement.setSumCredit(amount);
                statement.setCountCredit(signedPayments.size());
            }
            statement.setCurrency(parentBooking.getCurrency());
            DB.save(statement);
            BigDecimal balance = parentBooking.getBalance().subtract(parentBooking.getAmount());
            for (SignedPayment signedPayment : signedPayments) {
                CmBooking booking = new CmBooking();
                booking.setAccount(account);
                booking.setStatement(statement);
                SignedPaymentsUtil.setBookingData(signedPayment, booking, parentBooking, balance);
                balance = balance.add(booking.getAmount());
                DB.save(booking);
            }
        }
    }

    private static String createOrderInfo(Send sendItem) {
        StringBuilder sb = new StringBuilder();
        sb.append(sendItem.getId());
        sb.append(SEMICOLON);
        String transferType = sendItem.getOriginalSendType();
        if (transferType != null) {
            sb.append(transferType.trim());
        }
        sb.append(SEMICOLON);
        String orderNumber = sendItem.getOrderNumber();
        if (orderNumber != null) {
            sb.append(orderNumber.trim());
        }
        sb.append(SEMICOLON);
        PaymentTransferType.PmtType pmtType = sendItem.getPmtType();
        if (pmtType != null) {
            sb.append(pmtType.ordinal());
        }
        return sb.toString();
    }

    public static String getSendOrderName(Locale locale, String orderInfoString) {
        StringTokenizer st;
        if (orderInfoString != null && (st = new StringTokenizer(orderInfoString, SEMICOLON)).countTokens() == 4) {
            st.nextToken();
            String sendType = st.nextToken();
            String orderNumber = st.nextToken();
            try {
                int ordinal = Integer.parseInt(st.nextToken());
                PaymentTransferType.PmtType pmtType = PaymentTransferType.PmtType.values()[ordinal];
                return PaymentTypeUtil.getSendOrderName(locale, pmtType, sendType, orderNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private static void setBookingData(SignedPayment signedPayment, CmBooking booking, CmBooking parentBooking, BigDecimal balance) {
        booking.setParentBooking(parentBooking);
        booking.setCurrencyCode(signedPayment.getAmountCurrency());
        if (parentBooking.getAmount().signum() < 0) {
            booking.setAmount(signedPayment.getAmount().negate());
        } else {
            booking.setAmount(signedPayment.getAmount());
        }
        boolean isDirectDebit = !signedPayment.isCredit();
        booking.setDebit(isDirectDebit);
        booking.setCounterParty(signedPayment.getRecipient());
        booking.setPurposeOverview(signedPayment.getPurpose());
        booking.setPurpose(signedPayment.getPurpose());
        booking.setPmtInfId(signedPayment.getPmtInfId());
        booking.setEndToEndId(signedPayment.getReference());
        SEPAPaymentData paymentData = SignedPaymentsUtil.getSEPAPaymentData(signedPayment);
        if (paymentData != null) {
            booking.setLocalParty(paymentData.getOriginator());
            booking.setLocalPartyAccountNumber(paymentData.getOriginatorIban());
            booking.setLocalPartyBankCode(paymentData.getOriginatorBic());
            booking.setUltimateLocalParty(paymentData.getUltimateOriginator());
            if (isDirectDebit) {
                booking.setLocalPartyCreditorId(paymentData.getCreditorId());
                booking.setCounterPartyMandateReference(paymentData.getMandateId());
            }
            booking.setCounterPartyAccountNumber(paymentData.getRecipientIban());
            booking.setCounterPartyBankCode(paymentData.getRecipientBic());
            booking.setUltimateCounterParty(paymentData.getUltimateRecipient());
            booking.setPurposeCode(paymentData.getPurposeCode());
        }
        booking.setValueDate(parentBooking.getValueDate());
        booking.setBookingDate(parentBooking.getBookingDate());
        booking.setBalance(balance.add(booking.getAmount()));
    }

    private static SEPAPaymentData getSEPAPaymentData(SignedPayment signedPayment) {
        try {
            if (PaymentTransferType.FormatType.pain001.equals((Object)signedPayment.getPmtType().getFormatType())) {
                return GeneralSEPAExtractor.getPaymentFromCCT(new ByteArrayInputStream(signedPayment.getPaymentData()));
            }
            if (PaymentTransferType.FormatType.pain008.equals((Object)signedPayment.getPmtType().getFormatType())) {
                return GeneralSEPAExtractor.getDebitPayment(new ByteArrayInputStream(signedPayment.getPaymentData()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

