/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.DataToSign;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.bank.PropertiesKeys;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.bltransfer.ebics.client.KeyMgmt;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.KeyManagement;
import de.businesslogics.ebics.schema.GenericListElement;
import de.businesslogics.ebics.schema.ListElement;
import de.businesslogics.ebics.schema.orders.HPDProtocolParams;
import de.businesslogics.ebics.schema.orders.HPDResponseOrderData;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.schema.types.UserID;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.util.IProgressMonitorWrapper;
import de.businesslogics.zkasecurity.PasswordCallback;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;

public abstract class SignatureVersionChanger {
    private final BankUser bankUser;
    protected final BankSettings bankSettings;
    private final SignatureVersion newVersion;
    private final int sigKeyLength;
    private final int encKeyLength;
    private final int authKeyLength;
    private final boolean createCertificates;
    private DatabaseToken newToken;
    private final ArrayList<DataToSign> dts = new ArrayList();
    private KeyMgmt keyMgmt;
    private final EbicsWorker myWorker;
    private final boolean hasWorkerForOldProtocolVersion;
    private Boolean createCertsWithoutExpirationDate;

    public static List<SignatureVersion> getSignatureVersions(BankSettings settings) {
        ListElement signatureVersions = null;
        ProtocolVersion protocolVersion = BankUtils.getProtocolVersion(settings);
        if (ProtocolVersion.H002.equals(protocolVersion)) {
            signatureVersions = new GenericListElement<SignatureVersion>(SignatureVersion.class);
            signatureVersions.add((SignatureVersion)SignatureVersion.A004);
        } else {
            HPDProtocolParams pp;
            HPDResponseOrderData hpd = EbicsWorker.getHpdResponseOrderData(settings);
            if (hpd != null && (pp = hpd.getProtocolParams()) != null && (signatureVersions = pp.getVersion().getSignature()) != null) {
                signatureVersions.remove(SignatureVersion.A004);
            }
            if (signatureVersions == null) {
                signatureVersions = new GenericListElement<SignatureVersion>(SignatureVersion.class);
                signatureVersions.add((SignatureVersion)SignatureVersion.A005);
                signatureVersions.add(SignatureVersion.A006);
            }
            signatureVersions.sort((o1, o2) -> o1.getValue().compareTo(o2.getValue()) * -1);
        }
        return signatureVersions;
    }

    public void setCreateCertsWithoutExpirationDate(Boolean createCertsWithoutExpirationDate) {
        this.createCertsWithoutExpirationDate = createCertsWithoutExpirationDate;
    }

    public SignatureVersionChanger(BankUser bankUser, SignatureVersion newVersion, int sigKeyLength, int encKeyLength, int authKeyLength, ProtocolVersion protocolVersion) {
        this(bankUser, newVersion, sigKeyLength, encKeyLength, authKeyLength, protocolVersion, null);
    }

    public SignatureVersionChanger(BankUser bankUser, SignatureVersion newVersion, int sigKeyLength, int encKeyLength, int authKeyLength, ProtocolVersion protocolVersion, EbicsWorker worker) {
        this.bankUser = bankUser;
        this.bankSettings = bankUser.getBank();
        this.newVersion = newVersion;
        this.sigKeyLength = sigKeyLength;
        this.encKeyLength = encKeyLength;
        this.authKeyLength = authKeyLength;
        this.createCertificates = this.certificatesRequired(protocolVersion);
        this.createCertsWithoutExpirationDate = null;
        this.myWorker = worker;
        this.hasWorkerForOldProtocolVersion = this.myWorker != null ? this.myWorker.getProtocolVersion().compareTo(protocolVersion) < 0 : false;
    }

    public boolean hasWorker() {
        return this.myWorker != null;
    }

    protected boolean certificatesRequired(ProtocolVersion protocolVersion) {
        if (protocolVersion != null) {
            return BankUtils.isProtocolH005OrNewer(protocolVersion);
        }
        return false;
    }

    public void createNewKeys(IProgressMonitorWrapper monitor, EbicsWorker worker, boolean createDts) throws GeneralSecurityException, IOException, EbicsException {
        ProtocolVersion protocolVersion = this.myWorker != null ? this.myWorker.getProtocolVersion() : BankUtils.getProtocolVersion(this.bankSettings);
        if (protocolVersion == null) {
            throw new IOException("Could not get protocol version");
        }
        boolean useCertsWithoutExpirationDate = this.bankUser.getBank().useCertsWithoutExpirationDate();
        if (this.createCertsWithoutExpirationDate != null) {
            useCertsWithoutExpirationDate = this.createCertsWithoutExpirationDate;
        }
        this.newToken = DatabaseToken.createNewToken(this.bankSettings.getCustomerId(), this.bankUser.getDefaultUser(), PropertiesKeys.SignatureVersion.valueOf(this.newVersion.getValue()), this.sigKeyLength, this.encKeyLength, this.authKeyLength, this.createCertificates, useCertsWithoutExpirationDate, protocolVersion);
        if (!createDts) {
            return;
        }
        if (!this.bankSettings.isTransferSystem()) {
            if (ProtocolVersion.H003.compareTo(protocolVersion) > 0 || this.bankSettings.useHCA_PUB()) {
                byte[] hcaHash = SignatureHandler.getInstance(BankUtils.getSignatureVersion(this.bankUser)).getMessageDigest().digest(KeyManagement.buildHCA(protocolVersion, new PartnerID(this.bankSettings.getCustomerId()), new UserID(this.bankUser.getDefaultUser()), this.newToken.getAuthPubKey(), this.newToken.getAuthCerts(), this.newToken.getEncrPubKey(), this.newToken.getEncrCerts()));
                this.dts.add(new DataToSign(this.bankSettings, hcaHash, "HCA"));
                monitor.worked(1);
                byte[] pubHash = SignatureHandler.getInstance(BankUtils.getSignatureVersion(this.bankUser)).getMessageDigest().digest(KeyManagement.buildPUB(protocolVersion, new PartnerID(this.bankSettings.getCustomerId()), new UserID(this.bankUser.getDefaultUser()), this.newVersion, this.newToken.getSigPubKey(), this.newToken.getSigCerts()));
                this.dts.add(new DataToSign(this.bankSettings, pubHash, "PUB"));
                monitor.worked(1);
            } else {
                byte[] hcsHash = SignatureHandler.getInstance(BankUtils.getSignatureVersion(this.bankUser)).getMessageDigest().digest(KeyManagement.buildHCS(protocolVersion, new PartnerID(this.bankSettings.getCustomerId()), new UserID(this.bankUser.getDefaultUser()), this.newVersion, this.newToken.getSigPubKey(), this.newToken.getSigCerts(), this.newToken.getAuthPubKey(), this.newToken.getAuthCerts(), this.newToken.getEncrPubKey(), this.newToken.getEncrCerts()));
                this.dts.add(new DataToSign(this.bankSettings, hcsHash, "HCS"));
                monitor.worked(2);
            }
        } else {
            EbicsSession session = this.myWorker != null ? this.myWorker.getEbicsSession() : worker.getEbicsSession();
            this.keyMgmt = new KeyMgmt(session);
            List<KeyMgmt.SignInfo> signInfos = this.keyMgmt.fetchSignInfo(this.newVersion, this.newToken.getSigPubKey(), this.newToken.getSigCerts(), this.newToken.getAuthPubKey(), this.newToken.getAuthCerts(), this.newToken.getEncrPubKey(), this.newToken.getEncrCerts());
            monitor.worked(1);
            for (KeyMgmt.SignInfo signInfo : signInfos) {
                this.dts.add(new DataToSign(this.bankSettings, signInfo.getDigest(), signInfo.getOrderType()));
            }
            monitor.worked(1);
        }
    }

    public void changeSignatureVersion(PasswordCallback sigPasswordCallback, PasswordCallback loginPasswordCallback, EbicsWorker worker) throws Exception {
        worker = this.myWorker != null ? this.myWorker : worker;
        EbicsSession session = worker.getEbicsSession();
        if (!this.bankSettings.isTransferSystem()) {
            KeyManagement keyManagement = new KeyManagement(session);
            if (ProtocolVersion.H003.compareTo(BankUtils.getProtocolVersion(this.bankSettings)) > 0 || this.bankSettings.useHCA_PUB()) {
                keyManagement.sendHCA(this.newToken.getAuthPubKey(), this.newToken.getAuthCerts(), this.newToken.getEncrPubKey(), this.newToken.getEncrCerts());
                worker.setSecurityToken(this.newToken);
                worker.setPregeneratedSignatur(this.dts.get(1).getSignature());
                keyManagement.sendPUB(this.newVersion, this.newToken.getSigPubKey(), this.newToken.getSigCerts());
            } else {
                keyManagement.sendHCS(this.newVersion, this.newToken.getSigPubKey(), this.newToken.getSigCerts(), this.newToken.getAuthPubKey(), this.newToken.getAuthCerts(), this.newToken.getEncrPubKey(), this.newToken.getEncrCerts());
            }
        } else {
            if (this.keyMgmt == null) {
                this.keyMgmt = new KeyMgmt(session);
                this.keyMgmt.fetchSignInfo(this.newVersion, this.newToken.getSigPubKey(), this.newToken.getSigCerts(), this.newToken.getAuthPubKey(), this.newToken.getAuthCerts(), this.newToken.getEncrPubKey(), this.newToken.getEncrCerts());
            }
            byte[] digest = SignatureHandler.getInstance(BankUtils.getSignatureVersion(this.bankUser)).getMessageDigest().digest(this.keyMgmt.buildSignedRequest());
            this.addSignature(digest, sigPasswordCallback);
            this.keyMgmt.updateKeys();
        }
        this.newToken.saveSignatureKey(this.bankUser, sigPasswordCallback.getPassword());
        this.newToken.saveTransportKeys(this.bankUser, loginPasswordCallback.getPassword());
        this.newToken.saveLockUserSignature(this.bankUser);
        if (BankUser.UserState.KEY_CHANGE_REQUIRED.equals((Object)this.bankUser.getState())) {
            this.bankUser.setState(BankUser.UserState.READY);
        }
        this.bankUser.save();
        if (!this.hasWorkerForOldProtocolVersion) {
            this.bankSettings.save();
        }
    }

    public ArrayList<DataToSign> getDts() {
        return this.dts;
    }

    protected abstract void addSignature(byte[] var1, PasswordCallback var2) throws Exception;
}

