/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.Messages;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.format.sepa.CCTTicketWrapper;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.util.StringUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class SepaChecker
implements Util.CheckServiceLevel,
Util.CheckLocalInstruments,
Util.CheckDebitType {
    private final PaymentTransferType.PmtType pmtType;
    private final Locale locale;

    public SepaChecker(BankSettings bank, String transferType, Locale locale) {
        this(SendParameters.getPmtType(bank, transferType), locale);
    }

    public SepaChecker(PaymentTransferType.PmtType pmtType, Locale locale) {
        this.locale = locale;
        switch (pmtType) {
            case AUSTRIAN_FOREIGN: 
            case AUSTRIAN_POSTBAR_PAYMENT: 
            case AUSTRIAN_TAX_PAYMENT: 
            case AUSTRIAN_URGENT_TAX_PAYMENT: 
            case SEPA_B2B_DIRECT_DEBIT: 
            case SEPA_CONFIDENTAL_TRANSFER: 
            case SEPA_COR1_DIRECT_DEBIT: 
            case SEPA_CORE_DIRECT_DEBIT: 
            case SEPA_FOREIGN_CURRENCY_TRANSFER: 
            case SEPA_FOREIGN_TRANSFER: 
            case SEPA_INSTANT_TRANSFER: 
            case SEPA_NON_SEPA_COUNTRY_TRANSFER: 
            case SEPA_TRANSFER: 
            case SEPA_URGENT_CONFIDENTAL_TRANSFER: 
            case SEPA_URGENT_TRANSFER: 
            case SEPA_VIRTUAL_ACCOUNT_TRANSFER: 
            case SWISS_SEPA_TRANSFER: 
            case SEPA_FOREIGN_CHEQUE: 
            case AUSTRIAN_FOREIGN_SEPA_CHEQUE: {
                this.pmtType = pmtType;
                break;
            }
            default: {
                throw new RuntimeException("SepaChecker is not usable for PmtType: " + String.valueOf((Object)pmtType));
            }
        }
    }

    @Override
    public void checkDebitType(String debitType) throws KnownFormatException {
        SEPALocalInstrument expectedDebitType = switch (this.pmtType) {
            case PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT -> SEPALocalInstrument.B2B;
            case PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT -> SEPALocalInstrument.COR1;
            case PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT -> SEPALocalInstrument.CORE;
            default -> null;
        };
        if (expectedDebitType != null && !expectedDebitType.name().equals(debitType)) {
            String orderType = switch (debitType) {
                case "B2B" -> "CDB";
                case "COR1" -> "CD1";
                case "CORE" -> "CDD";
                default -> null;
            };
            if (orderType != null) {
                throw new KnownFormatException(MessageFormat.format(Messages.getString(this.locale, "SEPADisplayFileHandler.otherDebitType", new Object[0]), orderType));
            }
            throw new KnownFormatException(MessageFormat.format(Messages.getString(this.locale, "SEPADisplayFileHandler.unknownDebitType", new Object[0]), debitType));
        }
    }

    @Override
    public void checkLocalInstruments(CCTTicketWrapper message) throws KnownFormatException {
        Object[] localInstruments = message.getLocalInstruments();
        switch (this.pmtType) {
            case SEPA_TRANSFER: 
            case SEPA_URGENT_TRANSFER: {
                if (localInstruments.length == 1) {
                    if (!SEPALocalInstrument.INST.name().equals(localInstruments[0])) break;
                    throw new KnownFormatException(Messages.getString(this.locale, "SEPADisplayFileHandler.instantCreditFound", new Object[0]));
                }
                if (localInstruments.length <= 1) break;
                throw new KnownFormatException(MessageFormat.format(Messages.getString(this.locale, "SEPADisplayFileHandler.multipleLocalInstruments", new Object[0]), StringUtils.asString(localInstruments)));
            }
            case SEPA_INSTANT_TRANSFER: {
                if (localInstruments.length == 1) {
                    if (localInstruments[0] == null || localInstruments[0].isEmpty()) {
                        throw new KnownFormatException(Messages.getString(this.locale, "SEPADisplayFileHandler.missingLocalInstrumentINST", new Object[0]));
                    }
                    if (SEPALocalInstrument.INST.name().equals(localInstruments[0])) break;
                    throw new KnownFormatException(MessageFormat.format(Messages.getString(this.locale, "SEPADisplayFileHandler.invalidLocalInstrument", new Object[0]), localInstruments[0]));
                }
                if (localInstruments.length == 0) {
                    throw new KnownFormatException(Messages.getString(this.locale, "SEPADisplayFileHandler.missingLocalInstrumentINST", new Object[0]));
                }
                throw new KnownFormatException(MessageFormat.format(Messages.getString(this.locale, "SEPADisplayFileHandler.multipleLocalInstruments", new Object[0]), StringUtils.asString(localInstruments)));
            }
        }
    }

    @Override
    public void checkServiceLevel(String serviceLevel) throws KnownFormatException {
        switch (this.pmtType) {
            case SEPA_INSTANT_TRANSFER: 
            case SEPA_TRANSFER: {
                if (serviceLevel == null || serviceLevel.length() <= 0 || GeneralSEPAExtractor.SEPA.equals(serviceLevel)) break;
                if (GeneralSEPAExtractor.URGP.equals(serviceLevel)) {
                    throw new KnownFormatException(Messages.getString(this.locale, "SEPADisplayFileHandler.urgentCreditFound", new Object[0]));
                }
                throw new KnownFormatException(MessageFormat.format(Messages.getString(this.locale, "SEPADisplayFileHandler.unknownPaymentType", new Object[0]), serviceLevel));
            }
            case SEPA_URGENT_TRANSFER: {
                if (serviceLevel == null || serviceLevel.length() <= 0 || GeneralSEPAExtractor.URGP.equals(serviceLevel)) break;
                if (GeneralSEPAExtractor.SEPA.equals(serviceLevel)) {
                    throw new KnownFormatException(Messages.getString(this.locale, "SEPADisplayFileHandler.useServiceLevelURGP", new Object[0]));
                }
                throw new KnownFormatException(MessageFormat.format(Messages.getString(this.locale, "SEPADisplayFileHandler.unknownPaymentType", new Object[0]), serviceLevel));
            }
            case SEPA_FOREIGN_CHEQUE: 
            case AUSTRIAN_FOREIGN_SEPA_CHEQUE: {
                if (serviceLevel == null || serviceLevel.length() <= 0 || GeneralSEPAExtractor.NURG.equals(serviceLevel)) break;
                if (GeneralSEPAExtractor.SEPA.equals(serviceLevel)) {
                    throw new KnownFormatException(Messages.getString(this.locale, "SEPADisplayFileHandler.useServiceLevelNURG", new Object[0]));
                }
                throw new KnownFormatException(MessageFormat.format(Messages.getString(this.locale, "SEPADisplayFileHandler.unknownPaymentType", new Object[0]), serviceLevel));
            }
        }
    }

    public static String getExpectedServiceLevel(PaymentTransferType.PmtType pmtType) {
        return pmtType.getServiceLevel();
    }
}

