/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.SendFilter;
import java.util.Locale;

public class SendStateUtil {
    public static String getStateFilterText(PaymentFilter.State state, Locale locale) {
        switch (state) {
            case SENT: {
                return BankingApiMessages.getString(locale, "SendUtil.state.sent", new Object[0]);
            }
            case FINISHED_ERROR: {
                return BankingApiMessages.getString(locale, "GeneralMessages.error", new Object[0]);
            }
            case FINISHED_OK: {
                return BankingApiMessages.getString(locale, "SendUtil.state.finishedOk", new Object[0]);
            }
            case WAITING_IN_DS: {
                return BankingApiMessages.getString(locale, "SendUtil.state.waitingInDS", new Object[0]);
            }
            case CANCELED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.canceled", new Object[0]);
            }
            case ACSC_ACCP: {
                return BankingApiMessages.getString(locale, "GeneralMessages.booked", new Object[0]);
            }
            case WITH_MESSAGES: {
                return BankingApiMessages.getString(locale, "SendUtil.state.notificationsExist", new Object[0]);
            }
            case RJCT: {
                return BankingApiMessages.getString(locale, "SendUtil.state.rejected", new Object[0]);
            }
            case CALLBACK_STARTED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.cancellationRequested", new Object[0]);
            }
        }
        return null;
    }

    public static String getStateFilterText(SendFilter.State state, Locale locale) {
        switch (state) {
            case SENT: {
                return BankingApiMessages.getString(locale, "SendUtil.state.sent", new Object[0]);
            }
            case FINISHED_ERROR: {
                return BankingApiMessages.getString(locale, "GeneralMessages.error", new Object[0]);
            }
            case FINISHED_OK: {
                return BankingApiMessages.getString(locale, "SendUtil.state.finishedOk", new Object[0]);
            }
            case WAITING_IN_DS: {
                return BankingApiMessages.getString(locale, "SendUtil.state.waitingInDS", new Object[0]);
            }
            case CANCELED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.canceled", new Object[0]);
            }
            case ACSC_ACCP: {
                return BankingApiMessages.getString(locale, "GeneralMessages.booked", new Object[0]);
            }
            case WITH_MESSAGES: {
                return BankingApiMessages.getString(locale, "SendUtil.state.notificationsExist", new Object[0]);
            }
            case RJCT: {
                return BankingApiMessages.getString(locale, "SendUtil.state.rejected", new Object[0]);
            }
            case CALLBACK_STARTED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.cancellationRequested", new Object[0]);
            }
            case PARTIAL_BOOKED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.bookedPartially", new Object[0]);
            }
        }
        return null;
    }

    public static String getStateFilterText(DsOrderDetails.State state, Locale locale) {
        return SendStateUtil.getStateFilterText(state, null, locale);
    }

    public static String getStateFilterText(DsOrderDetails.State state, String errorMsg, Locale locale) {
        if (state == null) {
            return "null";
        }
        switch (state) {
            case CANCELLED: {
                return BankingApiMessages.getString(locale, "DistributedSignatureView.state.canceled", new Object[0]);
            }
            case FINISHED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.finishedOk", new Object[0]);
            }
            case FINISHED_ERROR: {
                if (errorMsg == null) {
                    return BankingApiMessages.getString(locale, "GeneralMessages.error", new Object[0]);
                }
                return errorMsg;
            }
            case WAITING: {
                return BankingApiMessages.getString(locale, "SendUtil.state.waitingInDS", new Object[0]);
            }
            case CONFIRMED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.confirmed", new Object[0]);
            }
            case FINISHED_FINAL: {
                return BankingApiMessages.getString(locale, "DistributedSignatureView.state.finishedfinal", new Object[0]);
            }
        }
        return BankingApiMessages.getString(locale, "SendUtil.state.waitingInDS", new Object[0]);
    }
}

