/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.SendParameterUtil;
import de.businesslogics.banking.api.WrongTransferTypeException;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.ServiceOptionStringType;
import de.businesslogics.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SendParameters {
    private static final Set<PaymentTransferType.PmtType> activePmtTypes = new HashSet<PaymentTransferType.PmtType>();
    private static final Set<PaymentTransferType.PmtType> importPmtTypes = new HashSet<PaymentTransferType.PmtType>();
    private static final Map<PaymentTransferType.PmtType, PmtTypeGroup> pmtTypeGroupMap = new HashMap<PaymentTransferType.PmtType, PmtTypeGroup>();
    private static final Map<String, String> btfOrderTypeMap = new HashMap<String, String>();
    private static final Map<String, String> orderTypeBtfMap = new HashMap<String, String>();
    private static final Map<PaymentTransferType.PmtType, PaymentTransferType.PmtType> defaultPmtTypeMap = new HashMap<PaymentTransferType.PmtType, PaymentTransferType.PmtType>();
    private static final Map<String, PaymentTransferType.PmtType> handlerKeyPmtTypeMap = new HashMap<String, PaymentTransferType.PmtType>();
    private final PaymentTransferType.PmtType pmtType;
    private String orderType;
    private String originalOrderType;
    private final String defaultOrderType;
    private String orderTypeVop;
    private String originalOrderTypeVop;
    private final String defaultOrderTypeVop;
    private String btf;
    private String originalBtf;
    private final String defaultBtf;
    private String btfVop;
    private String originalBtfVop;
    private final String defaultBtfVop;
    private PaymentTransferType.Scheme scheme;
    private PaymentTransferType.Scheme originalScheme;
    private final PaymentTransferType.Scheme defaultScheme;
    private PaymentTransferType paymentSendType;

    @Deprecated
    public SendParameters(PaymentTransferType paymentSendType) {
        this(paymentSendType, null);
    }

    private SendParameters(PaymentTransferType paymentSendType, String countryCode) {
        this.paymentSendType = paymentSendType;
        this.pmtType = paymentSendType.getPmtType();
        this.defaultOrderType = SendParameterUtil.getDefaultOrderType(this.pmtType, countryCode);
        this.originalOrderType = this.orderType = paymentSendType.getOrderType().trim();
        if (this.orderType.equals("")) {
            this.orderType = this.defaultOrderType;
        }
        this.defaultOrderTypeVop = SendParameterUtil.getDefaultOrderTypeVop(this.pmtType, countryCode);
        this.originalOrderTypeVop = this.orderTypeVop = paymentSendType.getOrderTypeVop();
        if (this.orderTypeVop == null || this.orderTypeVop.equals("")) {
            this.orderTypeVop = this.defaultOrderTypeVop;
        }
        this.defaultBtf = SendParameterUtil.getDefaultBTF(this.pmtType, countryCode);
        this.originalBtf = this.btf = paymentSendType.getBtf().trim();
        if (this.btf == null || this.btf.equals("")) {
            this.btf = this.defaultBtf;
        }
        this.defaultBtfVop = SendParameterUtil.getDefaultBTFVop(this.pmtType, countryCode);
        this.originalBtfVop = this.btfVop = paymentSendType.getBtfVop();
        if (this.btfVop == null || this.btfVop.equals("")) {
            this.btfVop = this.defaultBtfVop;
        }
        this.defaultScheme = SepaSchemeHandler.getDefaultScheme(this.pmtType, countryCode);
        this.scheme = paymentSendType.getScheme();
        if (PaymentTransferType.Scheme.NONE.equals((Object)this.scheme)) {
            this.scheme = this.defaultScheme;
        }
        this.originalScheme = this.scheme;
    }

    private SendParameters(PaymentTransferType.PmtType pmtType, String countryCode) {
        this.paymentSendType = null;
        this.pmtType = pmtType;
        this.originalOrderType = this.orderType = SendParameterUtil.getDefaultOrderType(pmtType, countryCode);
        this.defaultOrderType = this.orderType;
        this.originalOrderTypeVop = this.orderTypeVop = SendParameterUtil.getDefaultOrderTypeVop(pmtType, countryCode);
        this.defaultOrderTypeVop = this.orderTypeVop;
        this.originalBtf = this.btf = SendParameterUtil.getDefaultBTF(pmtType, countryCode);
        this.defaultBtf = this.btf;
        this.originalBtfVop = this.btfVop = SendParameterUtil.getDefaultBTFVop(pmtType, countryCode);
        this.defaultBtfVop = this.btfVop;
        this.originalScheme = this.scheme = SepaSchemeHandler.getDefaultScheme(pmtType, countryCode);
        this.defaultScheme = this.scheme;
    }

    @Deprecated
    public SendParameters(PaymentTransferType.PmtType pmtType, String orderType, String btf) {
        this(pmtType, orderType, btf, null);
    }

    @Deprecated
    public SendParameters(PaymentTransferType.PmtType pmtType, String orderType, String btf, PaymentTransferType.Scheme scheme) {
        this(pmtType, orderType, btf, null, null);
    }

    @Deprecated
    public SendParameters(PaymentTransferType.PmtType pmtType, String orderType, String btf, PaymentTransferType.Scheme scheme, String countryCode) {
        this.pmtType = pmtType;
        this.orderType = orderType.trim();
        this.originalOrderType = orderType;
        this.defaultOrderType = SendParameterUtil.getDefaultOrderType(pmtType, countryCode);
        this.originalOrderTypeVop = this.orderTypeVop = null;
        this.defaultOrderTypeVop = SendParameterUtil.getDefaultOrderTypeVop(pmtType, countryCode);
        this.originalBtf = this.btf = btf.trim();
        this.defaultBtf = SendParameterUtil.getDefaultBTF(pmtType, countryCode);
        this.originalBtfVop = this.btfVop = null;
        this.defaultBtfVop = SendParameterUtil.getDefaultBTFVop(pmtType, countryCode);
        this.scheme = scheme;
        this.originalScheme = scheme;
        this.defaultScheme = SepaSchemeHandler.getDefaultScheme(pmtType, countryCode);
        this.paymentSendType = null;
    }

    public void save(BankSettings bank) {
        if (!(this.orderType.equals(this.originalOrderType) && this.btf.equals(this.originalBtf) && Objects.equals(this.orderTypeVop, this.originalOrderTypeVop) && Objects.equals(this.btfVop, this.originalBtfVop) && !this.schemesDiffer(this.scheme, this.originalScheme))) {
            if (this.paymentSendType == null) {
                this.paymentSendType = new PaymentTransferType(bank, this.pmtType, this.orderType, this.btf, this.orderTypeVop, this.btfVop);
                this.paymentSendType.setScheme(this.scheme);
                this.paymentSendType.save();
            } else if (this.orderType.equals(this.defaultOrderType) && this.btf.equals(this.defaultBtf) && Objects.equals(this.orderTypeVop, this.defaultOrderTypeVop) && Objects.equals(this.btfVop, this.defaultBtfVop) && !this.schemesDiffer(this.scheme, this.defaultScheme)) {
                this.paymentSendType.delete();
                this.paymentSendType = null;
            } else {
                this.paymentSendType.setBtf(this.btf);
                this.paymentSendType.setOrderType(this.orderType);
                this.paymentSendType.setBtfVop(this.btfVop);
                this.paymentSendType.setOrderTypeVop(this.orderTypeVop);
                this.paymentSendType.setScheme(this.scheme);
                this.paymentSendType.update();
            }
            SendParameters.updatePaymentTables(bank, this.pmtType, this.btf, this.orderType);
            Send.updateFileTypeOfEbics25Orders(bank, this.pmtType, this.btf);
            this.originalBtf = this.orderType;
            this.originalBtf = this.btf;
            this.originalBtfVop = this.orderTypeVop;
            this.originalBtfVop = this.btfVop;
            this.originalScheme = this.scheme;
        }
    }

    private boolean schemesDiffer(PaymentTransferType.Scheme scheme, PaymentTransferType.Scheme originalScheme) {
        if (scheme == null) {
            return originalScheme != null;
        }
        return !scheme.equals((Object)originalScheme);
    }

    private static void updatePaymentTables(BankSettings bank, PaymentTransferType.PmtType pmtType, String btf, String orderType) {
        if (orderType != null && orderType.trim().length() > 3) {
            orderType = "FUL";
        }
        OpenPayment.updateFileTypeAndOrderType(bank, pmtType, btf, orderType);
        PeriodicPayment.updateFileTypeAndOrderType(bank, pmtType, btf, orderType);
        PaymentTemplate.updateFileTypeAndOrderType(bank, pmtType, btf, orderType);
    }

    public static void updateDefaultTransferTypesInPaymentTables(BankSettings bank, String oldCountryCode) {
        String countryCode = StringUtils.checkNullAndTrim(bank.getCountryCode());
        if ((oldCountryCode = StringUtils.checkNullAndTrim(oldCountryCode)).length() == 2 && countryCode.length() == 2 && !oldCountryCode.equals(countryCode)) {
            Map<PaymentTransferType.PmtType, PaymentTransferType> paymentSendTypeMap = PaymentTransferType.findMapByBank(bank);
            for (PaymentTransferType.PmtType pmtType : activePmtTypes) {
                if (paymentSendTypeMap.get((Object)pmtType) != null) continue;
                String oldDefaultOrderType = SendParameterUtil.getDefaultOrderType(pmtType, oldCountryCode);
                String oldDefaultBTF = SendParameterUtil.getDefaultBTF(pmtType, oldCountryCode);
                String defaultOrderType = SendParameterUtil.getDefaultOrderType(pmtType, countryCode);
                String defaultBTF = SendParameterUtil.getDefaultBTF(pmtType, countryCode);
                if (defaultOrderType.equals(oldDefaultOrderType) && defaultBTF.equals(oldDefaultBTF)) continue;
                SendParameters.updatePaymentTables(bank, pmtType, defaultBTF, defaultOrderType);
            }
        }
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this.pmtType;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderTypeVop() {
        return this.orderTypeVop;
    }

    public void setOrderTypeVop(String orderTypeVop) {
        this.orderTypeVop = orderTypeVop;
    }

    public String getBtf() {
        return this.btf;
    }

    public void setBtf(String btf) {
        this.btf = btf;
    }

    public String getBtfVop() {
        return this.btfVop;
    }

    public void setBtfVop(String btfVop) {
        this.btfVop = btfVop;
    }

    public PaymentTransferType.Scheme getScheme() {
        if (this.scheme != null) {
            return this.scheme;
        }
        return this.defaultScheme;
    }

    public void setScheme(PaymentTransferType.Scheme scheme) {
        this.scheme = scheme != null ? scheme : this.defaultScheme;
    }

    public static List<SendParameters> getSendParameters(BankSettings bank, Set<PmtTypeGroup> allowedGroups) {
        ArrayList<SendParameters> sendParametersList = new ArrayList<SendParameters>();
        Map<PaymentTransferType.PmtType, PaymentTransferType> paymentSendTypeMap = PaymentTransferType.findMapByBank(bank);
        for (PaymentTransferType.PmtType pmtType : activePmtTypes) {
            if (!allowedGroups.contains((Object)pmtTypeGroupMap.get((Object)pmtType))) continue;
            SendParameters sendParameters = paymentSendTypeMap.containsKey((Object)pmtType) ? new SendParameters(paymentSendTypeMap.get((Object)pmtType), bank.getCountryCode()) : new SendParameters(pmtType, bank.getCountryCode());
            sendParametersList.add(sendParameters);
        }
        return sendParametersList;
    }

    public static List<SendParameters> getSendParametersForPmtTypes(BankSettings bank, List<PaymentTransferType.PmtType> pmtTypes) {
        ArrayList<SendParameters> sendParametersList = new ArrayList<SendParameters>();
        Map<PaymentTransferType.PmtType, PaymentTransferType> paymentSendTypeMap = PaymentTransferType.findMapByBank(bank);
        for (PaymentTransferType.PmtType pmtType : pmtTypes) {
            if (paymentSendTypeMap.containsKey((Object)pmtType)) {
                sendParametersList.add(new SendParameters(paymentSendTypeMap.get((Object)pmtType), bank.getCountryCode()));
                continue;
            }
            sendParametersList.add(new SendParameters(pmtType, bank.getCountryCode()));
        }
        return sendParametersList;
    }

    public static Set<PaymentTransferType.PmtType> getPmtTypesForImport(Set<PmtTypeGroup> allowedGroups) {
        return SendParameters.getAllowedPmtTypes(importPmtTypes, allowedGroups);
    }

    public static Set<PaymentTransferType.PmtType> getPmtTypesForFilter(Set<PmtTypeGroup> allowedGroups) {
        return SendParameters.getAllowedPmtTypes(activePmtTypes, allowedGroups);
    }

    private static Set<PaymentTransferType.PmtType> getAllowedPmtTypes(Collection<PaymentTransferType.PmtType> pmtTypes, Set<PmtTypeGroup> allowedGroups) {
        HashSet<PaymentTransferType.PmtType> allowedPmtTypes = new HashSet<PaymentTransferType.PmtType>();
        for (PaymentTransferType.PmtType pmtType : pmtTypes) {
            if (!allowedGroups.contains((Object)pmtTypeGroupMap.get((Object)pmtType))) continue;
            allowedPmtTypes.add(pmtType);
        }
        return allowedPmtTypes;
    }

    private static void initializeDefaultMaps() {
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER, PaymentTransferType.PmtType.SEPA_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER, PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER, PaymentTransferType.PmtType.SEPA_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_URGENT_FOREIGN_TRANSFER, PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.DTAZV_TRANSFER, PmtTypeGroup.DTAZV);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.MT101_TRANSFER, PmtTypeGroup.MT101);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.C55_CALLBACK, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.C55_SDD_CALLBACK, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SWISS_DOMESTIC_TRANSFER_3, PmtTypeGroup.SEPA_CH);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT, PaymentTransferType.PmtType.SEPA_TRANSFER, PmtTypeGroup.SEPA_AT);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT, PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER, PmtTypeGroup.SEPA_AT);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT, PaymentTransferType.PmtType.SEPA_TRANSFER, PmtTypeGroup.SEPA_AT);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN, PaymentTransferType.PmtType.AUSTRIAN_FOREIGN, PmtTypeGroup.SEPA_AT_FOREIGN);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE, PaymentTransferType.PmtType.AUSTRIAN_FOREIGN, PmtTypeGroup.SEPA_AT_FOREIGN);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE, PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER, PmtTypeGroup.SEPA);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_EUR, PmtTypeGroup.BBK);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_NON_EUR, PmtTypeGroup.BBK);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_SWIFT_TRANSFER, PmtTypeGroup.BBK);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.CFONB320_TRANSFER, PmtTypeGroup.CFONB);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.CFONB160_TRANSFER, PmtTypeGroup.CFONB);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.CFONB160_URGENT_TRANSFER, PmtTypeGroup.CFONB);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.CFONB160_DIRECT_DEBIT, PmtTypeGroup.CFONB);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.CFONB160_URGENT_DIRECT_DEBIT, PmtTypeGroup.CFONB);
        SendParameters.addToDefaultMaps(PaymentTransferType.PmtType.CFONB160_BILL_OF_EXCHANGE, PmtTypeGroup.CFONB);
    }

    private static void addToDefaultMaps(PaymentTransferType.PmtType pmtType, PmtTypeGroup group) {
        SendParameters.addToDefaultMaps(pmtType, pmtType, group);
    }

    private static void addToDefaultMaps(PaymentTransferType.PmtType pmtType, PaymentTransferType.PmtType defaultPmtType, PmtTypeGroup group) {
        String handlerKey = pmtType.getHandlerKey();
        String btf = SendParameterUtil.getDefaultBTF(pmtType, null);
        activePmtTypes.add(pmtType);
        pmtTypeGroupMap.put(pmtType, group);
        if (pmtType.supportsImport() && pmtType.equals((Object)defaultPmtType)) {
            importPmtTypes.add(pmtType);
        }
        defaultPmtTypeMap.put(pmtType, defaultPmtType);
        if (handlerKeyPmtTypeMap.containsKey(handlerKey)) {
            handlerKeyPmtTypeMap.put(handlerKey, defaultPmtType);
        } else {
            handlerKeyPmtTypeMap.put(handlerKey, pmtType);
        }
        btfOrderTypeMap.put(btf, handlerKey);
        orderTypeBtfMap.put(handlerKey, btf);
    }

    public static PaymentTransferType.PmtType getPmtTypeFromHandlerKey(String handlerKey) {
        return handlerKeyPmtTypeMap.get(handlerKey);
    }

    public static String getBTFFromHandlerKey(BankSettings bank, String handlerKey) {
        PaymentTransferType.PmtType pmtType = handlerKeyPmtTypeMap.get(handlerKey);
        if (pmtType != null) {
            return SendParameters.getBTF(bank, pmtType);
        }
        return null;
    }

    public static String getBTF(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        String btf;
        PaymentTransferType vo = PaymentTransferType.findByBankAndPmtType(bank, pmtType);
        if (vo != null && (btf = vo.getBtf()) != null && !btf.equals("")) {
            return btf;
        }
        return SendParameterUtil.getDefaultBTF(pmtType, bank != null ? bank.getCountryCode() : null);
    }

    public static String getDefaultBTF(PaymentTransferType.PmtType pmtType, String countryCode) {
        return SendParameterUtil.getDefaultBTF(pmtType, countryCode);
    }

    public static String getBTFVopFromHandlerKey(BankSettings bank, String handlerKey) {
        PaymentTransferType.PmtType pmtType = handlerKeyPmtTypeMap.get(handlerKey);
        if (pmtType != null) {
            return SendParameters.getBTFVop(bank, pmtType);
        }
        return null;
    }

    public static String getBTFVop(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        String btfVop;
        PaymentTransferType vo = PaymentTransferType.findByBankAndPmtType(bank, pmtType);
        if (vo != null && (btfVop = vo.getBtfVop()) != null && !btfVop.equals("")) {
            return btfVop;
        }
        return SendParameterUtil.getDefaultBTFVop(pmtType, bank != null ? bank.getCountryCode() : null);
    }

    public static String getDefaultBTFVop(PaymentTransferType.PmtType pmtType, String countryCode) {
        return SendParameterUtil.getDefaultBTFVop(pmtType, countryCode);
    }

    public static String getOrderTypeFromHandlerKey(BankSettings bank, String handlerKey) {
        PaymentTransferType.PmtType pmtType = handlerKeyPmtTypeMap.get(handlerKey);
        if (pmtType != null) {
            return SendParameters.getOrderType(bank, pmtType);
        }
        return null;
    }

    public static String getOrderType(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        String orderType;
        PaymentTransferType vo = PaymentTransferType.findByBankAndPmtType(bank, pmtType);
        if (vo != null && (orderType = vo.getOrderType()) != null && !orderType.equals("")) {
            return orderType;
        }
        return SendParameterUtil.getDefaultOrderType(pmtType, bank != null ? bank.getCountryCode() : null);
    }

    public static String getDefaultOrderType(PaymentTransferType.PmtType pmtType, String countryCode) {
        return SendParameterUtil.getDefaultOrderType(pmtType, countryCode);
    }

    public static String getOrderTypeVopFromHandlerKey(BankSettings bank, String handlerKey) {
        PaymentTransferType.PmtType pmtType = handlerKeyPmtTypeMap.get(handlerKey);
        if (pmtType != null) {
            return SendParameters.getOrderTypeVop(bank, pmtType);
        }
        return null;
    }

    public static String getOrderTypeVop(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        String orderTypeVop;
        PaymentTransferType vo = PaymentTransferType.findByBankAndPmtType(bank, pmtType);
        if (vo != null && (orderTypeVop = vo.getOrderTypeVop()) != null && !orderTypeVop.equals("")) {
            return orderTypeVop;
        }
        return SendParameterUtil.getDefaultOrderTypeVop(pmtType, bank != null ? bank.getCountryCode() : null);
    }

    public static String getDefaultOrderTypeVop(PaymentTransferType.PmtType pmtType, String countryCode) {
        return SendParameterUtil.getDefaultOrderTypeVop(pmtType, countryCode);
    }

    public static String getTransferTypeFromHandlerKey(BankSettings bank, String handlerKey) {
        if (BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion())) {
            return SendParameters.getBTFFromHandlerKey(bank, handlerKey);
        }
        return SendParameters.getOrderTypeFromHandlerKey(bank, handlerKey);
    }

    public static String getTransferTypeVopByBank(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        if (BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion())) {
            return SendParameters.getBTFVop(bank, pmtType);
        }
        return SendParameters.getOrderTypeVop(bank, pmtType);
    }

    public static String getTransferTypeByBank(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        if (BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion())) {
            return SendParameters.getBTF(bank, pmtType);
        }
        return SendParameters.getOrderType(bank, pmtType);
    }

    public static String getTransferTypeByBank(Integer bankId, PaymentTransferType.PmtType pmtType) {
        BankSettings bank;
        if (bankId == null || (bank = (BankSettings)DB.find(BankSettings.class).where().eq("id", (Object)bankId).findOne()) == null) {
            return null;
        }
        return SendParameters.getTransferTypeByBank(bank, pmtType);
    }

    public static String getTransferTypeByBank(String bankId, PaymentTransferType.PmtType pmtType) {
        Integer bankIdNumeric;
        if (bankId == null) {
            return null;
        }
        try {
            bankIdNumeric = Integer.parseInt(bankId);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return SendParameters.getTransferTypeByBank(bankIdNumeric, pmtType);
    }

    public static String getTransferTypeByAccount(Account account, PaymentTransferType.PmtType pmtType) {
        BankSettings bank;
        if (account == null || (bank = account.getBank()) == null) {
            return null;
        }
        return SendParameters.getTransferTypeByBank(bank, pmtType);
    }

    public static String getTransferTypeByAccount(Integer accountId, PaymentTransferType.PmtType pmtType) {
        Account account;
        if (accountId == null || (account = (Account)DB.find(Account.class).where().eq("id", (Object)accountId).findOne()) == null) {
            return null;
        }
        return SendParameters.getTransferTypeByAccount(account, pmtType);
    }

    public static String getTransferTypeByAccount(String accountId, PaymentTransferType.PmtType pmtType) {
        Integer accountIdNumeric;
        if (accountId == null) {
            return null;
        }
        try {
            accountIdNumeric = Integer.parseInt(accountId);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return SendParameters.getTransferTypeByAccount(accountIdNumeric, pmtType);
    }

    public static void checkTransferType(String transferType, BankSettings bank, PaymentTransferType.PmtType pmtType, Locale locale) throws WrongTransferTypeException {
        String configuredTransferType = SendParameters.getTransferTypeByBank(bank, pmtType);
        if (transferType.equals(configuredTransferType) || pmtType.supportsVop() && transferType.equals(SendParameters.getTransferTypeVopByBank(bank, pmtType))) {
            return;
        }
        throw new WrongTransferTypeException(transferType, configuredTransferType, bank, pmtType, locale);
    }

    @Deprecated
    public static String getHandlerKey(PaymentTransferType.PmtType pmtType) {
        return pmtType.getHandlerKey();
    }

    @Deprecated
    public static String getDefaultBtf(PaymentTransferType.PmtType pmtType) {
        return SendParameterUtil.getDefaultBTF(pmtType, null);
    }

    public static PaymentTransferType.PmtType getPmtType(BankSettings bank, String transferType) {
        Map<PaymentTransferType.PmtType, PaymentTransferType> pmtTypePaymentTransferTypeMap = PaymentTransferType.findMapByBank(bank);
        String countryCode = bank.getCountryCode();
        HashSet<PaymentTransferType.PmtType> pmtTypes = new HashSet<PaymentTransferType.PmtType>();
        boolean isBTF = BTFTranslator.isBTFString(transferType);
        RestrictedServiceType rst = isBTF ? BTFTranslator.convertFromStringToBTF(transferType).getService() : null;
        String otherBTF = rst != null && SendParameters.isVOO(rst) ? SendParameters.reverseVOO(rst).toString() : null;
        for (PaymentTransferType.PmtType pmtType : activePmtTypes) {
            String defaultSendType;
            if (pmtTypePaymentTransferTypeMap.containsKey((Object)pmtType)) {
                PaymentTransferType vo = pmtTypePaymentTransferTypeMap.get((Object)pmtType);
                if (transferType.equals(isBTF ? vo.getBtf() : vo.getOrderType())) {
                    pmtTypes.add(pmtType);
                    continue;
                }
                if (otherBTF != null && otherBTF.equals(vo.getBtfVop())) {
                    pmtTypes.add(pmtType);
                    continue;
                }
                if (!pmtType.supportsVop() || !transferType.equals(isBTF ? vo.getBtfVop() : vo.getOrderTypeVop())) continue;
                pmtTypes.add(pmtType);
                continue;
            }
            String string = defaultSendType = isBTF ? SendParameterUtil.getDefaultBTF(pmtType, countryCode) : SendParameterUtil.getDefaultOrderType(pmtType, countryCode);
            if (transferType.equals(defaultSendType)) {
                pmtTypes.add(pmtType);
                continue;
            }
            if (otherBTF != null && otherBTF.equals(defaultSendType)) {
                pmtTypes.add(pmtType);
                continue;
            }
            if (!pmtType.supportsVop() || !transferType.equals(defaultSendType = isBTF ? SendParameterUtil.getDefaultBTFVop(pmtType, countryCode) : SendParameterUtil.getDefaultOrderTypeVop(pmtType, countryCode))) continue;
            pmtTypes.add(pmtType);
        }
        return SendParameters.getPmtType(pmtTypes);
    }

    private static boolean isVOO(RestrictedServiceType btf) {
        if (btf == null) {
            return false;
        }
        return !(!"SCT".equals(btf.getServiceName().getValue()) && !"SCI".equals(btf.getServiceName().getValue()) || btf.getServiceOption() != null && !"VOO".equals(btf.getServiceOption().getValue()) || !"pain.001".equals(btf.getMsgName().getValue()));
    }

    private static RestrictedServiceType reverseVOO(RestrictedServiceType existing) {
        RestrictedServiceType service = new RestrictedServiceType(existing.getServiceName(), existing.getMsgName());
        service.setContainer(existing.getContainer());
        service.setScope(existing.getScope());
        if (existing.getServiceOption() == null) {
            service.setServiceOption(new ServiceOptionStringType("VOO"));
        }
        return service;
    }

    private static PaymentTransferType.PmtType getPmtType(Set<PaymentTransferType.PmtType> pmtTypes) {
        int countPmtTypes = pmtTypes.size();
        if (countPmtTypes == 0) {
            return null;
        }
        if (countPmtTypes == 1) {
            return pmtTypes.iterator().next();
        }
        PaymentTransferType.PmtType defaultPmtType = SendParameters.getDefaultPmtType(pmtTypes);
        if (defaultPmtType != null) {
            return defaultPmtType;
        }
        return SendParameters.getDefaultPmtType(pmtTypes.iterator().next());
    }

    private static PaymentTransferType.PmtType getDefaultPmtType(Set<PaymentTransferType.PmtType> pmtTypes) {
        HashSet<PaymentTransferType.PmtType> defaultPmtTypes = new HashSet<PaymentTransferType.PmtType>();
        for (PaymentTransferType.PmtType pmtType : pmtTypes) {
            PaymentTransferType.PmtType defaultPmtType = defaultPmtTypeMap.get((Object)pmtType);
            if (defaultPmtType != null) {
                defaultPmtTypes.add(defaultPmtType);
                continue;
            }
            defaultPmtTypes.add(pmtType);
        }
        if (defaultPmtTypes.size() == 1) {
            return (PaymentTransferType.PmtType)((Object)defaultPmtTypes.iterator().next());
        }
        return null;
    }

    public static PaymentTransferType.PmtType getDefaultPmtType(PaymentTransferType.PmtType pmtType) {
        return defaultPmtTypeMap.get((Object)pmtType);
    }

    public static String getHandlerKey(BankSettings bank, String transferType) {
        String handlerKey = null;
        PaymentTransferType.PmtType pmtType = SendParameters.getPmtType(bank, transferType);
        if (pmtType != null) {
            handlerKey = pmtType.getHandlerKey();
        } else if (BTFTranslator.isBTFString(transferType)) {
            handlerKey = BTFTranslator.getSendOrderTypeFromBTF(transferType);
        }
        return handlerKey != null ? handlerKey : transferType;
    }

    public static String getHandlerKeyFromDefaultBTF(String btf) {
        return btfOrderTypeMap.get(btf);
    }

    public static String getDefaultBTFFromHandlerKey(String handlerKey) {
        return orderTypeBtfMap.get(handlerKey);
    }

    static {
        SendParameters.initializeDefaultMaps();
    }

    public static enum PmtTypeGroup {
        SEPA,
        DTAZV,
        MT101,
        BBK,
        CFONB,
        SEPA_AT,
        SEPA_CH,
        BBK_OBSOLETE,
        SEPA_AT_FOREIGN;

    }
}

