/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.ebics.client.AustrianBTFTranslator;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.client.SwissBTFTranslator;
import java.util.HashMap;
import java.util.Map;

public class SendParameterUtil {
    private static final String AT = "AT";
    private static final String CH = "CH";
    private static final String FR = "FR";
    private static final String DE = "DE";
    public static final String[] BANK_COUNTRIES = new String[]{"AT", "CH", "FR", "DE"};
    private static final Map<String, PaymentTransferType.PmtType> containerTansferTypeImportPmtTypeMap = new HashMap<String, PaymentTransferType.PmtType>();

    private static void addContainerTransferType(String orderType, PaymentTransferType.PmtType pmtType) {
        containerTansferTypeImportPmtTypeMap.put(orderType, pmtType);
        String btf = BTFTranslator.getBTFFromSendOrderType(orderType);
        if (btf != null) {
            containerTansferTypeImportPmtTypeMap.put(btf, pmtType);
        }
    }

    public static PaymentTransferType.PmtType getPmtTypeForContainerImport(String transferType) {
        return containerTansferTypeImportPmtTypeMap.get(transferType);
    }

    public static String getDefaultOrderType(PaymentTransferType.PmtType pmtType, String countryCode) {
        return SendParameterUtil.getDefaultSendParameter(pmtType, countryCode, true);
    }

    public static String getDefaultOrderTypeVop(PaymentTransferType.PmtType pmtType, String countryCode) {
        return SendParameterUtil.getDefaultSendParameterVop(pmtType, countryCode, true);
    }

    public static String getDefaultBTF(PaymentTransferType.PmtType pmtType, String countryCode) {
        return SendParameterUtil.getDefaultSendParameter(pmtType, countryCode, false);
    }

    public static String getDefaultBTFVop(PaymentTransferType.PmtType pmtType, String countryCode) {
        return SendParameterUtil.getDefaultSendParameterVop(pmtType, countryCode, false);
    }

    private static String getDefaultSendParameter(PaymentTransferType.PmtType pmtType, String countryCode, boolean isOrderType) {
        switch (pmtType) {
            case SEPA_TRANSFER: 
            case SEPA_VIRTUAL_ACCOUNT_TRANSFER: 
            case SEPA_NON_SEPA_COUNTRY_TRANSFER: 
            case AUSTRIAN_TAX_PAYMENT: 
            case AUSTRIAN_POSTBAR_PAYMENT: {
                if (AT.equals(countryCode)) {
                    return SendParameterUtil.getDefaultAustrianSendParameter(isOrderType, "CCT");
                }
                if (CH.equals(countryCode)) {
                    return SendParameterUtil.getDefaultSwissSendParameter(isOrderType, "XET");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.001.001.03.sct" : "SCT:GLB_pain.001";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SEPA_CONFIDENTAL_TRANSFER: {
                if (AT.equals(countryCode)) {
                    return isOrderType ? "CCT" : "SCT:AT:CFD_pain.001";
                }
                if (CH.equals(countryCode)) {
                    return SendParameterUtil.getDefaultSwissSendParameter(isOrderType, "XET");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.001.001.03.sct.vcf" : "SCT:GLB:CFD_pain.001";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SEPA_FOREIGN_CURRENCY_TRANSFER: {
                return isOrderType ? "XCT" : "XCT_pain.001";
            }
            case AUSTRIAN_FOREIGN: 
            case AUSTRIAN_FOREIGN_SEPA_CHEQUE: {
                return isOrderType ? "ATX" : "XCT:AT_pain.001";
            }
            case SEPA_FOREIGN_TRANSFER: 
            case SEPA_FOREIGN_CHEQUE: {
                if (CH.equals(countryCode)) {
                    return SendParameterUtil.getDefaultSwissSendParameter(isOrderType, "XG1");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.001.001.03.xct" : "XCT:GLB_pain.001";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SEPA_URGENT_FOREIGN_TRANSFER: {
                if (AT.equals(countryCode)) {
                    return isOrderType ? "CCU" : "XCT:AT:URG_pain.001";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SEPA_URGENT_TRANSFER: 
            case AUSTRIAN_URGENT_TAX_PAYMENT: {
                if (AT.equals(countryCode)) {
                    return SendParameterUtil.getDefaultAustrianSendParameter(isOrderType, "CCU");
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SEPA_URGENT_CONFIDENTAL_TRANSFER: {
                if (AT.equals(countryCode)) {
                    return isOrderType ? "CCU" : "SCT:AT:UCF_pain.001";
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.001.001.03.sct.vcf" : "SCT:GLB:UCF_pain.001";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SEPA_INSTANT_TRANSFER: {
                if (AT.equals(countryCode)) {
                    return SendParameterUtil.getDefaultAustrianSendParameter(isOrderType, "CIP");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.001.001.03.sct.inst" : "SCI:GLB_pain.001";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SWISS_DOMESTIC_TRANSFER_3: 
            case SWISS_ES1_TRANSFER: 
            case SWISS_ES2_TRANSFER: 
            case SWISS_ESR_TRANSFER: 
            case SWISS_DOMESTIC_TRANSFER_4: 
            case SWISS_QR_TRANSFER: 
            case SWISS_SEPA_TRANSFER: 
            case SWISS_FOREIGN_TRANSFER: {
                return isOrderType ? "XE2" : "MCT:CH_pain.001";
            }
            case SEPA_CORE_DIRECT_DEBIT: {
                if (AT.equals(countryCode)) {
                    return SendParameterUtil.getDefaultAustrianSendParameter(isOrderType, "CDD");
                }
                if (CH.equals(countryCode)) {
                    return SendParameterUtil.getDefaultSwissSendParameter(isOrderType, "CDD");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.008.001.02.sdd" : "SDD:GLB_pain.008";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SEPA_B2B_DIRECT_DEBIT: {
                if (AT.equals(countryCode)) {
                    return SendParameterUtil.getDefaultAustrianSendParameter(isOrderType, "CDB");
                }
                if (CH.equals(countryCode)) {
                    return SendParameterUtil.getDefaultSwissSendParameter(isOrderType, "SDD");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.008.001.02.sbb" : "SDD:GLB:B2B_pain.008";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SEPA_COR1_DIRECT_DEBIT: {
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case SWISS_SEPA_CORE_DIRECT_DEBIT: {
                return isOrderType ? "XE3" : "SDD:CH_pain.008";
            }
            case SWISS_SEPA_B2B_DIRECT_DEBIT: {
                return isOrderType ? "XE4" : "SDD:CH:XB2B_pain.008";
            }
            case MT101_TRANSFER: {
                if (AT.equals(countryCode)) {
                    return isOrderType ? "RFT" : "RFT_mt101";
                }
                if (CH.equals(countryCode)) {
                    return SendParameterUtil.getDefaultSwissSendParameter(isOrderType, "RFT");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.fin.mt101.mct" : "RFT:GLB_mt101";
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case DTAZV_TRANSFER: 
            case C55_CALLBACK: {
                return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType);
            }
            case C55_SDD_CALLBACK: {
                if (isOrderType) {
                    return pmtType.getHandlerKey();
                }
                String btf = SendParameterUtil.getDefaultSendParameter(false, PaymentTransferType.PmtType.C55_CALLBACK);
                return btf.replace("SCT", "SDD");
            }
            case CFONB320_TRANSFER: {
                return isOrderType ? "pain.xxx.cfonb320.xct" : "XCT:FR_cfonb320";
            }
            case CFONB160_TRANSFER: {
                return isOrderType ? "pain.xxx.cfonb160.dct" : "DCT:FR_cfonb160";
            }
            case CFONB160_URGENT_TRANSFER: {
                return isOrderType ? "pain.xxx.cfonb160.ict" : "ICT:FR_cfonb160";
            }
            case CFONB160_DIRECT_DEBIT: {
                return isOrderType ? "pain.xxx.cfonb160.ddd" : "DDD:FR_cfonb160";
            }
            case CFONB160_URGENT_DIRECT_DEBIT: {
                return isOrderType ? "pain.xxx.cfonb160.dda" : "DDD:FR:URG_cfonb160";
            }
            case CFONB160_BILL_OF_EXCHANGE: {
                return isOrderType ? "pain.xxx.cfonb160.dco" : "DCO:FR_cfonb160";
            }
            case BBK_HBV_FOREIGN_TRANSFER_EUR: {
                return isOrderType ? "XDT" : "XCT:BIL:URG_dtbbksw";
            }
            case BBK_HBV_FOREIGN_TRANSFER_NON_EUR: {
                return isOrderType ? "XWT" : "XCT:BIL:URG_wtbbksw";
            }
            case BBK_HBV_DOMESTIC_SWIFT_TRANSFER: {
                return isOrderType ? "XG2" : "DCT:BIL:URG_gtbbksw";
            }
            case BBK_HBV_DOMESTIC_DTA_TRANSFER: {
                return isOrderType ? "XG1" : "DCT:BIL:URG_gtdta";
            }
            case BBK_HBV_TARGET2_TRANSFER: {
                return isOrderType ? "XTG" : "XCT:BIL:URG_tgbbksw";
            }
            case BBK_EMZ_DTA_TRANSFER: {
                return isOrderType ? "XGK" : "DCT:BIL_gkdta";
            }
            case BBK_EMZ_DTA_DIRECT_DEBIT: {
                return isOrderType ? "XLK" : "DDD:BIL_lkdta";
            }
            case BBK_EMZ_STEP2_TRANSFER: {
                return isOrderType ? "XGS" : "DCT:BIL_gsbbksw";
            }
            case BBK_EMZ_PACKED_DTA_TRANSFER: {
                return isOrderType ? "XCG" : "DCT:BIL_cgdta";
            }
            case BBK_EMZ_PACKED_DTA_DIRECT_DEBIT: {
                return isOrderType ? "XCL" : "DDD:BIL_cldta";
            }
            case BBK_EMZ_PACKED_STEP2_TRANSFER: {
                return isOrderType ? "XCS" : "DCT:BIL_csdta";
            }
        }
        return null;
    }

    private static String getDefaultSendParameterVop(PaymentTransferType.PmtType pmtType, String countryCode, boolean isOrderType) {
        switch (pmtType) {
            case SEPA_TRANSFER: 
            case SEPA_NON_SEPA_COUNTRY_TRANSFER: 
            case AUSTRIAN_TAX_PAYMENT: 
            case AUSTRIAN_POSTBAR_PAYMENT: 
            case SEPA_CONFIDENTAL_TRANSFER: {
                if (AT.equals(countryCode)) {
                    return SendParameterUtil.getDefaultAustrianSendParameter(isOrderType, "CTV");
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, "CTV");
            }
            case SEPA_INSTANT_TRANSFER: {
                if (AT.equals(countryCode)) {
                    return SendParameterUtil.getDefaultAustrianSendParameter(isOrderType, "CIV");
                }
                return SendParameterUtil.getDefaultSendParameter(isOrderType, "CIV");
            }
        }
        return null;
    }

    private static String getDefaultSendParameter(boolean isOrderType, PaymentTransferType.PmtType pmtType) {
        return SendParameterUtil.getDefaultSendParameter(isOrderType, pmtType.getHandlerKey());
    }

    private static String getDefaultSendParameter(boolean isOrderType, String transferType) {
        return isOrderType ? transferType : BTFTranslator.getBTFFromSendOrderType(transferType);
    }

    private static String getDefaultAustrianSendParameter(boolean isOrderType, String transferType) {
        return isOrderType ? transferType : AustrianBTFTranslator.getBTFFromSendOrderType(transferType);
    }

    private static String getDefaultSwissSendParameter(boolean isOrderType, String transferType) {
        return isOrderType ? transferType : SwissBTFTranslator.getBTFFromSendOrderType(transferType);
    }

    static {
        SendParameterUtil.addContainerTransferType("CCC", PaymentTransferType.PmtType.SEPA_TRANSFER);
        SendParameterUtil.addContainerTransferType("CDC", PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT);
        SendParameterUtil.addContainerTransferType("C2C", PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT);
        SendParameterUtil.addContainerTransferType("CCS", PaymentTransferType.PmtType.SEPA_TRANSFER);
        SendParameterUtil.addContainerTransferType("CDS", PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT);
        SendParameterUtil.addContainerTransferType("C2S", PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT);
        SendParameterUtil.addContainerTransferType("CCX", PaymentTransferType.PmtType.SEPA_TRANSFER);
        SendParameterUtil.addContainerTransferType("CDX", PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT);
        SendParameterUtil.addContainerTransferType("C2X", PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT);
    }
}

