/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import java.util.Locale;

public class SendOrderNameHandler {
    private final boolean displaySpecialName;

    public SendOrderNameHandler(User user) {
        this.displaySpecialName = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.DISPLAY_ORDERS_AS_TEXT);
    }

    public boolean displaySpecialName() {
        return this.displaySpecialName;
    }

    public final String getName(String generalizedOrderType, String orderNumber, Locale locale) {
        return this.getName(generalizedOrderType, orderNumber, locale, true);
    }

    public final String getName(String generalizedOrderType, String orderNumber, Locale locale, boolean usedInOverviewTable) {
        String specialName;
        if (this.displaySpecialName && (specialName = this.getSpecialName(generalizedOrderType, orderNumber, locale)) != null) {
            return specialName;
        }
        if (usedInOverviewTable) {
            return PaymentTypeUtil.geOrderIdentification(generalizedOrderType, orderNumber);
        }
        return GeneralMessages.getInstance((Locale)locale).ORDER + " " + PaymentTypeUtil.geOrderIdentification(generalizedOrderType, orderNumber);
    }

    public String getSpecialName(String generalizedOrderType, String orderNumber, Locale locale) {
        return null;
    }
}

