/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.core.GeneralTexts;
import de.businesslogics.format.sepa.RegReporting;
import de.businesslogics.format.sepa.RegReportingDetail;
import de.businesslogics.util.StringUtils;
import java.util.List;
import java.util.Locale;

public class RegReportingUtil {
    private static RegReportingUtil myInstance;
    private CountriesLoader countriesLoader;

    private RegReportingUtil(Locale locale) {
        this.countriesLoader = CountriesLoader.getInstance(locale);
    }

    public static RegReportingUtil getInstance(Locale locale) {
        if (myInstance == null) {
            myInstance = new RegReportingUtil(locale);
        }
        return myInstance;
    }

    private String getCountryName(String countryCode) {
        String countryName = this.countriesLoader.getCountryName(countryCode);
        if (countryName != null) {
            return countryName;
        }
        return countryCode;
    }

    public String getRepresentation(List<RegReporting> reportings) {
        if (reportings == null || reportings.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (RegReporting reporting : reportings) {
            if (sb.length() > 0) {
                sb.append("\n");
                sb.append("\n");
            }
            sb.append(this.getRepresentation(reporting));
        }
        return sb.toString();
    }

    private String getRepresentation(RegReporting r) {
        StringBuilder sb = new StringBuilder();
        if (r.getCreditDebitIndicator() != null) {
            sb.append(BankingApiMessages.getString("RegulatoryReporting.party", new Object[0]) + ": ");
            sb.append(r.getCreditDebitIndicator());
        }
        String authCountry = StringUtils.checkNullAndTrim(r.getAuthorityCountry());
        String authName = StringUtils.checkNullAndTrim(r.getAuthorityName());
        if (authCountry.length() > 0 || authName.length() > 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(GeneralTexts.DEFAULT.COUNTRY + ": ");
            if (authCountry.length() > 0) {
                sb.append(this.getCountryName(authCountry));
            }
            if (authName.length() > 0) {
                if (authCountry.length() > 0) {
                    sb.append(" - ");
                }
                sb.append(authName);
            }
        }
        int countDetails = r.getDetails().size();
        for (int i = 0; i < countDetails; ++i) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(this.getRepresentation(r.getDetails().get(i)));
        }
        return sb.toString();
    }

    private String getRepresentation(RegReportingDetail d) {
        int countInfs;
        StringBuilder sb = new StringBuilder();
        if (d.getType() != null) {
            sb.append(GeneralTexts.DEFAULT.TYPE + ": ");
            sb.append(d.getType());
        }
        if (d.getCode() != null) {
            if (sb.length() > 0) {
                sb.append("   ");
            }
            sb.append(GeneralTexts.DEFAULT.CODE + ": ");
            sb.append(d.getCode());
        }
        if ((countInfs = d.getInfs().size()) > 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(GeneralTexts.DEFAULT.ADDITIONAL_INFORMATION + ": ");
        }
        for (int i = 0; i < countInfs; ++i) {
            sb.append(d.getInfs().get(i));
            if (i >= countInfs - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

